/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement;
import org.springframework.web.servlet.view.path.Permutation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsBeanUtilsPath {
    public static final String NONE = "NONE";
    public static final String SIMPLE = "SIMPLE";
    public static final String DEAP = "DEAP";
    public static final int SHORT = 0;
    public static final int NORMAL = 1;
    private CommonsBeanUtilsPathElement[] elements;
    private int mode;

    public CommonsBeanUtilsPath(CommonsBeanUtilsPathElement[] elements, int mode) {
        this.elements = elements;
        this.mode = mode;
    }

    private StringBuffer toStringBuffer() {
        CommonsBeanUtilsPathElement e;
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < this.elements.length - 1; ++i) {
            e = this.elements[i];
            if (e.getTyp().equals((Object)CommonsBeanUtilsPathElement.Typ.MAP)) {
                if (!this.parentIsArray(i)) {
                    buffer.append(e.getName());
                }
                if (this.parentIsMap(i)) {
                    buffer.append(')');
                }
                if (!this.hasChild(i)) continue;
                buffer.append('(');
                continue;
            }
            if (e.getTyp().equals((Object)CommonsBeanUtilsPathElement.Typ.SIMPEL)) {
                if (!this.parentIsArray(i)) {
                    buffer.append(e.getName());
                }
                if (this.parentIsMap(i)) {
                    buffer.append(')');
                }
                if (!this.hasChild(i)) continue;
                buffer.append('.');
                continue;
            }
            if (!this.parentIsArray(i)) {
                buffer.append(e.getName());
            }
            if (this.parentIsMap(i)) {
                buffer.append(')');
            }
            if (this.hasChild(i) && !this.childIsBean(i)) {
                buffer.append('[').append(this.getChild(i - 1).getIndex() - 1).append(']');
                continue;
            }
            if (!this.hasChild(i)) continue;
            buffer.append('[').append(this.getChild(i).getIndex() - 1).append(']');
        }
        if (this.mode != 0) {
            i = this.elements.length - 1;
            e = this.elements[i];
            if (this.parentIsArray(i)) {
                buffer.append('[').append(e.getIndex()).append(']');
            } else if (this.parentIsMap(i)) {
                buffer.append('(').append(e.getName()).append(')');
            } else {
                buffer.append('.').append(e.getName());
            }
        }
        return buffer;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    private boolean parentIsMap(int index) {
        if (index > 0) {
            return CommonsBeanUtilsPathElement.Typ.MAP.equals((Object)this.elements[index - 1].getTyp());
        }
        return false;
    }

    private boolean parentIsArray(int index) {
        if (index > 0) {
            return CommonsBeanUtilsPathElement.Typ.ARRAY.equals((Object)this.elements[index - 1].getTyp());
        }
        return false;
    }

    private boolean hasChild(int index) {
        return this.elements.length - 1 > index + 1;
    }

    private boolean childIsBean(int index) {
        if (this.elements.length - 1 > index + 2 && index > 2) {
            CommonsBeanUtilsPathElement.Typ child1_Typ = this.elements[index - 1].getTyp();
            CommonsBeanUtilsPathElement.Typ child2_Typ = this.elements[index - 2].getTyp();
            return CommonsBeanUtilsPathElement.Typ.SIMPEL.equals((Object)child1_Typ) && CommonsBeanUtilsPathElement.Typ.SIMPEL.equals((Object)child2_Typ);
        }
        return false;
    }

    private CommonsBeanUtilsPathElement getChild(int index) {
        return this.elements[index + 1];
    }

    public Set<String> getImplicitIndexedPath(String deep) {
        return this.getImplicitIndexedPath(this.toStringBuffer(), deep);
    }

    public Set<String> getImplicitIndexedPath(StringBuffer sb, String deep) {
        HashSet<String> implicitIndexedPaths = new HashSet<String>();
        if (NONE.equals(deep)) {
            implicitIndexedPaths.add(sb.toString());
        } else if (SIMPLE.equals(deep)) {
            implicitIndexedPaths.add(sb.toString());
            int startindex = sb.lastIndexOf("[");
            int endindex = sb.lastIndexOf("]");
            int endindex1 = sb.lastIndexOf("].");
            int lastDot1 = sb.lastIndexOf(".");
            if (endindex == sb.length() - 1) {
                sb.delete(startindex, endindex + 1);
            } else if (endindex1 + 1 == lastDot1) {
                sb.delete(startindex, endindex + 1);
            }
            implicitIndexedPaths.add(sb.toString());
        } else if (DEAP.equals(deep)) {
            ArrayList<int[]> iLst = new ArrayList<int[]>();
            int startindex = sb.indexOf("[", 0);
            int endindex = sb.indexOf("]", 0);
            while (startindex != -1) {
                iLst.add(new int[]{startindex, endindex});
                startindex = sb.indexOf("[", endindex + 1);
                endindex = sb.indexOf("]", endindex + 1);
            }
            Integer[][] perm = Permutation.power(iLst.size());
            for (int i = 0; i < perm.length; ++i) {
                StringBuffer ib = new StringBuffer().append(sb);
                int delta = 0;
                Integer[] replaceIndexs = perm[i];
                for (int j = 0; j < replaceIndexs.length; ++j) {
                    int[] ix = (int[])iLst.get(replaceIndexs[j]);
                    ib.delete(ix[0] - delta, ix[1] + 1 - delta);
                    delta = delta + ix[1] - ix[0] + 1;
                }
                implicitIndexedPaths.add(ib.toString());
            }
        } else if (!NONE.equals(deep)) {
            throw new IllegalArgumentException("Argument : " + deep + " unknown. Please use NONE, SIMPLE, DEAP");
        }
        return implicitIndexedPaths;
    }
}

