/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.writer.xstream.core;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.beans.PropertyEditor;
import java.util.Iterator;
import org.springframework.web.servlet.view.json.writer.xstream.converter.CustomEditorConverter;
import org.springframework.web.servlet.view.json.writer.xstream.core.PropertyEditorRegistryConverterLookup;
import org.springframework.web.servlet.view.json.writer.xstream.io.CustomPathExtendedHierarchicalStreamWriter;
import org.springframework.web.servlet.view.path.CommonsBeanUtilslPathTracker;

public class CustomEditorMarshaller
extends TreeMarshaller {
    private CommonsBeanUtilslPathTracker pathTracker = new CommonsBeanUtilslPathTracker();
    private boolean convertAllMapValues;
    private String rootname;
    private DataHolder dataHolder;

    public CustomEditorMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper, int mode, boolean convertAllMapValues, String rootname) {
        super(writer, converterLookup, mapper);
        this.convertAllMapValues = convertAllMapValues;
        this.rootname = rootname;
        if (writer instanceof CustomPathExtendedHierarchicalStreamWriter) {
            ((CustomPathExtendedHierarchicalStreamWriter)writer).setCommonsBeanUtilslPathTracker(this.pathTracker);
        }
    }

    public void start(Object item, DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        if (item == null) {
            throw new UnsupportedOperationException("Model Map is null!");
        }
        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)this.writer, (String)this.rootname, item.getClass());
        this.convertAnother(item);
        this.writer.endNode();
    }

    public Object get(Object key) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(key);
    }

    public void put(Object key, Object value) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key, value);
    }

    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    public void convertAnother(Object item, Converter converter) {
        PropertyEditor pe = null;
        PropertyEditorRegistryConverterLookup lookup = (PropertyEditorRegistryConverterLookup)this.converterLookup;
        if (lookup.existsPropertyEditorRegistry()) {
            String p;
            String path = this.pathTracker.getPath().toString();
            if (path.equals(p = path.replaceAll("^map\\(" + lookup.getBindingResult().getObjectName() + "\\).", "")) && this.convertAllMapValues) {
                p = path.replaceAll("^map", "");
                pe = lookup.getPropertyEditorRegistry().findCustomEditor(item.getClass(), p);
            } else if (!path.equals(p)) {
                pe = lookup.getPropertyEditorRegistry().findCustomEditor(item.getClass(), p);
            }
        }
        if (pe != null) {
            converter = new CustomEditorConverter(pe);
        }
        super.convertAnother(item, converter);
    }
}

