/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.filter;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.view.json.JsonViewFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyFilter
implements JsonViewFilter {
    private Log log = LogFactory.getLog(SimplePropertyFilter.class);
    private List<String> excludeBeforePropNames;
    private List<String> excludeBeforeErrorsPropNames;
    private List<String> excludeBeforeSuccessPropNames;

    public SimplePropertyFilter() {
        this.setUpBeanUtils();
    }

    protected void setUpBeanUtils() {
        ConvertUtilsBean cub = BeanUtilsBean.getInstance().getConvertUtils();
        cub.deregister(Boolean.class);
        cub.deregister(Boolean.TYPE);
        cub.deregister(Byte.class);
        cub.deregister(Byte.TYPE);
        cub.deregister(Character.class);
        cub.deregister(Character.TYPE);
        cub.deregister(Double.class);
        cub.deregister(Double.TYPE);
        cub.deregister(Float.class);
        cub.deregister(Float.TYPE);
        cub.deregister(Long.class);
        cub.deregister(Long.TYPE);
        cub.deregister(Short.class);
        cub.deregister(Short.TYPE);
    }

    @Override
    public void filterBeforePopulate(Map model, String commandName) throws Exception {
        this.filter(model, this.excludeBeforePropNames, commandName);
    }

    @Override
    public void filterBeforePopulateErrors(Map model, String commandName) throws Exception {
        this.filter(model, this.excludeBeforeErrorsPropNames, commandName);
    }

    @Override
    public void filterBeforePopulateSuccess(Map model, String commandName) throws Exception {
        this.filter(model, this.excludeBeforeSuccessPropNames, commandName);
    }

    private void filter(Map model, List<String> properties, String commandName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (properties != null) {
            for (String prop : properties) {
                this.removePropertyValue(model, prop, commandName);
            }
        }
    }

    private void removePropertyValue(Map model, String property, String commandName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        block5: {
            String p = null;
            p = property.matches("^\\(.+\\)|^\\(.+\\)\\..+") ? property.replaceFirst("\\(", "").replaceFirst("\\)", "") : commandName + "." + property;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(p + " = " + BeanUtils.getProperty((Object)model, (String)p)));
                }
                BeanUtils.setProperty((Object)model, (String)p, null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(p + " set to " + BeanUtils.getProperty((Object)model, (String)p)));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"======================================");
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug((Object)("Error excluding property: " + p + ": " + e.toString()));
            }
        }
    }

    public List<String> getExcludeBeforePropNames() {
        return this.excludeBeforePropNames;
    }

    public void setExcludeBeforePropNames(List<String> excludeBeforePropNames) {
        this.excludeBeforePropNames = excludeBeforePropNames;
    }

    public List<String> getExcludeBeforeErrorsPropNames() {
        return this.excludeBeforeErrorsPropNames;
    }

    public void setExcludeBeforeErrorsPropNames(List<String> excludeBeforeErrorsPropNames) {
        this.excludeBeforeErrorsPropNames = excludeBeforeErrorsPropNames;
    }

    public List<String> getExcludeBeforeSuccessPropNames() {
        return this.excludeBeforeSuccessPropNames;
    }

    public void setExcludeBeforeSuccessPropNames(List<String> excludeBeforeSuccessPropNames) {
        this.excludeBeforeSuccessPropNames = excludeBeforeSuccessPropNames;
    }
}

