/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.exception;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.json.JsonErrorHandler;
import org.springframework.web.servlet.view.json.JsonExceptionHandler;
import org.springframework.web.servlet.view.json.exception.StackTraceExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonExceptionResolver
implements HandlerExceptionResolver {
    private String exceptionView;
    private List<JsonExceptionHandler> exceptionHandler = new ArrayList<JsonExceptionHandler>();
    private List<JsonErrorHandler> errorHandler = new ArrayList<JsonErrorHandler>();

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionView == null || "".equals(this.exceptionView)) {
            throw new IllegalArgumentException("Please set the name of the JsonView");
        }
        ModelAndView mv = new ModelAndView(this.exceptionView);
        HashMap model = new HashMap();
        try {
            this.triggerExceptionHandler(ex, model, request, response);
            this.triggerErrorHandler(model, request, response);
            if (!(this.exceptionHandler != null && this.exceptionHandler.size() != 0 || this.errorHandler != null && this.errorHandler.size() != 0)) {
                throw new IllegalArgumentException("No JsonExceptionHandler or JsonErrorHandler registered!");
            }
        }
        catch (Exception e) {
            StackTraceExceptionHandler errHandler = new StackTraceExceptionHandler();
            try {
                errHandler.triggerException(e, model, request, response);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        mv.addAllObjects(model);
        return mv;
    }

    protected void triggerErrorHandler(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.errorHandler == null || this.errorHandler.size() == 0) {
            return;
        }
        for (JsonErrorHandler error : this.errorHandler) {
            error.triggerError(model, null, null, request, response);
        }
    }

    protected void triggerExceptionHandler(Exception ex, Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.exceptionHandler == null || this.exceptionHandler.size() == 0) {
            return;
        }
        for (JsonExceptionHandler exception : this.exceptionHandler) {
            exception.triggerException(ex, model, request, response);
        }
    }

    public String getExceptionView() {
        return this.exceptionView;
    }

    public void setExceptionView(String exceptionView) {
        this.exceptionView = exceptionView;
    }

    public List<JsonExceptionHandler> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(List<JsonExceptionHandler> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public List<JsonErrorHandler> getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(List<JsonErrorHandler> errorHandler) {
        this.errorHandler = errorHandler;
    }
}

