/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import py4j.reflection.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMView {
    private ConcurrentMap<String, String> singleImportsMap;
    private Set<String> starImports;
    private Set<String> lastImportSearches;
    private String name;
    private String id;
    public static final String JAVA_LANG_STAR_IMPORT = "java.lang";

    public JVMView(String name, String id) {
        this.name = name;
        this.id = id;
        this.starImports = new ConcurrentSkipListSet<String>();
        this.lastImportSearches = new ConcurrentSkipListSet<String>();
        this.singleImportsMap = new ConcurrentHashMap<String, String>();
        this.starImports.add(JAVA_LANG_STAR_IMPORT);
    }

    public void addSingleImport(String singleImport) {
        String simpleName = TypeUtil.getName(singleImport, true);
        this.singleImportsMap.putIfAbsent(simpleName, singleImport);
    }

    public void addStarImport(String starImport) {
        String packageName = TypeUtil.getPackage(starImport);
        if (!this.starImports.contains(packageName)) {
            this.starImports.add(packageName);
        }
    }

    public void clearImports() {
        this.singleImportsMap.clear();
        this.starImports.clear();
        this.starImports.add(JAVA_LANG_STAR_IMPORT);
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getLastImportSearches() {
        return this.lastImportSearches;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getSingleImportsMap() {
        return this.singleImportsMap;
    }

    public Set<String> getStarImports() {
        return this.starImports;
    }

    public boolean removeSingleImport(String importString) {
        boolean removed = false;
        String simpleName = TypeUtil.getName(importString, true);
        removed = this.singleImportsMap.remove(simpleName, importString);
        return removed;
    }

    public boolean removeStarImport(String starImport) {
        String packageName = TypeUtil.getPackage(starImport);
        return this.starImports.remove(packageName);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }
}

