/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.localization.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.oval.Validator;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.localization.message.MessageResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageResolver
implements MessageResolver {
    private static final Log LOG = Log.getLog(ResourceBundleMessageResolver.class);
    public static final ResourceBundleMessageResolver INSTANCE = new ResourceBundleMessageResolver();
    public static final Locale ROOT_LOCALE = new Locale("", "", "");
    private final Map<ResourceBundle, List<String>> messageBundleKeys = Validator.getCollectionFactory().createMap(8);
    private final Map<Locale, ArrayList<ResourceBundle>> messageBundlesByLocale = Validator.getCollectionFactory().createMap(8);

    public boolean addMessageBundle(ResourceBundle mb) {
        return this.addMessageBundle(mb, mb.getLocale());
    }

    protected boolean addMessageBundle(ResourceBundle bundle, Locale locale) {
        ArrayList<ResourceBundle> bundles = this.getMessageBundlesForLocale(locale);
        if (bundles.contains(bundle)) {
            return false;
        }
        bundles.add(0, bundle);
        if (!this.messageBundleKeys.containsKey(bundle)) {
            List keys = Validator.getCollectionFactory().createList();
            Enumeration<String> keysEnum = bundle.getKeys();
            while (keysEnum.hasMoreElements()) {
                keys.add(keysEnum.nextElement());
            }
            this.messageBundleKeys.put(bundle, keys);
        }
        return true;
    }

    @Override
    public String getMessage(String key) {
        Locale l = Validator.getLocaleProvider().getLocale();
        String msg = this.getMessage(key, l);
        if (msg == null && !l.equals(Locale.getDefault())) {
            msg = this.getMessage(key, Locale.getDefault());
        }
        return msg;
    }

    protected String getMessage(String key, Locale locale) {
        ArrayList<ResourceBundle> bundles = this.getMessageBundlesForLocale(locale);
        for (ResourceBundle bundle : bundles) {
            List<String> keys = this.messageBundleKeys.get(bundle);
            if (!keys.contains(key)) continue;
            return bundle.getString(key);
        }
        if (locale.getCountry().length() > 0) {
            return this.getMessage(key, new Locale(locale.getLanguage(), "", ""));
        }
        if (locale.getLanguage().length() > 0) {
            return this.getMessage(key, ROOT_LOCALE);
        }
        return null;
    }

    private ArrayList<ResourceBundle> getMessageBundlesForLocale(Locale locale) {
        Assert.argumentNotNull("locale", locale);
        ArrayList<ResourceBundle> bundles = this.messageBundlesByLocale.get(locale);
        if (bundles == null) {
            bundles = new ArrayList();
            this.messageBundlesByLocale.put(locale, bundles);
            try {
                this.addMessageBundle(ResourceBundle.getBundle("net/sf/oval/Messages", locale), locale);
            }
            catch (MissingResourceException ex) {
                LOG.debug("No message bundle net.sf.oval.Messages for locale %s found.", (Object)ex, locale);
            }
        }
        return bundles;
    }

    public boolean removeMessageBundle(ResourceBundle bundle) {
        ArrayList<ResourceBundle> bundles = this.getMessageBundlesForLocale(bundle.getLocale());
        if (!bundles.contains(bundle)) {
            return false;
        }
        bundles.remove(bundle);
        this.messageBundleKeys.remove(bundle);
        return true;
    }
}

