/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.sf.oval.Validator;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageScriptEngineImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageScriptEngineImpl.class);
    private static final ScriptEngineManager FACTORY = new ScriptEngineManager();
    private final Compilable compilable;
    private final ScriptEngine engine;
    private final ObjectCache<String, CompiledScript> compiledCache;

    static {
        List languages = Validator.getCollectionFactory().createList();
        for (ScriptEngineFactory ef : FACTORY.getEngineFactories()) {
            languages.add(ef.getNames());
        }
        LOG.info("Available ScriptEngine language names: {1}", languages);
    }

    public static ExpressionLanguageScriptEngineImpl get(String languageId) {
        ScriptEngine engine = FACTORY.getEngineByName(languageId);
        return engine == null ? null : new ExpressionLanguageScriptEngineImpl(engine);
    }

    private ExpressionLanguageScriptEngineImpl(ScriptEngine engine) {
        this.engine = engine;
        if (engine instanceof Compilable) {
            this.compilable = (Compilable)((Object)engine);
            this.compiledCache = new ObjectCache();
        } else {
            this.compilable = null;
            this.compiledCache = null;
        }
    }

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating JavaScript expression: {1}", expression);
        try {
            Bindings scope = this.engine.createBindings();
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                scope.put(entry.getKey(), entry.getValue());
            }
            if (this.compilable != null) {
                CompiledScript compiled = this.compiledCache.get(expression);
                if (compiled == null) {
                    compiled = this.compilable.compile(expression);
                    this.compiledCache.put(expression, compiled);
                }
                return compiled.eval(scope);
            }
            return this.engine.eval(expression, scope);
        }
        catch (ScriptException ex) {
            throw new ExpressionEvaluationException("Evaluating JavaScript expression failed: " + expression, ex);
        }
    }
}

