/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Future;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureCheck
extends AbstractAnnotationCheck<Future> {
    private static final long serialVersionUID = 1L;
    private long tolerance;

    @Override
    public void configure(Future constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setTolerance(constraintAnnotation.tolerance());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public long getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        long now = System.currentTimeMillis() - this.tolerance;
        if (valueToValidate instanceof Date) {
            return ((Date)valueToValidate).getTime() > now;
        }
        if (valueToValidate instanceof Calendar) {
            return ((Calendar)valueToValidate).getTime().getTime() > now;
        }
        String stringValue = valueToValidate.toString();
        try {
            return DateFormat.getDateTimeInstance().parse(stringValue).getTime() > now;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }
}

