/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.WeakHashMap;
import net.sf.oval.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializableConstructor
implements Serializable {
    private static final Log LOG = Log.getLog(SerializableConstructor.class);
    private static final WeakHashMap<Constructor<?>, SerializableConstructor> CACHE = new WeakHashMap();
    private static final long serialVersionUID = 1L;
    private transient Constructor<?> constructor;
    private final Class<?> declaringClass;
    private final Class<?>[] parameterTypes;

    public static SerializableConstructor getInstance(Constructor<?> constructor) {
        SerializableConstructor sm = CACHE.get(constructor);
        if (sm == null) {
            sm = new SerializableConstructor(constructor);
            CACHE.put(constructor, sm);
        }
        return sm;
    }

    private SerializableConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
        this.declaringClass = constructor.getDeclaringClass();
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.constructor = this.declaringClass.getDeclaredConstructor(this.parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            LOG.debug("Unexpected NoSuchMethodException occured", ex);
            throw new IOException(ex.getMessage());
        }
    }
}

