/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.integration.spring;

import net.sf.oval.internal.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SpringInjector {
    private static final Log LOG = Log.getLog(SpringInjector.class);
    private static SpringInjector INSTANCE;
    @Autowired
    private AutowiredAnnotationBeanPostProcessor processor;

    public static SpringInjector get() {
        Assert.notNull((Object)INSTANCE, (String)("No SpringInjector instance created yet. Add  <bean class=\"" + SpringInjector.class.getName() + "\" /> to your spring configuration!"));
        return INSTANCE;
    }

    private SpringInjector() {
        LOG.info("Instantiated.");
        INSTANCE = this;
    }

    public void inject(Object unmanagedBean) {
        this.processor.processInjection(unmanagedBean);
    }
}

