/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageOGNLImpl
implements ExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageOGNLImpl.class);
    private final ObjectCache<String, Object> expressionCache = new ObjectCache();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        try {
            OgnlContext ctx = (OgnlContext)Ognl.createDefaultContext(null);
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                ctx.put((Object)entry.getKey(), entry.getValue());
            }
            LOG.debug("Evaluating OGNL expression: {1}", expression);
            Object expr = this.expressionCache.get(expression);
            if (expr == null) {
                expr = Ognl.parseExpression((String)expression);
                this.expressionCache.put(expression, expr);
            }
            return Ognl.getValue((Object)expr, (Object)ctx);
        }
        catch (OgnlException ex) {
            throw new ExpressionEvaluationException("Evaluating script with OGNL failed.", ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (!(result instanceof Boolean)) {
            throw new ExpressionEvaluationException("The script must return a boolean value.");
        }
        return (Boolean)result;
    }
}

