/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageMVELImpl
implements ExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageMVELImpl.class);
    private final ObjectCache<String, Object> expressionCache = new ObjectCache();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        try {
            LOG.debug("Evaluating MVEL expression: {1}", expression);
            Object expr = this.expressionCache.get(expression);
            if (expr == null) {
                expr = MVEL.compileExpression((String)expression);
                this.expressionCache.put(expression, expr);
            }
            return MVEL.executeExpression((Object)expr, values);
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException("Evaluating script with MVEL failed.", ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (!(result instanceof Boolean)) {
            throw new ExpressionEvaluationException("The script must return a boolean value.");
        }
        return (Boolean)result;
    }
}

