/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageJEXLImpl
implements ExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageJEXLImpl.class);
    private static final JexlEngine jexl = new JexlEngine();
    private final ObjectCache<String, Expression> expressionCache = new ObjectCache();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        try {
            Expression expr = this.expressionCache.get(expression);
            if (expr == null) {
                expr = jexl.createExpression(expression);
                this.expressionCache.put(expression, expr);
            }
            MapContext ctx = new MapContext(values);
            LOG.debug("Evaluating JEXL expression: {1}", expression);
            return expr.evaluate((JexlContext)ctx);
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException("Evaluating script with JEXL failed.", ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (!(result instanceof Boolean)) {
            throw new ExpressionEvaluationException("The script must return a boolean value.");
        }
        return (Boolean)result;
    }
}

