/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import net.sf.oval.AbstractCheck;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.Validator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.configuration.CheckInitializationListener;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationCheck;
import net.sf.oval.configuration.annotation.AnnotationCheckExclusion;
import net.sf.oval.configuration.annotation.Constraint;
import net.sf.oval.configuration.annotation.Constraints;
import net.sf.oval.configuration.annotation.Exclusion;
import net.sf.oval.configuration.annotation.IsInvariant;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPostExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPreExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.exception.OValException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.guard.Guarded;
import net.sf.oval.guard.Post;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PostValidateThis;
import net.sf.oval.guard.Pre;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.guard.PreValidateThis;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.LinkedSet;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsConfigurer
implements Configurer {
    protected final Set<CheckInitializationListener> listeners = new LinkedSet<CheckInitializationListener>(2);

    private List<ParameterConfiguration> _createParameterConfiguration(Annotation[][] paramAnnotations, Class<?>[] parameterTypes) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<ParameterConfiguration> paramCfg = cf.createList(paramAnnotations.length);
        List<Check> paramChecks = cf.createList(2);
        List paramCheckExclusions = cf.createList(2);
        int i = 0;
        while (i < paramAnnotations.length) {
            Annotation[] annotationArray = paramAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                    paramChecks.add(this.initializeCheck(annotation));
                } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(annotation, paramChecks);
                } else if (annotation.annotationType().isAnnotationPresent(Exclusion.class)) {
                    paramCheckExclusions.add((CheckExclusion)this.initializeExclusion(annotation));
                }
                ++n2;
            }
            ParameterConfiguration pc = new ParameterConfiguration();
            paramCfg.add(pc);
            pc.type = parameterTypes[i];
            if (paramChecks.size() > 0) {
                pc.checks = paramChecks;
                paramChecks = cf.createList(2);
            }
            if (paramCheckExclusions.size() > 0) {
                pc.checkExclusions = paramCheckExclusions;
                paramCheckExclusions = cf.createList(2);
            }
            ++i;
        }
        return paramCfg;
    }

    public boolean addCheckInitializationListener(CheckInitializationListener listener) {
        Assert.argumentNotNull("listener", "[listener] must not be null");
        return this.listeners.add(listener);
    }

    protected void configureConstructorParameterChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        Constructor<?>[] constructorArray = classCfg.type.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ctor.getParameterAnnotations(), ctor.getParameterTypes());
            boolean postValidateThis = ctor.isAnnotationPresent(PostValidateThis.class);
            if (paramCfg.size() > 0 || postValidateThis) {
                if (classCfg.constructorConfigurations == null) {
                    classCfg.constructorConfigurations = cf.createSet(2);
                }
                ConstructorConfiguration cc = new ConstructorConfiguration();
                cc.parameterConfigurations = paramCfg;
                cc.postCheckInvariants = postValidateThis;
                classCfg.constructorConfigurations.add(cc);
            }
            ++n2;
        }
    }

    protected void configureFieldChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> checks = cf.createList(2);
        Field[] fieldArray = classCfg.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                    checks.add(this.initializeCheck(annotation));
                } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(annotation, checks);
                }
                ++n4;
            }
            if (checks.size() > 0) {
                if (classCfg.fieldConfigurations == null) {
                    classCfg.fieldConfigurations = cf.createSet(2);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                classCfg.fieldConfigurations.add(fc);
                checks = cf.createList(2);
            }
            ++n2;
        }
    }

    protected void configureMethodChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> returnValueChecks = cf.createList(2);
        List preChecks = cf.createList(2);
        List postChecks = cf.createList(2);
        Method[] methodArray = classCfg.type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            boolean preValidateThis = false;
            boolean postValidateThis = false;
            Annotation[] annotationArray = ReflectionUtils.getAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces));
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractCheck pc;
                Annotation annotation = annotationArray[n4];
                if (annotation instanceof Pre) {
                    pc = new PreCheck();
                    ((PreCheck)pc).configure((Pre)annotation);
                    preChecks.add(pc);
                } else if (annotation instanceof PreValidateThis) {
                    preValidateThis = true;
                } else if (annotation instanceof Post) {
                    pc = new PostCheck();
                    ((PostCheck)pc).configure((Post)annotation);
                    postChecks.add(pc);
                } else if (annotation instanceof PostValidateThis) {
                    postValidateThis = true;
                } else if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                    returnValueChecks.add(this.initializeCheck(annotation));
                } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(annotation, returnValueChecks);
                }
                ++n4;
            }
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ReflectionUtils.getParameterAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces)), method.getParameterTypes());
            if (paramCfg.size() > 0 || returnValueChecks.size() > 0 || preChecks.size() > 0 || postChecks.size() > 0 || preValidateThis || postValidateThis) {
                if (classCfg.methodConfigurations == null) {
                    classCfg.methodConfigurations = cf.createSet(2);
                }
                MethodConfiguration mc = new MethodConfiguration();
                mc.name = method.getName();
                mc.parameterConfigurations = paramCfg;
                mc.isInvariant = ReflectionUtils.isAnnotationPresent(method, IsInvariant.class, Boolean.TRUE.equals(classCfg.inspectInterfaces));
                mc.preCheckInvariants = preValidateThis;
                mc.postCheckInvariants = postValidateThis;
                if (returnValueChecks.size() > 0) {
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = returnValueChecks;
                    returnValueChecks = cf.createList(2);
                }
                if (preChecks.size() > 0) {
                    mc.preExecutionConfiguration = new MethodPreExecutionConfiguration();
                    mc.preExecutionConfiguration.checks = preChecks;
                    preChecks = cf.createList(2);
                }
                if (postChecks.size() > 0) {
                    mc.postExecutionConfiguration = new MethodPostExecutionConfiguration();
                    mc.postExecutionConfiguration.checks = postChecks;
                    postChecks = cf.createList(2);
                }
                classCfg.methodConfigurations.add(mc);
            }
            ++n2;
        }
    }

    protected void configureObjectLevelChecks(ClassConfiguration classCfg) {
        List<Check> checks = Validator.getCollectionFactory().createList(2);
        Annotation[] annotationArray = ReflectionUtils.getAnnotations(classCfg.type, Boolean.TRUE.equals(classCfg.inspectInterfaces));
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                checks.add(this.initializeCheck(annotation));
            } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                this.initializeChecks(annotation, checks);
            }
            ++n2;
        }
        if (checks.size() > 0) {
            classCfg.objectConfiguration = new ObjectConfiguration();
            classCfg.objectConfiguration.checks = checks;
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classCfg = new ClassConfiguration();
        classCfg.type = clazz;
        Guarded guarded = clazz.getAnnotation(Guarded.class);
        if (guarded == null) {
            classCfg.applyFieldConstraintsToConstructors = false;
            classCfg.applyFieldConstraintsToSetters = false;
            classCfg.assertParametersNotNull = false;
            classCfg.checkInvariants = false;
            classCfg.inspectInterfaces = false;
        } else {
            classCfg.applyFieldConstraintsToConstructors = guarded.applyFieldConstraintsToConstructors();
            classCfg.applyFieldConstraintsToSetters = guarded.applyFieldConstraintsToSetters();
            classCfg.assertParametersNotNull = guarded.assertParametersNotNull();
            classCfg.checkInvariants = guarded.checkInvariants();
            classCfg.inspectInterfaces = guarded.inspectInterfaces();
        }
        this.configureObjectLevelChecks(classCfg);
        this.configureFieldChecks(classCfg);
        this.configureConstructorParameterChecks(classCfg);
        this.configureMethodChecks(classCfg);
        return classCfg;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected <ConstraintAnnotation extends Annotation> AnnotationCheck<ConstraintAnnotation> initializeCheck(ConstraintAnnotation constraintAnnotation) throws ReflectionException {
        assert (constraintAnnotation != null);
        Constraint constraint = constraintAnnotation.annotationType().getAnnotation(Constraint.class);
        Class<AnnotationCheck<ConstraintAnnotation>> checkClass = constraint.checkWith();
        AnnotationCheck<ConstraintAnnotation> check = this.newCheckInstance(checkClass);
        check.configure(constraintAnnotation);
        for (CheckInitializationListener listener : this.listeners) {
            listener.onCheckInitialized(check);
        }
        return check;
    }

    protected <ConstraintsAnnotation extends Annotation> void initializeChecks(ConstraintsAnnotation constraintsAnnotation, List<Check> checks) throws ReflectionException {
        try {
            Object[] constraintAnnotations;
            Method getValue = constraintsAnnotation.annotationType().getDeclaredMethod("value", null);
            Object[] objectArray = constraintAnnotations = (Object[])getValue.invoke(constraintsAnnotation, null);
            int n = constraintAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Object ca = objectArray[n2];
                checks.add(this.initializeCheck((Annotation)ca));
                ++n2;
            }
        }
        catch (ReflectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException("Cannot initialize constraint check " + constraintsAnnotation.annotationType().getName(), ex);
        }
    }

    protected <ExclusionAnnotation extends Annotation> AnnotationCheckExclusion<ExclusionAnnotation> initializeExclusion(ExclusionAnnotation exclusionAnnotation) throws ReflectionException {
        assert (exclusionAnnotation != null);
        Exclusion constraint = exclusionAnnotation.annotationType().getAnnotation(Exclusion.class);
        Class<? extends AnnotationCheckExclusion<? extends Annotation>> exclusionClass = constraint.excludeWith();
        try {
            AnnotationCheckExclusion<? extends Annotation> exclusion = exclusionClass.newInstance();
            exclusion.configure(exclusionAnnotation);
            return exclusion;
        }
        catch (Exception ex) {
            throw new ReflectionException("Cannot initialize constraint exclusion " + exclusionClass.getName(), ex);
        }
    }

    protected <ConstraintAnnotation extends Annotation> AnnotationCheck<ConstraintAnnotation> newCheckInstance(Class<AnnotationCheck<ConstraintAnnotation>> checkClass) throws OValException {
        try {
            return checkClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ReflectionException("Cannot initialize constraint check " + checkClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException("Cannot initialize constraint check " + checkClass.getName(), ex);
        }
    }

    public boolean removeCheckInitializationListener(CheckInitializationListener listener) {
        return this.listeners.remove(listener);
    }
}

