/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.oval.Check;
import net.sf.oval.ConstraintSet;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.IValidator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.collection.CollectionFactoryJDKImpl;
import net.sf.oval.collection.CollectionFactoryJavalutionImpl;
import net.sf.oval.collection.CollectionFactoryTroveImpl;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.AssertConstraintSetCheck;
import net.sf.oval.constraint.AssertFieldConstraintsCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.context.ClassContext;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ConstraintSetAlreadyDefinedException;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.exception.FieldNotFoundException;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.MethodNotFoundException;
import net.sf.oval.exception.OValException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.exception.UndefinedConstraintSetException;
import net.sf.oval.exception.ValidationFailedException;
import net.sf.oval.expression.ExpressionLanguageRegistry;
import net.sf.oval.guard.ParameterNameResolver;
import net.sf.oval.guard.ParameterNameResolverEnumerationImpl;
import net.sf.oval.internal.ClassChecks;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.MessageRenderer;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.IdentitySet;
import net.sf.oval.internal.util.LinkedSet;
import net.sf.oval.internal.util.ReflectionUtils;
import net.sf.oval.internal.util.StringUtils;
import net.sf.oval.internal.util.ThreadLocalLinkedList;
import net.sf.oval.localization.context.OValContextRenderer;
import net.sf.oval.localization.context.ToStringValidationContextRenderer;
import net.sf.oval.localization.message.MessageResolver;
import net.sf.oval.localization.message.ResourceBundleMessageResolver;
import net.sf.oval.localization.value.MessageValueFormatter;
import net.sf.oval.localization.value.ToStringMessageValueFormatter;
import net.sf.oval.logging.LoggerFactory;
import net.sf.oval.ogn.ObjectGraphNavigationResult;
import net.sf.oval.ogn.ObjectGraphNavigatorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements IValidator {
    private static final Log LOG = Log.getLog(Validator.class);
    private static CollectionFactory collectionFactory = Validator._createDefaultCollectionFactory();
    private static OValContextRenderer contextRenderer = ToStringValidationContextRenderer.INSTANCE;
    private static MessageResolver messageResolver;
    private static MessageValueFormatter messageValueFormatter;
    private final Map<Class<?>, ClassChecks> checksByClass = new WeakHashMap();
    private final List<Configurer> configurers = new LinkedSet<Configurer>(4);
    private final Map<String, ConstraintSet> constraintSetsById = collectionFactory.createMap(4);
    protected final ThreadLocalLinkedList<Set<Object>> currentlyValidatedObjects = new ThreadLocalLinkedList();
    protected final ThreadLocalLinkedList<List<ConstraintViolation>> currentViolations = new ThreadLocalLinkedList();
    private final Set<String> disabledProfiles = collectionFactory.createSet();
    private final Set<String> enabledProfiles = collectionFactory.createSet();
    protected final ExpressionLanguageRegistry expressionLanguageRegistry = new ExpressionLanguageRegistry();
    private ExceptionTranslator exceptionTranslator;
    private boolean isAllProfilesEnabledByDefault = true;
    private boolean isProfilesFeatureUsed = false;
    protected final ObjectGraphNavigatorRegistry objectGraphNavigatorRegistry = new ObjectGraphNavigatorRegistry();
    protected final DelegatingParameterNameResolver parameterNameResolver = new DelegatingParameterNameResolver(new ParameterNameResolverEnumerationImpl());

    static {
        messageValueFormatter = ToStringMessageValueFormatter.INSTANCE;
    }

    private static CollectionFactory _createDefaultCollectionFactory() {
        if (ReflectionUtils.isClassPresent("javolution.util.FastMap") && ReflectionUtils.isClassPresent("javolution.util.FastSet") && ReflectionUtils.isClassPresent("javolution.util.FastTable")) {
            LOG.info("javolution.util collection classes are available.");
            return new CollectionFactoryJavalutionImpl();
        }
        if (ReflectionUtils.isClassPresent("gnu.trove.THashMap") && ReflectionUtils.isClassPresent("gnu.trove.THashSet")) {
            LOG.info("gnu.trove collection classes are available.");
            return new CollectionFactoryTroveImpl();
        }
        return new CollectionFactoryJDKImpl();
    }

    public static CollectionFactory getCollectionFactory() {
        return collectionFactory;
    }

    public static OValContextRenderer getContextRenderer() {
        return contextRenderer;
    }

    public static LoggerFactory getLoggerFactory() {
        return Log.getLoggerFactory();
    }

    public static MessageResolver getMessageResolver() {
        if (messageResolver == null) {
            messageResolver = ResourceBundleMessageResolver.INSTANCE;
        }
        return messageResolver;
    }

    public static MessageValueFormatter getMessageValueFormatter() {
        return messageValueFormatter;
    }

    public static void setCollectionFactory(CollectionFactory factory) throws IllegalArgumentException {
        Assert.argumentNotNull("factory", factory);
        collectionFactory = factory;
    }

    public static void setContextRenderer(OValContextRenderer contextRenderer) {
        Assert.argumentNotNull("contextRenderer", contextRenderer);
        Validator.contextRenderer = contextRenderer;
    }

    public static void setLoggerFactory(LoggerFactory loggerFactory) {
        Assert.argumentNotNull("loggerFactory", loggerFactory);
        Log.setLoggerFactory(loggerFactory);
    }

    public static void setMessageResolver(MessageResolver messageResolver) throws IllegalArgumentException {
        Assert.argumentNotNull("messageResolver", messageResolver);
        Validator.messageResolver = messageResolver;
    }

    public static void setMessageValueFormatter(MessageValueFormatter formatter) {
        Assert.argumentNotNull("formatter", formatter);
        messageValueFormatter = formatter;
    }

    public Validator() {
        ReflectionUtils.assertPrivateAccessAllowed();
        this.configurers.add(new AnnotationsConfigurer());
    }

    public Validator(Collection<Configurer> configurers) {
        ReflectionUtils.assertPrivateAccessAllowed();
        if (configurers != null) {
            this.configurers.addAll(configurers);
        }
    }

    public Validator(Configurer ... configurers) {
        ReflectionUtils.assertPrivateAccessAllowed();
        if (configurers != null) {
            Configurer[] configurerArray = configurers;
            int n = configurers.length;
            int n2 = 0;
            while (n2 < n) {
                Configurer configurer = configurerArray[n2];
                this.configurers.add(configurer);
                ++n2;
            }
        }
    }

    private void _addChecks(ClassChecks cc, ClassConfiguration classCfg) throws InvalidConfigurationException, ReflectionException {
        if (Boolean.TRUE.equals(classCfg.overwrite)) {
            cc.clear();
        }
        if (classCfg.checkInvariants != null) {
            cc.isCheckInvariants = classCfg.checkInvariants;
        }
        boolean applyFieldConstraintsToConstructors = Boolean.TRUE.equals(classCfg.applyFieldConstraintsToConstructors);
        boolean applyFieldConstraintsToSetters = Boolean.TRUE.equals(classCfg.applyFieldConstraintsToSetters);
        boolean assertParametersNotNull = Boolean.TRUE.equals(classCfg.assertParametersNotNull);
        NotNullCheck sharedNotNullCheck = assertParametersNotNull ? new NotNullCheck() : null;
        try {
            if (classCfg.objectConfiguration != null) {
                ObjectConfiguration objectCfg = classCfg.objectConfiguration;
                if (Boolean.TRUE.equals(objectCfg.overwrite)) {
                    cc.clearObjectChecks();
                }
                cc.addObjectChecks(objectCfg.checks);
            }
            if (classCfg.fieldConfigurations != null) {
                for (FieldConfiguration fieldCfg : classCfg.fieldConfigurations) {
                    Field field = classCfg.type.getDeclaredField(fieldCfg.name);
                    if (Boolean.TRUE.equals(fieldCfg.overwrite)) {
                        cc.clearFieldChecks(field);
                    }
                    if (fieldCfg.checks == null || fieldCfg.checks.size() <= 0) continue;
                    cc.addFieldChecks(field, fieldCfg.checks);
                }
            }
            if (classCfg.constructorConfigurations != null) {
                for (ConstructorConfiguration ctorCfg : classCfg.constructorConfigurations) {
                    if (ctorCfg.parameterConfigurations == null) continue;
                    Class[] paramTypes = new Class[ctorCfg.parameterConfigurations.size()];
                    int i = 0;
                    int l = ctorCfg.parameterConfigurations.size();
                    while (i < l) {
                        paramTypes[i] = ctorCfg.parameterConfigurations.get((int)i).type;
                        ++i;
                    }
                    Constructor<?> ctor = classCfg.type.getDeclaredConstructor(paramTypes);
                    if (Boolean.TRUE.equals(ctorCfg.overwrite)) {
                        cc.clearConstructorChecks(ctor);
                    }
                    if (Boolean.TRUE.equals(ctorCfg.postCheckInvariants)) {
                        cc.methodsWithCheckInvariantsPost.add(ctor);
                    }
                    String[] paramNames = this.parameterNameResolver.getParameterNames(ctor);
                    int i2 = 0;
                    int l2 = ctorCfg.parameterConfigurations.size();
                    while (i2 < l2) {
                        Field field;
                        ParameterConfiguration paramCfg = ctorCfg.parameterConfigurations.get(i2);
                        if (Boolean.TRUE.equals(paramCfg.overwrite)) {
                            cc.clearConstructorParameterChecks(ctor, i2);
                        }
                        if (paramCfg.hasChecks()) {
                            cc.addConstructorParameterChecks(ctor, i2, paramCfg.checks);
                        }
                        if (paramCfg.hasCheckExclusions()) {
                            cc.addConstructorParameterCheckExclusions(ctor, i2, paramCfg.checkExclusions);
                        }
                        if (assertParametersNotNull) {
                            cc.addConstructorParameterChecks(ctor, i2, sharedNotNullCheck);
                        }
                        if (applyFieldConstraintsToConstructors && (field = ReflectionUtils.getField(cc.clazz, paramNames[i2])) != null && paramTypes[i2].isAssignableFrom(field.getType())) {
                            AssertFieldConstraintsCheck check = new AssertFieldConstraintsCheck();
                            check.setFieldName(field.getName());
                            cc.addConstructorParameterChecks(ctor, i2, check);
                        }
                        ++i2;
                    }
                }
            }
            if (classCfg.methodConfigurations != null) {
                for (MethodConfiguration methodCfg : classCfg.methodConfigurations) {
                    Field field;
                    Method method;
                    if (methodCfg.parameterConfigurations == null || methodCfg.parameterConfigurations.size() == 0) {
                        method = classCfg.type.getDeclaredMethod(methodCfg.name, new Class[0]);
                    } else {
                        Class[] paramTypes = new Class[methodCfg.parameterConfigurations.size()];
                        int i = 0;
                        int l = methodCfg.parameterConfigurations.size();
                        while (i < l) {
                            paramTypes[i] = methodCfg.parameterConfigurations.get((int)i).type;
                            ++i;
                        }
                        method = classCfg.type.getDeclaredMethod(methodCfg.name, paramTypes);
                    }
                    if (Boolean.TRUE.equals(methodCfg.overwrite)) {
                        cc.clearMethodChecks(method);
                    }
                    if (applyFieldConstraintsToSetters && (field = ReflectionUtils.getFieldForSetter(method)) != null) {
                        AssertFieldConstraintsCheck check = new AssertFieldConstraintsCheck();
                        check.setFieldName(field.getName());
                        cc.addMethodParameterChecks(method, 0, check);
                    }
                    if (methodCfg.parameterConfigurations != null && methodCfg.parameterConfigurations.size() > 0) {
                        int i = 0;
                        int l = methodCfg.parameterConfigurations.size();
                        while (i < l) {
                            ParameterConfiguration paramCfg = methodCfg.parameterConfigurations.get(i);
                            if (Boolean.TRUE.equals(paramCfg.overwrite)) {
                                cc.clearMethodParameterChecks(method, i);
                            }
                            if (paramCfg.hasChecks()) {
                                cc.addMethodParameterChecks(method, i, paramCfg.checks);
                            }
                            if (paramCfg.hasCheckExclusions()) {
                                cc.addMethodParameterCheckExclusions(method, i, paramCfg.checkExclusions);
                            }
                            if (assertParametersNotNull) {
                                cc.addMethodParameterChecks(method, i, sharedNotNullCheck);
                            }
                            ++i;
                        }
                    }
                    if (methodCfg.returnValueConfiguration != null) {
                        if (Boolean.TRUE.equals(methodCfg.returnValueConfiguration.overwrite)) {
                            cc.clearMethodReturnValueChecks(method);
                        }
                        if (methodCfg.returnValueConfiguration.checks != null && methodCfg.returnValueConfiguration.checks.size() > 0) {
                            cc.addMethodReturnValueChecks(method, methodCfg.isInvariant, methodCfg.returnValueConfiguration.checks);
                        }
                    }
                    if (Boolean.TRUE.equals(methodCfg.preCheckInvariants)) {
                        cc.methodsWithCheckInvariantsPre.add(method);
                    }
                    if (methodCfg.preExecutionConfiguration != null) {
                        if (Boolean.TRUE.equals(methodCfg.preExecutionConfiguration.overwrite)) {
                            cc.clearMethodPreChecks(method);
                        }
                        if (methodCfg.preExecutionConfiguration.checks != null && methodCfg.preExecutionConfiguration.checks.size() > 0) {
                            cc.addMethodPreChecks(method, methodCfg.preExecutionConfiguration.checks);
                        }
                    }
                    if (Boolean.TRUE.equals(methodCfg.postCheckInvariants)) {
                        cc.methodsWithCheckInvariantsPost.add(method);
                    }
                    if (methodCfg.postExecutionConfiguration == null) continue;
                    if (Boolean.TRUE.equals(methodCfg.postExecutionConfiguration.overwrite)) {
                        cc.clearMethodPostChecks(method);
                    }
                    if (methodCfg.postExecutionConfiguration.checks == null || methodCfg.postExecutionConfiguration.checks.size() <= 0) continue;
                    cc.addMethodPostChecks(method, methodCfg.postExecutionConfiguration.checks);
                }
            }
        }
        catch (NoSuchMethodException ex) {
            throw new MethodNotFoundException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new FieldNotFoundException(ex);
        }
    }

    private void _checkConstraint(List<ConstraintViolation> violations, Check check, Object validatedObject, Object valueToValidate, OValContext context, String[] profiles) {
        if (check instanceof AssertValidCheck) {
            this.checkConstraintAssertValid(violations, (AssertValidCheck)check, validatedObject, valueToValidate, context, profiles);
            return;
        }
        if (check instanceof AssertConstraintSetCheck) {
            this.checkConstraintAssertConstraintSet(violations, (AssertConstraintSetCheck)check, validatedObject, valueToValidate, context, profiles);
            return;
        }
        if (check instanceof AssertFieldConstraintsCheck) {
            this.checkConstraintAssertFieldConstraints(violations, (AssertFieldConstraintsCheck)check, validatedObject, valueToValidate, context, profiles);
            return;
        }
        if (!check.isSatisfied(validatedObject, valueToValidate, context, this)) {
            String errorMessage = this.renderMessage(context, valueToValidate, check.getMessage(), check.getMessageVariables());
            violations.add(new ConstraintViolation(check, errorMessage, validatedObject, valueToValidate, context));
        }
    }

    private void _validateObjectInvariants(Object validatedObject, Class<?> clazz, List<ConstraintViolation> violations, String[] profiles) throws ValidationFailedException {
        assert (validatedObject != null);
        assert (clazz != null);
        assert (violations != null);
        if (clazz == Object.class) {
            return;
        }
        try {
            OValContext ctx;
            Object valueToValidate;
            Collection checks;
            ClassChecks cc = this.getClassChecks(clazz);
            for (Field field : cc.constrainedFields) {
                checks = cc.checksForFields.get(field);
                if (checks == null || checks.size() <= 0) continue;
                valueToValidate = ReflectionUtils.getFieldValue(field, validatedObject);
                ctx = ContextCache.getFieldContext(field);
                for (Check check : checks) {
                    this.checkConstraint(violations, check, validatedObject, valueToValidate, ctx, profiles, false, false);
                }
            }
            for (Method getter : cc.constrainedMethods) {
                checks = cc.checksForMethodReturnValues.get(getter);
                if (checks == null || checks.size() <= 0) continue;
                valueToValidate = ReflectionUtils.invokeMethod(getter, validatedObject, new Object[0]);
                ctx = ContextCache.getMethodReturnValueContext(getter);
                for (Check check : checks) {
                    this.checkConstraint(violations, check, validatedObject, valueToValidate, ctx, profiles, false, false);
                }
            }
            if (cc.checksForObject.size() > 0) {
                ClassContext ctx2 = ContextCache.getClassContext(clazz);
                for (Check check : cc.checksForObject) {
                    this.checkConstraint(violations, check, validatedObject, validatedObject, ctx2, profiles, false, false);
                }
            }
            this._validateObjectInvariants(validatedObject, clazz.getSuperclass(), violations, profiles);
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Object validation failed. Class: " + clazz + " Validated object: " + validatedObject, ex);
        }
    }

    private void _validateStaticInvariants(Class<?> validatedClass, List<ConstraintViolation> violations, String[] profiles) throws ValidationFailedException {
        OValContext context;
        Object valueToValidate;
        Collection checks;
        assert (validatedClass != null);
        assert (violations != null);
        ClassChecks cc = this.getClassChecks(validatedClass);
        for (Field field : cc.constrainedStaticFields) {
            checks = cc.checksForFields.get(field);
            if (checks == null || checks.size() <= 0) continue;
            valueToValidate = ReflectionUtils.getFieldValue(field, null);
            context = ContextCache.getFieldContext(field);
            for (Check check : checks) {
                this.checkConstraint(violations, check, validatedClass, valueToValidate, context, profiles, false, false);
            }
        }
        for (Method getter : cc.constrainedStaticMethods) {
            checks = cc.checksForMethodReturnValues.get(getter);
            if (checks == null || checks.size() <= 0) continue;
            valueToValidate = ReflectionUtils.invokeMethod(getter, null, new Object[0]);
            context = ContextCache.getMethodReturnValueContext(getter);
            for (Check check : checks) {
                this.checkConstraint(violations, check, validatedClass, valueToValidate, context, profiles, false, false);
            }
        }
    }

    public void addChecks(Class<?> clazz, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("clazz", clazz);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(clazz).addObjectChecks(checks);
    }

    public void addChecks(Field field, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("field", field);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(field.getDeclaringClass()).addFieldChecks(field, checks);
    }

    public void addChecks(Method invariantMethod, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("invariantMethod", invariantMethod);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(invariantMethod.getDeclaringClass()).addMethodReturnValueChecks(invariantMethod, Boolean.TRUE, checks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstraintSet(ConstraintSet constraintSet, boolean overwrite) throws ConstraintSetAlreadyDefinedException, IllegalArgumentException {
        Assert.argumentNotNull("constraintSet", constraintSet);
        Assert.argumentNotEmpty("constraintSet.id", constraintSet.getId());
        Map<String, ConstraintSet> map = this.constraintSetsById;
        synchronized (map) {
            if (!overwrite && this.constraintSetsById.containsKey(constraintSet.getId())) {
                throw new ConstraintSetAlreadyDefinedException(constraintSet.getId());
            }
            this.constraintSetsById.put(constraintSet.getId(), constraintSet);
        }
    }

    @Override
    public void assertValid(Object validatedObject) throws IllegalArgumentException, ValidationFailedException, ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validate(validatedObject);
        if (violations.size() > 0) {
            throw this.translateException(new ConstraintsViolatedException(violations));
        }
    }

    @Override
    public void assertValidFieldValue(Object validatedObject, Field validatedField, Object fieldValueToValidate) throws IllegalArgumentException, ValidationFailedException, ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validateFieldValue(validatedObject, validatedField, fieldValueToValidate);
        if (violations.size() > 0) {
            throw this.translateException(new ConstraintsViolatedException(violations));
        }
    }

    protected void checkConstraint(List<ConstraintViolation> violations, Check check, Object validatedObject, Object valueToValidate, OValContext context, String[] profiles, boolean isContainerValue, boolean ignoreTarget) throws OValException {
        boolean isContainer;
        boolean isMap;
        boolean isCollection;
        String target;
        if (!this.isAnyProfileEnabled(check.getProfiles(), profiles)) {
            return;
        }
        if (!check.isActive(validatedObject, valueToValidate, this)) {
            return;
        }
        ConstraintTarget[] targets = check.getAppliesTo();
        if (!ignoreTarget && (target = check.getTarget()) != null && (target = target.trim()).length() > 0) {
            String path;
            String ognId;
            if (valueToValidate == null) {
                return;
            }
            String[] chunks = target.split(":", 2);
            if (chunks.length == 1) {
                ognId = "";
                path = chunks[0];
            } else {
                ognId = chunks[0];
                path = chunks[1];
            }
            ObjectGraphNavigationResult result = this.objectGraphNavigatorRegistry.getObjectGraphNavigator(ognId).navigateTo(valueToValidate, path);
            if (result == null) {
                return;
            }
            validatedObject = result.targetParent;
            valueToValidate = result.target;
            context = result.targetAccessor instanceof Field ? ContextCache.getFieldContext((Field)result.targetAccessor) : ContextCache.getMethodReturnValueContext((Method)result.targetAccessor);
        }
        Class<?> compileTimeType = context.getCompileTimeType();
        boolean bl = valueToValidate != null ? valueToValidate instanceof Collection : (isCollection = compileTimeType != null && Collection.class.isAssignableFrom(compileTimeType));
        boolean bl2 = !isCollection && (valueToValidate != null ? valueToValidate instanceof Map : compileTimeType != null && Map.class.isAssignableFrom(compileTimeType)) ? true : (isMap = false);
        boolean isArray = !isCollection && !isMap && (valueToValidate != null ? valueToValidate.getClass().isArray() : compileTimeType != null && compileTimeType.isArray());
        boolean bl3 = isContainer = isCollection || isMap || isArray;
        if (isContainer && valueToValidate != null) {
            if (isCollection) {
                if (ArrayUtils.containsSame(targets, ConstraintTarget.VALUES)) {
                    for (Object item : (Collection)valueToValidate) {
                        this.checkConstraint(violations, check, validatedObject, item, context, profiles, true, true);
                    }
                }
            } else if (isMap) {
                if (ArrayUtils.containsSame(targets, ConstraintTarget.KEYS)) {
                    for (Object item : ((Map)valueToValidate).keySet()) {
                        this.checkConstraint(violations, check, validatedObject, item, context, profiles, true, true);
                    }
                }
                if (ArrayUtils.containsSame(targets, ConstraintTarget.VALUES)) {
                    for (Object item : ((Map)valueToValidate).values()) {
                        this.checkConstraint(violations, check, validatedObject, item, context, profiles, true, true);
                    }
                }
            } else if (ArrayUtils.containsSame(targets, ConstraintTarget.VALUES)) {
                for (Object item : ArrayUtils.asList(valueToValidate)) {
                    this.checkConstraint(violations, check, validatedObject, item, context, profiles, true, true);
                }
            }
        }
        if (isContainerValue || !isContainer || isContainer && ArrayUtils.containsSame(targets, ConstraintTarget.CONTAINER)) {
            this._checkConstraint(violations, check, validatedObject, valueToValidate, context, profiles);
        }
    }

    protected void checkConstraintAssertConstraintSet(List<ConstraintViolation> violations, AssertConstraintSetCheck check, Object validatedObject, Object valueToValidate, OValContext context, String[] profiles) throws OValException {
        ConstraintSet cs = this.getConstraintSet(check.getId());
        if (cs == null) {
            throw new UndefinedConstraintSetException(check.getId());
        }
        Collection<Check> referencedChecks = cs.getChecks();
        if (referencedChecks != null && referencedChecks.size() > 0) {
            for (Check referencedCheck : referencedChecks) {
                this.checkConstraint(violations, referencedCheck, validatedObject, valueToValidate, context, profiles, false, false);
            }
        }
    }

    protected void checkConstraintAssertFieldConstraints(List<ConstraintViolation> violations, AssertFieldConstraintsCheck check, Object validatedObject, Object valueToValidate, OValContext context, String[] profiles) throws OValException {
        Field field;
        Class<?> targetClass = check.getDeclaringClass() != null && check.getDeclaringClass() != Void.class ? check.getDeclaringClass() : (context instanceof ConstructorParameterContext ? ((ConstructorParameterContext)context).getConstructor().getDeclaringClass() : (context instanceof MethodParameterContext ? ((MethodParameterContext)context).getMethod().getDeclaringClass() : (context instanceof MethodReturnValueContext ? ((MethodReturnValueContext)context).getMethod().getDeclaringClass() : validatedObject.getClass())));
        String fieldName = check.getFieldName();
        if (fieldName == null || fieldName.length() == 0) {
            if (context instanceof ConstructorParameterContext) {
                fieldName = ((ConstructorParameterContext)context).getParameterName();
            } else if (context instanceof MethodParameterContext) {
                fieldName = ((MethodParameterContext)context).getParameterName();
            } else if (context instanceof MethodReturnValueContext) {
                fieldName = ReflectionUtils.guessFieldName(((MethodReturnValueContext)context).getMethod());
            }
        }
        if ((field = ReflectionUtils.getFieldRecursive(targetClass, fieldName)) == null) {
            throw new FieldNotFoundException("Field <" + fieldName + "> not found in class <" + targetClass + "> or its super classes.");
        }
        ClassChecks cc = this.getClassChecks(field.getDeclaringClass());
        Collection referencedChecks = cc.checksForFields.get(field);
        if (referencedChecks != null && referencedChecks.size() > 0) {
            for (Check referencedCheck : referencedChecks) {
                this.checkConstraint(violations, referencedCheck, validatedObject, valueToValidate, context, profiles, false, false);
            }
        }
    }

    protected void checkConstraintAssertValid(List<ConstraintViolation> violations, AssertValidCheck check, Object validatedObject, Object valueToValidate, OValContext context, String[] profiles) throws OValException {
        if (valueToValidate == null) {
            return;
        }
        if (this.isCurrentlyValidated(valueToValidate)) {
            return;
        }
        List<ConstraintViolation> additionalViolations = collectionFactory.createList();
        this.validateInvariants(valueToValidate, additionalViolations, profiles);
        if (additionalViolations.size() != 0) {
            String errorMessage = this.renderMessage(context, valueToValidate, check.getMessage(), check.getMessageVariables());
            violations.add(new ConstraintViolation((Check)check, errorMessage, validatedObject, valueToValidate, context, additionalViolations));
        }
    }

    public synchronized void disableAllProfiles() {
        this.isProfilesFeatureUsed = true;
        this.isAllProfilesEnabledByDefault = false;
        this.enabledProfiles.clear();
        this.disabledProfiles.clear();
    }

    public void disableProfile(String profile) {
        this.isProfilesFeatureUsed = true;
        if (this.isAllProfilesEnabledByDefault) {
            this.disabledProfiles.add(profile);
        } else {
            this.enabledProfiles.remove(profile);
        }
    }

    public synchronized void enableAllProfiles() {
        this.isProfilesFeatureUsed = true;
        this.isAllProfilesEnabledByDefault = true;
        this.enabledProfiles.clear();
        this.disabledProfiles.clear();
    }

    public void enableProfile(String profile) {
        this.isProfilesFeatureUsed = true;
        if (this.isAllProfilesEnabledByDefault) {
            this.disabledProfiles.remove(profile);
        } else {
            this.enabledProfiles.add(profile);
        }
    }

    public Check[] getChecks(Class<?> clazz) throws IllegalArgumentException {
        Assert.argumentNotNull("clazz", clazz);
        ClassChecks cc = this.getClassChecks(clazz);
        Set<Check> checks = cc.checksForObject;
        return checks == null ? null : checks.toArray(new Check[checks.size()]);
    }

    public Check[] getChecks(Field field) throws IllegalArgumentException {
        Assert.argumentNotNull("field", field);
        ClassChecks cc = this.getClassChecks(field.getDeclaringClass());
        Set<Check> checks = cc.checksForFields.get(field);
        return checks == null ? null : checks.toArray(new Check[checks.size()]);
    }

    public Check[] getChecks(Method method) throws IllegalArgumentException {
        Assert.argumentNotNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Set<Check> checks = cc.checksForMethodReturnValues.get(method);
        return checks == null ? null : checks.toArray(new Check[checks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassChecks getClassChecks(Class<?> clazz) throws IllegalArgumentException, InvalidConfigurationException, ReflectionException {
        Assert.argumentNotNull("clazz", clazz);
        Map<Class<?>, ClassChecks> map = this.checksByClass;
        synchronized (map) {
            ClassChecks cc = this.checksByClass.get(clazz);
            if (cc == null) {
                cc = new ClassChecks(clazz, this.parameterNameResolver);
                for (Configurer configurer : this.configurers) {
                    ClassConfiguration classConfig = configurer.getClassConfiguration(clazz);
                    if (classConfig == null) continue;
                    this._addChecks(cc, classConfig);
                }
                this.checksByClass.put(clazz, cc);
            }
            return cc;
        }
    }

    public List<Configurer> getConfigurers() {
        return this.configurers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintSet getConstraintSet(String constraintSetId) throws InvalidConfigurationException, IllegalArgumentException {
        Assert.argumentNotNull("constraintSetsById", this.constraintSetsById);
        Map<String, ConstraintSet> map = this.constraintSetsById;
        synchronized (map) {
            ConstraintSet cs = this.constraintSetsById.get(constraintSetId);
            if (cs == null) {
                for (Configurer configurer : this.configurers) {
                    ConstraintSetConfiguration csc = configurer.getConstraintSetConfiguration(constraintSetId);
                    if (csc == null) continue;
                    cs = new ConstraintSet(csc.id);
                    cs.setChecks(csc.checks);
                    this.addConstraintSet(cs, csc.overwrite != null && csc.overwrite != false);
                }
            }
            return cs;
        }
    }

    public ExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public ExpressionLanguageRegistry getExpressionLanguageRegistry() {
        return this.expressionLanguageRegistry;
    }

    public ObjectGraphNavigatorRegistry getObjectGraphNavigatorRegistry() {
        return this.objectGraphNavigatorRegistry;
    }

    protected boolean isAnyProfileEnabled(String[] profilesOfCheck, String[] enabledProfiles) {
        if (enabledProfiles == null) {
            if (profilesOfCheck == null || profilesOfCheck.length == 0) {
                return this.isProfileEnabled("default");
            }
            String[] stringArray = profilesOfCheck;
            int n = profilesOfCheck.length;
            int n2 = 0;
            while (n2 < n) {
                String profile = stringArray[n2];
                if (this.isProfileEnabled(profile)) {
                    return true;
                }
                ++n2;
            }
        } else {
            if (profilesOfCheck == null || profilesOfCheck.length == 0) {
                return ArrayUtils.containsEqual(enabledProfiles, "default");
            }
            String[] stringArray = profilesOfCheck;
            int n = profilesOfCheck.length;
            int n3 = 0;
            while (n3 < n) {
                String profile = stringArray[n3];
                if (ArrayUtils.containsEqual(enabledProfiles, profile)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    protected boolean isCurrentlyValidated(Object object) {
        Assert.argumentNotNull("object", object);
        return ((Set)((LinkedList)this.currentlyValidatedObjects.get()).getLast()).contains(object);
    }

    public boolean isProfileEnabled(String profileId) {
        Assert.argumentNotNull("profileId", profileId);
        if (this.isProfilesFeatureUsed) {
            if (this.isAllProfilesEnabledByDefault) {
                return !this.disabledProfiles.contains(profileId);
            }
            return this.enabledProfiles.contains(profileId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigureChecks() {
        Map<Object, Object> map = this.checksByClass;
        synchronized (map) {
            this.checksByClass.clear();
        }
        map = this.constraintSetsById;
        synchronized (map) {
            this.constraintSetsById.clear();
        }
    }

    public void removeChecks(Class<?> clazz, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("clazz", clazz);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(clazz).removeObjectChecks(checks);
    }

    public void removeChecks(Field field, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("field", field);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(field.getDeclaringClass()).removeFieldChecks(field, checks);
    }

    public void removeChecks(Method getter, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("getter", getter);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(getter.getDeclaringClass()).removeMethodReturnValueChecks(getter, checks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintSet removeConstraintSet(String id) throws IllegalArgumentException {
        Assert.argumentNotNull("id", id);
        Map<String, ConstraintSet> map = this.constraintSetsById;
        synchronized (map) {
            return this.constraintSetsById.remove(id);
        }
    }

    protected String renderMessage(OValContext context, Object value, String messageKey, Map<String, ?> messageValues) {
        String message = MessageRenderer.renderMessage(messageKey, messageValues);
        if (message.indexOf(123) == -1) {
            return message;
        }
        message = StringUtils.replaceAll(message, "{context}", contextRenderer.render(context));
        message = StringUtils.replaceAll(message, "{invalidValue}", messageValueFormatter.format(value));
        return message;
    }

    public void reportConstraintViolation(ConstraintViolation constraintViolation) {
        Assert.argumentNotNull("constraintViolation", constraintViolation);
        if (((LinkedList)this.currentViolations.get()).size() == 0) {
            throw new IllegalStateException("No active validation cycle found for the current thread.");
        }
        ((List)((LinkedList)this.currentViolations.get()).getLast()).add(constraintViolation);
    }

    public void setExceptionTranslator(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    protected RuntimeException translateException(OValException ex) {
        RuntimeException rex;
        if (this.exceptionTranslator != null && (rex = this.exceptionTranslator.translateException(ex)) != null) {
            return rex;
        }
        return ex;
    }

    @Override
    public List<ConstraintViolation> validate(Object validatedObject) throws IllegalArgumentException, ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        List<ConstraintViolation> violations = collectionFactory.createList();
        ((LinkedList)this.currentViolations.get()).add(violations);
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            this.validateInvariants(validatedObject, violations, null);
            List<ConstraintViolation> list = violations;
            return list;
        }
        finally {
            ((LinkedList)this.currentViolations.get()).removeLast();
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    @Override
    public List<ConstraintViolation> validate(Object validatedObject, String ... profiles) throws IllegalArgumentException, ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        List<ConstraintViolation> violations = collectionFactory.createList();
        ((LinkedList)this.currentViolations.get()).add(violations);
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            this.validateInvariants(validatedObject, violations, profiles);
            List<ConstraintViolation> list = violations;
            return list;
        }
        finally {
            ((LinkedList)this.currentViolations.get()).removeLast();
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    @Override
    public List<ConstraintViolation> validateFieldValue(Object validatedObject, Field validatedField, Object fieldValueToValidate) throws IllegalArgumentException, ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        Assert.argumentNotNull("validatedField", validatedField);
        List<ConstraintViolation> violations = collectionFactory.createList();
        ((LinkedList)this.currentViolations.get()).add(violations);
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            ClassChecks cc = this.getClassChecks(validatedField.getDeclaringClass());
            Collection checks = cc.checksForFields.get(validatedField);
            if (checks == null || checks.size() == 0) {
                List<ConstraintViolation> list = violations;
                return list;
            }
            FieldContext context = ContextCache.getFieldContext(validatedField);
            for (Check check : checks) {
                this.checkConstraint(violations, check, validatedObject, fieldValueToValidate, context, null, false, false);
            }
            List<ConstraintViolation> list = violations;
            return list;
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Field validation failed. Field: " + validatedField + " Validated object: " + validatedObject, ex);
        }
        finally {
            ((LinkedList)this.currentViolations.get()).removeLast();
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    protected void validateInvariants(Object validatedObject, List<ConstraintViolation> violations, String[] profiles) throws IllegalArgumentException, ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        ((Set)((LinkedList)this.currentlyValidatedObjects.get()).getLast()).add(validatedObject);
        if (validatedObject instanceof Class) {
            this._validateStaticInvariants((Class)validatedObject, violations, profiles);
        } else {
            this._validateObjectInvariants(validatedObject, validatedObject.getClass(), violations, profiles);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class DelegatingParameterNameResolver
    implements ParameterNameResolver {
        private ParameterNameResolver delegate;

        public DelegatingParameterNameResolver(ParameterNameResolver delegate) {
            this.delegate = delegate;
        }

        public ParameterNameResolver getDelegate() {
            return this.delegate;
        }

        @Override
        public String[] getParameterNames(Constructor<?> constructor) throws ReflectionException {
            return this.delegate.getParameterNames(constructor);
        }

        @Override
        public String[] getParameterNames(Method method) throws ReflectionException {
            return this.delegate.getParameterNames(method);
        }

        public void setDelegate(ParameterNameResolver delegate) {
            this.delegate = delegate;
        }
    }
}

