/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import net.sf.oval.exceptions.NestableIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableMethod
implements Serializable {
    private static final WeakHashMap<Method, SerializableMethod> CACHE = new WeakHashMap();
    private static final long serialVersionUID = 1L;
    private final Class<?> declaringClass;
    private transient Method method;
    private final String name;
    private final Class<?>[] parameterTypes;

    public static SerializableMethod getInstance(Method method) {
        SerializableMethod sm = CACHE.get(method);
        if (sm == null) {
            sm = new SerializableMethod(method);
            CACHE.put(method, sm);
        }
        return sm;
    }

    protected SerializableMethod(Method method) {
        this.method = method;
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.declaringClass = method.getDeclaringClass();
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.method = this.declaringClass.getMethod(this.name, this.parameterTypes);
        }
        catch (SecurityException e) {
            throw new NestableIOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NestableIOException(e);
        }
    }
}

