/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.WeakHashMap;
import net.sf.oval.exceptions.NestableIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableConstructor
implements Serializable {
    private static final WeakHashMap<Constructor<?>, SerializableConstructor> CACHE = new WeakHashMap();
    private static final long serialVersionUID = 1L;
    private transient Constructor<?> constructor;
    private final Class<?> declaringClass;
    private final Class<?>[] parameterTypes;

    public static SerializableConstructor getInstance(Constructor<?> constructor) {
        SerializableConstructor sm = CACHE.get(constructor);
        if (sm == null) {
            sm = new SerializableConstructor(constructor);
            CACHE.put(constructor, sm);
        }
        return sm;
    }

    protected SerializableConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
        this.declaringClass = constructor.getDeclaringClass();
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.constructor = this.declaringClass.getConstructor(this.parameterTypes);
        }
        catch (SecurityException e) {
            throw new NestableIOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NestableIOException(e);
        }
    }
}

