/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.oval.contexts.FieldContext;
import net.sf.oval.contexts.MethodReturnValueContext;
import net.sf.oval.exceptions.AccessingFieldValueFailedException;
import net.sf.oval.exceptions.InvokingGetterFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Logger LOG = Logger.getLogger(ReflectionUtils.class.getName());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getFieldForSetter(Method setter) {
        Field field;
        block10: {
            String fieldName;
            Class<?> clazz;
            String methodName;
            Class<?>[] methodParameterTypes;
            block9: {
                if (!ReflectionUtils.isSetter(setter)) {
                    return null;
                }
                methodParameterTypes = setter.getParameterTypes();
                methodName = setter.getName();
                clazz = setter.getDeclaringClass();
                fieldName = methodName.substring(3, 4).toLowerCase();
                if (methodName.length() > 4) {
                    fieldName = String.valueOf(fieldName) + methodName.substring(4);
                }
                field = null;
                try {
                    field = clazz.getDeclaredField(fieldName);
                    if (!field.getType().equals(methodParameterTypes[0])) {
                        LOG.warning("Found field <" + fieldName + "> in class <" + clazz.getName() + ">that matches setter <" + methodName + "> name, but mismatches parameter type.");
                        field = null;
                    }
                }
                catch (NoSuchFieldException e) {
                    if (!LOG.isLoggable(Level.FINER)) break block9;
                    LOG.log(Level.FINER, "Field not found", e);
                }
            }
            if (field == null && (methodParameterTypes[0].equals(Boolean.TYPE) || methodParameterTypes[0].equals(Boolean.class))) {
                fieldName = "is" + methodName.substring(3);
                try {
                    field = clazz.getDeclaredField(fieldName);
                    if (!field.getType().equals(Boolean.TYPE) && field.getType().equals(Boolean.class)) {
                        LOG.warning("Found field <" + fieldName + "> that matches setter <" + methodName + "> name, but mismatches parameter type.");
                        field = null;
                    }
                }
                catch (NoSuchFieldException ex) {
                    if (!LOG.isLoggable(Level.FINER)) break block10;
                    LOG.log(Level.FINER, "Field not found", ex);
                }
            }
        }
        return field;
    }

    public static Field getFieldRecursive(Class<?> clazz, String fieldName) {
        Field f = ReflectionUtils.getField(clazz, fieldName);
        if (f != null) {
            return f;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getFieldRecursive(superclazz, fieldName);
    }

    public static Object getFieldValue(Field field, Object obj) throws AccessingFieldValueFailedException {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new AccessingFieldValueFailedException("Accessing value of field " + field.getName() + "failed.", obj, new FieldContext(field), ex);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getField(clazz, fieldName) != null;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getMethod(clazz, methodName, parameterTypes) != null;
    }

    public static Object invokeMethod(Method method, Object obj, Object ... args) throws InvokingGetterFailedException {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(obj, args);
        }
        catch (Exception ex) {
            throw new InvokingGetterFailedException("Executing method " + method.getName() + " failed.", obj, new MethodReturnValueContext(method), ex);
        }
    }

    public static boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && (method.getName().startsWith("is") || method.getName().startsWith("get"));
    }

    public static boolean isSetter(Method method) {
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (methodParameterTypes.length != 1) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLen = methodName.length();
        return methodName.startsWith("set") && methodNameLen > 3;
    }

    public static boolean isStatic(Field field) {
        return (field.getModifiers() & 8) != 0;
    }

    public static boolean isStatic(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public static boolean isTransient(Field field) {
        return (field.getModifiers() & 0x80) != 0;
    }

    private ReflectionUtils() {
    }
}

