/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.contexts;

import java.lang.reflect.Method;
import net.sf.oval.contexts.OValContext;
import net.sf.oval.utils.SerializableMethod;
import net.sf.oval.utils.StringUtils;

public class MethodParameterContext
extends OValContext {
    private static final long serialVersionUID = 1L;
    private final SerializableMethod method;
    private final int parameterIndex;
    private final String parameterName;

    public MethodParameterContext(Method method, int parameterIndex, String parameterName) {
        this.method = SerializableMethod.getInstance(method);
        this.parameterIndex = parameterIndex;
        this.parameterName = parameterName == null ? "param" + parameterIndex : parameterName;
    }

    public Method getMethod() {
        return this.method.getMethod();
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String toString() {
        return String.valueOf(this.method.getDeclaringClass().getName()) + "." + this.method.getName() + "(" + StringUtils.implode(this.method.getParameterTypes(), ",") + ") Parameter " + this.parameterIndex + (this.parameterName == null || this.parameterName.length() == 0 ? "" : " (" + this.parameterName + ")");
    }
}

