/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraints;

import java.lang.reflect.Method;
import net.sf.oval.AbstractAnnotationCheck;
import net.sf.oval.constraints.ValidateWithMethod;
import net.sf.oval.contexts.OValContext;
import net.sf.oval.exceptions.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateWithMethodCheck
extends AbstractAnnotationCheck<ValidateWithMethod> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreIfNull;
    private String methodName;
    private Class parameterType;

    @Override
    public void configure(ValidateWithMethod constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMethodName(constraintAnnotation.methodName());
        this.setParameterType(constraintAnnotation.parameterType());
        this.setIgnoreIfNull(constraintAnnotation.ignoreIfNull());
    }

    @Override
    public String[] getMessageValues() {
        return new String[]{this.methodName, this.parameterType.getName()};
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class getParameterType() {
        return this.parameterType;
    }

    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object value, OValContext context) {
        if (value == null && this.ignoreIfNull) {
            return true;
        }
        try {
            Method method = validatedObject.getClass().getDeclaredMethod(this.methodName, this.parameterType);
            method.setAccessible(true);
            return (Boolean)method.invoke(validatedObject, value);
        }
        catch (Exception e) {
            throw new ReflectionException("Calling validation method " + validatedObject.getClass().getName() + "." + this.methodName + "(" + validatedObject.getClass().getName() + ") failed.", e);
        }
    }

    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameterType(Class parameterType) {
        this.parameterType = parameterType;
    }
}

