/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraints;

import java.util.regex.Pattern;
import net.sf.oval.AbstractAnnotationCheck;
import net.sf.oval.constraints.RegEx;
import net.sf.oval.contexts.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExCheck
extends AbstractAnnotationCheck<RegEx> {
    private static final long serialVersionUID = 1L;
    private Pattern pattern;

    @Override
    public void configure(RegEx constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.pattern = Pattern.compile(constraintAnnotation.pattern(), constraintAnnotation.flags());
    }

    @Override
    public String[] getMessageValues() {
        return new String[]{this.pattern.pattern()};
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object value, OValContext context) {
        if (value == null) {
            return true;
        }
        return this.pattern.matcher(value.toString()).matches();
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

