/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraints;

import net.sf.oval.AbstractAnnotationCheck;
import net.sf.oval.constraints.Length;
import net.sf.oval.contexts.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthCheck
extends AbstractAnnotationCheck<Length> {
    private static final long serialVersionUID = 1L;
    private int min;
    private int max;

    @Override
    public void configure(Length constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.max());
        this.setMin(constraintAnnotation.min());
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public String[] getMessageValues() {
        return new String[]{Integer.toString(this.min), Integer.toString(this.max)};
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object value, OValContext context) {
        if (value == null) {
            return true;
        }
        int len = value.toString().length();
        return len >= this.min && len <= this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }
}

