/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import net.sf.oval.Check;
import net.sf.oval.collections.CollectionFactory;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.elements.ClassConfiguration;
import net.sf.oval.configuration.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.elements.FieldConfiguration;
import net.sf.oval.constraints.LengthCheck;
import net.sf.oval.constraints.NotNullCheck;
import net.sf.oval.exceptions.OValException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAAnnotationsConfigurer
implements Configurer {
    private Boolean applyFieldConstraintsToSetter;

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) throws OValException {
        ClassConfiguration config = new ClassConfiguration();
        config.type = clazz;
        config.applyFieldConstraintsToSetter = this.applyFieldConstraintsToSetter;
        Field[] fieldArray = config.type.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field field = fieldArray[n];
            List<Check> checks = CollectionFactory.INSTANCE.createList(4);
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = 0;
            int n4 = annotationArray.length;
            while (n3 < n4) {
                Annotation annotation = annotationArray[n3];
                if (annotation instanceof Basic) {
                    this.initializeChecks((Basic)annotation, checks);
                } else if (annotation instanceof Column) {
                    this.initializeChecks((Column)annotation, checks);
                } else if (annotation instanceof OneToOne) {
                    this.initializeChecks((OneToOne)annotation, checks);
                } else if (annotation instanceof ManyToOne) {
                    this.initializeChecks((ManyToOne)annotation, checks);
                }
                ++n3;
            }
            if (checks.size() > 0) {
                if (config.fieldConfigurations == null) {
                    config.fieldConfigurations = CollectionFactory.INSTANCE.createSet(8);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                config.fieldConfigurations.add(fc);
            }
            ++n;
        }
        return config;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) throws OValException {
        return null;
    }

    private void initializeChecks(Basic annotation, Collection<Check> checks) {
        if (!annotation.optional()) {
            checks.add(new NotNullCheck());
        }
    }

    private void initializeChecks(Column annotation, Collection<Check> checks) {
        if (!annotation.nullable()) {
            checks.add(new NotNullCheck());
        }
        LengthCheck lengthCheck = new LengthCheck();
        lengthCheck.setMax(annotation.length());
        checks.add(lengthCheck);
    }

    private void initializeChecks(ManyToOne annotation, Collection<Check> checks) {
        if (!annotation.optional()) {
            checks.add(new NotNullCheck());
        }
    }

    private void initializeChecks(OneToOne annotation, Collection<Check> checks) {
        if (!annotation.optional()) {
            checks.add(new NotNullCheck());
        }
    }

    public Boolean isApplyFieldConstraintsToSetter() {
        return this.applyFieldConstraintsToSetter;
    }

    public void setApplyFieldConstraintsToSetter(Boolean applyFieldConstraintsToSetter) {
        this.applyFieldConstraintsToSetter = applyFieldConstraintsToSetter;
    }
}

