/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.oval.Check;
import net.sf.oval.ClassChecks;
import net.sf.oval.ConstraintSet;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.MessageResolver;
import net.sf.oval.MessageResolverImpl;
import net.sf.oval.ParameterNameResolver;
import net.sf.oval.ParameterNameResolverEnumerationImpl;
import net.sf.oval.collections.CollectionFactory;
import net.sf.oval.configuration.AnnotationsConfigurer;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.elements.ClassConfiguration;
import net.sf.oval.configuration.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.elements.ConstructorConfiguration;
import net.sf.oval.configuration.elements.FieldConfiguration;
import net.sf.oval.configuration.elements.MethodConfiguration;
import net.sf.oval.configuration.elements.ParameterConfiguration;
import net.sf.oval.constraints.AssertConstraintSetCheck;
import net.sf.oval.constraints.AssertFieldConstraintsCheck;
import net.sf.oval.constraints.AssertValidCheck;
import net.sf.oval.contexts.ConstructorParameterContext;
import net.sf.oval.contexts.FieldContext;
import net.sf.oval.contexts.MethodParameterContext;
import net.sf.oval.contexts.MethodReturnValueContext;
import net.sf.oval.contexts.OValContext;
import net.sf.oval.exceptions.ConstraintSetAlreadyDefinedException;
import net.sf.oval.exceptions.FieldNotFoundException;
import net.sf.oval.exceptions.InvalidConfigurationException;
import net.sf.oval.exceptions.MethodNotFoundException;
import net.sf.oval.exceptions.ReflectionException;
import net.sf.oval.exceptions.UndefinedConstraintSetException;
import net.sf.oval.utils.ListOrderedSet;
import net.sf.oval.utils.ReflectionUtils;
import net.sf.oval.utils.ThreadLocalList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    protected final Map<Class, ClassChecks> checksByClass = new WeakHashMap<Class, ClassChecks>();
    protected final ListOrderedSet<Configurer> configurers = new ListOrderedSet();
    protected final Map<String, ConstraintSet> constraintSetsById = CollectionFactory.INSTANCE.createMap();
    protected final ThreadLocalList<Object> currentlyValidatedObjects = new ThreadLocalList();
    protected MessageResolver messageResolver = new MessageResolverImpl();
    protected ParameterNameResolver parameterNameResolver = new ParameterNameResolverEnumerationImpl();
    static /* synthetic */ Class class$0;

    public Validator() {
        this.configurers.add(new AnnotationsConfigurer());
    }

    public Validator(Configurer ... configurers) {
        Configurer[] configurerArray = configurers;
        int n = 0;
        int n2 = configurerArray.length;
        while (n < n2) {
            Configurer configurer = configurerArray[n];
            this.configurers.add(configurer);
            ++n;
        }
    }

    protected void addChecks(ClassConfiguration classConfig) throws InvalidConfigurationException, FieldNotFoundException, MethodNotFoundException, ReflectionException {
        if (classConfig.type == null) {
            throw new InvalidConfigurationException("The property 'type' for " + classConfig + " must be specified.");
        }
        ClassChecks cc = this.getClassChecks(classConfig.type);
        if (classConfig.overwrite != null && classConfig.overwrite.booleanValue()) {
            cc.reset();
        }
        try {
            int l;
            int i;
            int l2;
            if (classConfig.fieldConfigurations != null) {
                for (FieldConfiguration fieldConfig : classConfig.fieldConfigurations) {
                    Field field = classConfig.type.getDeclaredField(fieldConfig.name);
                    if (fieldConfig.overwrite != null && fieldConfig.overwrite.booleanValue()) {
                        cc.removeAllCheck(field);
                    }
                    if (fieldConfig.checks != null && fieldConfig.checks.size() > 0) {
                        cc.addChecks(field, fieldConfig.checks.toArray(new Check[fieldConfig.checks.size()]));
                    }
                    if (fieldConfig.defineConstraintSet == null) continue;
                    ConstraintSet cs = cc.addFieldConstraintSet(field, fieldConfig.defineConstraintSet);
                    this.addConstraintSet(cs);
                }
            }
            if (classConfig.constructorConfigurations != null) {
                for (ConstructorConfiguration constructorConfig : classConfig.constructorConfigurations) {
                    if (constructorConfig.parameterConfigurations == null) continue;
                    Class[] parameterTypes = new Class[constructorConfig.parameterConfigurations.size()];
                    int i2 = 0;
                    l2 = constructorConfig.parameterConfigurations.size();
                    while (i2 < l2) {
                        parameterTypes[i2] = constructorConfig.parameterConfigurations.get((int)i2).type;
                        ++i2;
                    }
                    Constructor<?> constructor = classConfig.type.getDeclaredConstructor(parameterTypes);
                    if (constructorConfig.overwrite != null && constructorConfig.overwrite.booleanValue()) {
                        cc.removeAllChecks(constructor);
                    }
                    i = 0;
                    l = constructorConfig.parameterConfigurations.size();
                    while (i < l) {
                        List<Check> checks;
                        ParameterConfiguration parameterConfig = constructorConfig.parameterConfigurations.get(i);
                        if (parameterConfig.overwrite != null && parameterConfig.overwrite.booleanValue()) {
                            cc.removeAllChecks(constructor, i);
                        }
                        if ((checks = parameterConfig.checks) != null && checks.size() > 0) {
                            cc.addChecks(constructor, i, checks.toArray(new Check[checks.size()]));
                        }
                        ++i;
                    }
                }
            }
            if (classConfig.methodConfigurations != null) {
                for (MethodConfiguration methodConfig : classConfig.methodConfigurations) {
                    Method method = null;
                    if (methodConfig.parameterConfigurations == null || methodConfig.parameterConfigurations.size() == 0) {
                        method = classConfig.type.getDeclaredMethod(methodConfig.name, new Class[0]);
                    } else {
                        Class[] parameterTypes = new Class[methodConfig.parameterConfigurations.size()];
                        i = 0;
                        l = methodConfig.parameterConfigurations.size();
                        while (i < l) {
                            parameterTypes[i] = methodConfig.parameterConfigurations.get((int)i).type;
                            ++i;
                        }
                        method = classConfig.type.getDeclaredMethod(methodConfig.name, parameterTypes);
                    }
                    if (methodConfig.overwrite != null && methodConfig.overwrite.booleanValue()) {
                        cc.removeAllChecks(method);
                    }
                    if (methodConfig.parameterConfigurations != null && methodConfig.parameterConfigurations.size() > 0) {
                        int i3 = 0;
                        l2 = methodConfig.parameterConfigurations.size();
                        while (i3 < l2) {
                            List<Check> checks;
                            ParameterConfiguration parameterConfig = methodConfig.parameterConfigurations.get(i3);
                            if (parameterConfig.overwrite != null && parameterConfig.overwrite.booleanValue()) {
                                cc.removeAllChecks(method, i3);
                            }
                            if ((checks = parameterConfig.checks) != null && checks.size() > 0) {
                                cc.addChecks(method, i3, checks.toArray(new Check[checks.size()]));
                            }
                            ++i3;
                        }
                    }
                    if (methodConfig.returnValueConfiguration == null) continue;
                    if (methodConfig.returnValueConfiguration.overwrite != null && methodConfig.returnValueConfiguration.overwrite.booleanValue()) {
                        cc.removeAllReturnValueChecks(method);
                    }
                    if (methodConfig.returnValueConfiguration.checks == null || methodConfig.returnValueConfiguration.checks.size() <= 0) continue;
                    cc.addChecks(method, methodConfig.returnValueConfiguration.checks.toArray(new Check[methodConfig.returnValueConfiguration.checks.size()]));
                }
            }
        }
        catch (SecurityException e) {
            throw new ReflectionException("SecurityException occured", e);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException("NoSuchMethodException occured.", e);
        }
        catch (NoSuchFieldException e) {
            throw new FieldNotFoundException("FieldNotFoundException occured.", e);
        }
    }

    protected void addConstraintSet(ConstraintSet constraintSet) throws ConstraintSetAlreadyDefinedException {
        if (this.constraintSetsById.containsKey(constraintSet.id)) {
            throw new ConstraintSetAlreadyDefinedException("Another constraint set with the same fully qualified id " + constraintSet.id + " has already been defined.");
        }
        this.constraintSetsById.put(constraintSet.id, constraintSet);
    }

    public ConstraintSet addConstraintSet(ConstraintSetConfiguration constraintSetConfigurations) throws ConstraintSetAlreadyDefinedException {
        ConstraintSet cs = new ConstraintSet();
        cs.checks = CollectionFactory.INSTANCE.createSet(constraintSetConfigurations.checks == null ? 2 : constraintSetConfigurations.checks.size());
        cs.checks.addAll(constraintSetConfigurations.checks);
        cs.id = constraintSetConfigurations.id;
        if (constraintSetConfigurations.overwrite != null && constraintSetConfigurations.overwrite.booleanValue()) {
            this.constraintSetsById.put(cs.id, cs);
        } else {
            this.addConstraintSet(cs);
        }
        return cs;
    }

    protected void checkConstraint(List<ConstraintViolation> violations, Check check, Object validatedObject, Object valueToValidate, OValContext context) {
        if (check instanceof AssertValidCheck) {
            if (valueToValidate == null) {
                return;
            }
            if (this.isCurrentlyValidated(valueToValidate)) {
                return;
            }
            List<ConstraintViolation> childViolations = this.validate(valueToValidate);
            if (childViolations.size() != 0) {
                String errorMessage = this.renderMessage(context, valueToValidate, check);
                violations.add(new ConstraintViolation(errorMessage, validatedObject, valueToValidate, context, childViolations.toArray(new ConstraintViolation[childViolations.size()])));
            }
            if (valueToValidate instanceof Collection && ((AssertValidCheck)check).isRequireValidElements()) {
                for (Object item : (Collection)valueToValidate) {
                    List<ConstraintViolation> itemViolations = this.validate(item);
                    if (itemViolations.size() == 0) continue;
                    String errorMessage = this.renderMessage(context, item, check);
                    violations.add(new ConstraintViolation(errorMessage, validatedObject, item, context, itemViolations.toArray(new ConstraintViolation[itemViolations.size()])));
                }
            }
            return;
        }
        if (check instanceof AssertConstraintSetCheck) {
            ConstraintSet cs;
            ConstraintSet cs2;
            ClassChecks cc;
            AssertConstraintSetCheck assertConstraintSetCheck = (AssertConstraintSetCheck)check;
            Class<?> targetClass = assertConstraintSetCheck.getSource();
            if (targetClass == Object.class) {
                if (context instanceof ConstructorParameterContext) {
                    targetClass = ((ConstructorParameterContext)context).getConstructor().getDeclaringClass();
                } else if (context instanceof FieldContext) {
                    targetClass = ((FieldContext)context).getField().getDeclaringClass();
                } else if (context instanceof MethodParameterContext) {
                    targetClass = ((MethodParameterContext)context).getMethod().getDeclaringClass();
                } else if (context instanceof MethodReturnValueContext) {
                    targetClass = ((MethodReturnValueContext)context).getMethod().getDeclaringClass();
                }
            }
            Class source = assertConstraintSetCheck.getSource();
            String constraintSetId = assertConstraintSetCheck.getId();
            Collection<Check> referencedChecks = null;
            if (source == Object.class) {
                cc = this.getClassChecks(targetClass);
                cs2 = cc.constraintSetsByLocalId.get(assertConstraintSetCheck.getId());
                if (cs2 != null) {
                    referencedChecks = cs2.getChecks(this);
                }
            } else {
                cc = this.getClassChecks(source);
                cs2 = cc.constraintSetsByLocalId.get(assertConstraintSetCheck.getId());
                if (cs2 != null) {
                    referencedChecks = cs2.getChecks(this);
                }
            }
            if (referencedChecks == null && (cs = this.getConstraintSet(constraintSetId)) != null) {
                referencedChecks = cs.getChecks(this);
            }
            if (referencedChecks == null) {
                throw new UndefinedConstraintSetException("No constraint set with id " + constraintSetId + " defined.");
            }
            for (Check referencedCheck : referencedChecks) {
                this.checkConstraint(violations, referencedCheck, validatedObject, valueToValidate, context);
            }
            return;
        }
        if (check instanceof AssertFieldConstraintsCheck) {
            Field field;
            Class<?> targetClass = validatedObject.getClass();
            if (context instanceof ConstructorParameterContext) {
                targetClass = ((ConstructorParameterContext)context).getConstructor().getDeclaringClass();
            } else if (context instanceof MethodParameterContext) {
                targetClass = ((MethodParameterContext)context).getMethod().getDeclaringClass();
            } else if (context instanceof MethodReturnValueContext) {
                targetClass = ((MethodReturnValueContext)context).getMethod().getDeclaringClass();
            }
            String fieldName = ((AssertFieldConstraintsCheck)check).getFieldName();
            if (fieldName == null || fieldName.length() == 0) {
                if (context instanceof ConstructorParameterContext) {
                    fieldName = ((ConstructorParameterContext)context).getParameterName();
                } else if (context instanceof MethodParameterContext) {
                    fieldName = ((MethodParameterContext)context).getParameterName();
                } else if (context instanceof MethodReturnValueContext) {
                    fieldName = ((MethodReturnValueContext)context).getMethod().getName();
                    if (fieldName.startsWith("get") && fieldName.length() > 3) {
                        fieldName = (fieldName = fieldName.substring(3)).length() == 1 ? fieldName.toLowerCase() : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
                    } else if (fieldName.startsWith("is") && fieldName.length() > 2) {
                        fieldName = (fieldName = fieldName.substring(2)).length() == 1 ? fieldName.toLowerCase() : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
                    }
                }
            }
            if ((field = ReflectionUtils.getFieldRecursive(targetClass, fieldName)) == null) {
                throw new FieldNotFoundException("Field <" + fieldName + "> not found in class <" + targetClass + "> or its super classes.");
            }
            ClassChecks cc = this.getClassChecks(field.getDeclaringClass());
            Collection referencedChecks = cc.checksByField.get(field);
            if (referencedChecks != null && referencedChecks.size() > 0) {
                for (Check referencedCheck : referencedChecks) {
                    this.checkConstraint(violations, referencedCheck, validatedObject, valueToValidate, context);
                }
            }
        }
        if (!check.isSatisfied(validatedObject, valueToValidate, context)) {
            String errorMessage = this.renderMessage(context, valueToValidate, check);
            violations.add(new ConstraintViolation(errorMessage, validatedObject, valueToValidate, context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassChecks getClassChecks(Class clazz) {
        Map<Class, ClassChecks> map = this.checksByClass;
        synchronized (map) {
            ClassChecks cc = this.checksByClass.get(clazz);
            if (cc == null) {
                cc = new ClassChecks(clazz);
                this.checksByClass.put(clazz, cc);
                for (Configurer configurer : this.configurers) {
                    ClassConfiguration classConfig = configurer.getClassConfiguration(clazz);
                    if (classConfig == null) continue;
                    this.addChecks(classConfig);
                }
            }
            return cc;
        }
    }

    public List<Configurer> getConfigurers() {
        return this.configurers;
    }

    protected ConstraintSet getConstraintSet(String constraintSetId) {
        ConstraintSet cs = this.constraintSetsById.get(constraintSetId);
        if (cs == null) {
            for (Configurer configurer : this.configurers) {
                ConstraintSetConfiguration csc = configurer.getConstraintSetConfiguration(constraintSetId);
                if (csc == null) continue;
                cs = this.addConstraintSet(csc);
            }
        }
        return cs;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public ParameterNameResolver getParameterNameResolver() {
        return this.parameterNameResolver;
    }

    protected boolean isCurrentlyValidated(Object object) {
        return this.currentlyValidatedObjects.get().contains(object);
    }

    public ConstraintSet removeConstraintSet(String id) {
        return this.constraintSetsById.remove(id);
    }

    protected String renderMessage(OValContext context, Object value, Check check) {
        String messageKey = check.getMessage();
        String message = this.messageResolver.getMessage(messageKey);
        if (message == null) {
            message = messageKey;
        }
        if (message.indexOf(123) == -1) {
            return message;
        }
        String[] messageValues = check.getMessageValues();
        int messageValuesCount = messageValues == null ? 0 : messageValues.length;
        Object[] args = new Object[2 + messageValuesCount];
        args[0] = context;
        args[1] = value;
        if (messageValuesCount > 0) {
            System.arraycopy(messageValues, 0, args, 2, messageValuesCount);
        }
        return MessageFormat.format(message, args);
    }

    public void reset() {
        this.checksByClass.clear();
        this.constraintSetsById.clear();
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setParameterNameResolver(ParameterNameResolver parameterNameResolver) {
        this.parameterNameResolver = parameterNameResolver;
    }

    public List<ConstraintViolation> validate(Object validatedObject) {
        this.currentlyValidatedObjects.get().add(validatedObject);
        try {
            List<ConstraintViolation> violations = CollectionFactory.INSTANCE.createList();
            this.validateObject(validatedObject, validatedObject.getClass(), violations);
            List<ConstraintViolation> list = violations;
            return list;
        }
        finally {
            this.currentlyValidatedObjects.get().remove(validatedObject);
        }
    }

    List<ConstraintViolation> validateConstructorParameters(Object validatedObject, Constructor constructor, Object[] args) {
        ClassChecks cc = this.getClassChecks(constructor.getDeclaringClass());
        Map<Integer, Collection<Check>> parameterChecks = cc.checksByConstructorParameter.get(constructor);
        if (parameterChecks == null) {
            return null;
        }
        String[] parameterNames = this.parameterNameResolver.getParameterNames(constructor);
        List<ConstraintViolation> violations = CollectionFactory.INSTANCE.createList();
        int i = 0;
        while (i < args.length) {
            Collection<Check> checks = parameterChecks.get(i);
            if (checks != null && checks.size() > 0) {
                Object valueToValidate = args[i];
                ConstructorParameterContext context = new ConstructorParameterContext(constructor, i, parameterNames[i]);
                for (Check check : checks) {
                    this.checkConstraint(violations, check, validatedObject, valueToValidate, context);
                }
            }
            ++i;
        }
        return violations.size() == 0 ? null : violations;
    }

    protected void validateField(Object validatedObject, Field field, List<ConstraintViolation> violations) {
        ClassChecks cc = this.getClassChecks(field.getDeclaringClass());
        Collection checks = cc.checksByField.get(field);
        if (checks != null && checks.size() > 0) {
            Object valueToValidate = ReflectionUtils.getFieldValue(field, validatedObject);
            FieldContext context = new FieldContext(field);
            for (Check check : checks) {
                this.checkConstraint(violations, check, validatedObject, valueToValidate, context);
            }
        }
    }

    protected void validateGetter(Object validatedObject, Method getter, List<ConstraintViolation> violations) {
        ClassChecks cc = this.getClassChecks(getter.getDeclaringClass());
        Collection checks = cc.checksByMethod.get(getter);
        if (checks != null && checks.size() > 0) {
            Object valueToValidate = ReflectionUtils.invokeMethod(getter, validatedObject, new Object[0]);
            MethodReturnValueContext context = new MethodReturnValueContext(getter);
            for (Check check : checks) {
                this.checkConstraint(violations, check, validatedObject, valueToValidate, context);
            }
        }
    }

    List<ConstraintViolation> validateMethodParameters(Object validatedObject, Method method, Object[] args) {
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Map<Integer, Collection<Check>> parameterChecks = cc.checksByMethodParameter.get(method);
        if (parameterChecks == null) {
            return null;
        }
        String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
        List<ConstraintViolation> violations = CollectionFactory.INSTANCE.createList();
        int i = 0;
        while (i < args.length) {
            Collection<Check> checks = parameterChecks.get(i);
            if (checks != null && checks.size() > 0) {
                Object valueToValidate = args[i];
                MethodParameterContext context = new MethodParameterContext(method, i, parameterNames[i]);
                for (Check check : checks) {
                    this.checkConstraint(violations, check, validatedObject, valueToValidate, context);
                }
            }
            ++i;
        }
        return violations.size() == 0 ? null : violations;
    }

    List<ConstraintViolation> validateMethodReturnValue(Object validatedObject, Method method, Object methodReturnValue) {
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Collection checks = cc.checksByMethod.get(method);
        if (checks != null && checks.size() > 0) {
            List<ConstraintViolation> violations = CollectionFactory.INSTANCE.createList(8);
            MethodReturnValueContext context = new MethodReturnValueContext(method);
            for (Check check : checks) {
                this.checkConstraint(violations, check, validatedObject, methodReturnValue, context);
            }
            return violations.size() == 0 ? null : violations;
        }
        return null;
    }

    protected void validateObject(Object validatedObject, Class<?> clazz, List<ConstraintViolation> violations) {
        if (clazz == Object.class) {
            return;
        }
        ClassChecks cc = this.getClassChecks(clazz);
        for (Field field : cc.constrainedFields) {
            this.validateField(validatedObject, field, violations);
        }
        for (Method getter : cc.constrainedGetters) {
            this.validateGetter(validatedObject, getter, violations);
        }
        this.validateObject(validatedObject, clazz.getSuperclass(), violations);
    }
}

