/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import net.sf.oval.ParameterNameResolver;
import net.sf.oval.exceptions.ReflectionException;

public class ParameterNameResolverEnumerationImpl
implements ParameterNameResolver {
    private final WeakHashMap<AccessibleObject, String[]> parameterNamesCache = new WeakHashMap();

    public String[] getParameterNames(Method method) throws ReflectionException {
        String[] parameterNames = this.parameterNamesCache.get(method);
        if (parameterNames == null) {
            int parameterCount = method.getParameterTypes().length;
            parameterNames = new String[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                parameterNames[i] = "parameter" + i;
                ++i;
            }
            this.parameterNamesCache.put(method, parameterNames);
        }
        return parameterNames;
    }

    public String[] getParameterNames(Constructor constructor) throws ReflectionException {
        String[] parameterNames = this.parameterNamesCache.get(constructor);
        if (parameterNames == null) {
            int parameterCount = constructor.getParameterTypes().length;
            parameterNames = new String[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                parameterNames[i] = "parameter" + i;
                ++i;
            }
            this.parameterNamesCache.put(constructor, parameterNames);
        }
        return parameterNames;
    }
}

