/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.oval.MessageResolver;
import net.sf.oval.collections.CollectionFactory;

public class MessageResolverImpl
implements MessageResolver {
    private final Map<ResourceBundle, List<String>> messageBundleKeys = CollectionFactory.INSTANCE.createMap(8);
    private final LinkedList<ResourceBundle> messageBundles = new LinkedList();

    public boolean addMessageBundle(ResourceBundle messageBundle) {
        if (this.messageBundles.contains(messageBundle)) {
            return false;
        }
        this.messageBundles.addFirst(messageBundle);
        List keys = CollectionFactory.INSTANCE.createList();
        Enumeration<String> keysEnum = messageBundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement());
        }
        this.messageBundleKeys.put(messageBundle, keys);
        return true;
    }

    public String getMessage(String key) {
        for (ResourceBundle bundle : this.messageBundles) {
            List<String> keys = this.messageBundleKeys.get(bundle);
            if (!keys.contains(key)) continue;
            return bundle.getString(key);
        }
        return null;
    }

    public boolean removeMessageBundle(ResourceBundle messageBundle) {
        if (!this.messageBundles.contains(messageBundle)) {
            return false;
        }
        this.messageBundles.remove(messageBundle);
        return true;
    }
}

