/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.ConstraintsViolatedListener;
import net.sf.oval.Validator;
import net.sf.oval.collections.CollectionFactory;
import net.sf.oval.exceptions.ConstraintsViolatedException;

public class Guard {
    private final Map<Class, Set<ConstraintsViolatedListener>> listenersByClass = new WeakHashMap<Class, Set<ConstraintsViolatedListener>>();
    private final Map<Object, Set<ConstraintsViolatedListener>> listenersByObject = new WeakHashMap<Object, Set<ConstraintsViolatedListener>>();
    private ReportingMode reportingMode = ReportingMode.NOTIFY_LISTENERS_AND_THROW_EXCEPTION;
    private final Map<Class, ReportingMode> reportingModesByClass = new WeakHashMap<Class, ReportingMode>();
    private final Map<Object, ReportingMode> reportingModesByObject = new WeakHashMap<Object, ReportingMode>();
    private Validator validator;

    public Guard(Validator validator) {
        this.validator = validator;
    }

    public void addListener(ConstraintsViolatedListener listener, Class clazz) {
        if (clazz == null || listener == null) {
            return;
        }
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByClass.get(clazz);
        if (currentListeners == null) {
            currentListeners = CollectionFactory.INSTANCE.createSet();
            this.listenersByClass.put(clazz, currentListeners);
        }
        currentListeners.add(listener);
    }

    public void addListener(ConstraintsViolatedListener listener, Object validatedObject) {
        if (validatedObject == null || listener == null) {
            return;
        }
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByObject.get(validatedObject);
        if (currentListeners == null) {
            currentListeners = CollectionFactory.INSTANCE.createSet(2);
            this.listenersByObject.put(validatedObject, currentListeners);
        }
        currentListeners.add(listener);
    }

    public ReportingMode getReportingMode() {
        return this.reportingMode;
    }

    public ReportingMode getReportingMode(Class clazz) {
        if (clazz == null) {
            return this.reportingMode;
        }
        ReportingMode classMode = this.reportingModesByClass.get(clazz);
        return classMode == null ? this.reportingMode : classMode;
    }

    public ReportingMode getReportingMode(Object validatedObject) {
        if (validatedObject == null) {
            return this.reportingMode;
        }
        ReportingMode objectMode = this.reportingModesByObject.get(validatedObject);
        return objectMode == null ? this.getReportingMode(validatedObject.getClass()) : objectMode;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean hasListener(ConstraintsViolatedListener listener, Class clazz) {
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByClass.get(clazz);
        if (currentListeners == null) {
            return false;
        }
        return currentListeners.contains(listener);
    }

    public boolean hasListener(ConstraintsViolatedListener listener, Object validatedObject) {
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByObject.get(validatedObject);
        if (currentListeners == null) {
            return false;
        }
        return currentListeners.contains(listener);
    }

    private void notifyListeners(Object validatedObject, ConstraintsViolatedException ex) {
        List notifiedListeners = CollectionFactory.INSTANCE.createList();
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByObject.get(validatedObject);
        if (currentListeners != null) {
            for (ConstraintsViolatedListener listener : currentListeners) {
                listener.onConstraintsViolatedException(ex);
                notifiedListeners.add(listener);
            }
        }
        if ((currentListeners = this.listenersByClass.get(validatedObject)) != null) {
            for (ConstraintsViolatedListener listener : currentListeners) {
                if (notifiedListeners.contains(listener)) continue;
                listener.onConstraintsViolatedException(ex);
            }
        }
    }

    public void removeListener(ConstraintsViolatedListener listener, Class clazz) {
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByClass.get(clazz);
        if (currentListeners == null) {
            return;
        }
        currentListeners.remove(listener);
    }

    public void removeListener(ConstraintsViolatedListener listener, Object validatedObject) {
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByObject.get(validatedObject);
        if (currentListeners == null) {
            return;
        }
        currentListeners.remove(listener);
    }

    public void setReportingMode(ReportingMode newDefaultReportingMode) {
        this.reportingMode = newDefaultReportingMode;
    }

    public void setReportingMode(ReportingMode reportingMode, Class clazz) {
        if (clazz == null || reportingMode == null) {
            return;
        }
        this.reportingModesByClass.put(clazz, reportingMode);
    }

    public void setReportingMode(ReportingMode reportingMode, Object validatedObject) {
        if (validatedObject == null || reportingMode == null) {
            return;
        }
        this.reportingModesByObject.put(validatedObject, reportingMode);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void unsetReportingMode(Class clazz) {
        this.reportingModesByClass.remove(clazz);
    }

    public void unsetReportingMode(Object validatedObject) {
        this.reportingModesByObject.remove(validatedObject);
    }

    public boolean validate(Object validatedObject, boolean alwaysThrow) throws ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validator.validate(validatedObject);
        if (violations.size() > 0) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations.toArray(new ConstraintViolation[violations.size()]));
            this.notifyListeners(validatedObject, violationException);
            if (alwaysThrow) {
                throw violationException;
            }
            if (this.getReportingMode(validatedObject) == ReportingMode.NOTIFY_LISTENERS_AND_THROW_EXCEPTION) {
                throw violationException;
            }
        }
        return violations.size() == 0;
    }

    public void validateConstructorParameters(Object validatedObject, Constructor constructor, Object[] parameters) throws ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validator.validateConstructorParameters(validatedObject, constructor, parameters);
        if (violations == null) {
            return;
        }
        ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations.toArray(new ConstraintViolation[violations.size()]));
        this.notifyListeners(validatedObject, violationException);
        throw violationException;
    }

    public boolean validateMethodParameters(Object validatedObject, Method method, Object[] parameters) throws ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validator.validateMethodParameters(validatedObject, method, parameters);
        if (violations == null) {
            return true;
        }
        ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations.toArray(new ConstraintViolation[violations.size()]));
        this.notifyListeners(validatedObject, violationException);
        if (this.getReportingMode(validatedObject) == ReportingMode.NOTIFY_LISTENERS_AND_THROW_EXCEPTION) {
            throw violationException;
        }
        return false;
    }

    public boolean validateMethodReturnValue(Object validatedObject, Method method, Object methodReturnValue) throws ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validator.validateMethodReturnValue(validatedObject, method, methodReturnValue);
        if (violations == null) {
            return true;
        }
        ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations.toArray(new ConstraintViolation[violations.size()]));
        this.notifyListeners(validatedObject, violationException);
        if (this.getReportingMode(validatedObject) == ReportingMode.NOTIFY_LISTENERS_AND_THROW_EXCEPTION) {
            throw violationException;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportingMode {
        NOTIFY_LISTENERS,
        NOTIFY_LISTENERS_AND_THROW_EXCEPTION;

    }
}

