/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.oval.Check;
import net.sf.oval.ConstraintSet;
import net.sf.oval.IsGuarded;
import net.sf.oval.collections.CollectionFactory;
import net.sf.oval.contexts.FieldContext;
import net.sf.oval.exceptions.InvalidConfigurationException;
import net.sf.oval.utils.ReflectionUtils;

public final class ClassChecks {
    private static final Logger LOG = Logger.getLogger(ClassChecks.class.getName());
    final Map<Constructor, Map<Integer, Collection<Check>>> checksByConstructorParameter = CollectionFactory.INSTANCE.createMap(4);
    final Map<Field, Set<Check>> checksByField = CollectionFactory.INSTANCE.createMap();
    final Map<Method, Set<Check>> checksByMethod = CollectionFactory.INSTANCE.createMap();
    final Map<Method, Map<Integer, Collection<Check>>> checksByMethodParameter = CollectionFactory.INSTANCE.createMap();
    final Class clazz;
    final Set<Field> constrainedFields = CollectionFactory.INSTANCE.createSet();
    final Set<Method> constrainedGetters = CollectionFactory.INSTANCE.createSet();
    final Set<Method> constrainedMethods = CollectionFactory.INSTANCE.createSet();
    final Set<Constructor> constrainedParameterizedConstructors = CollectionFactory.INSTANCE.createSet(4);
    final Set<Method> constrainedParameterizedMethods = CollectionFactory.INSTANCE.createSet();
    final Map<String, ConstraintSet> constraintSetsByLocalId = CollectionFactory.INSTANCE.createMap();
    private final boolean isGuarded;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    ClassChecks(Class clazz) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Initializing constraints configuration for class " + clazz);
        }
        this.clazz = clazz;
        this.isGuarded = IsGuarded.class.isAssignableFrom(clazz);
    }

    public synchronized void addChecks(Constructor constructor, int parameterIndex, Check ... checks) throws InvalidConfigurationException {
        Collection checksOfConstructorParameter;
        if (checks == null || checks.length == 0) {
            return;
        }
        if (constructor.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given constructor does not belong to this class" + this.clazz.getName());
        }
        if (!this.isGuarded) {
            throw new InvalidConfigurationException("Cannot apply constructor parameter constraints to class " + this.clazz.getName() + ". Constraints guarding is not activated for this class.");
        }
        Map<Integer, Collection<Check>> checksOfConstructorByParameter = this.checksByConstructorParameter.get(constructor);
        if (checksOfConstructorByParameter == null) {
            checksOfConstructorByParameter = CollectionFactory.INSTANCE.createMap(8);
            this.checksByConstructorParameter.put(constructor, checksOfConstructorByParameter);
            this.constrainedParameterizedConstructors.add(constructor);
        }
        if ((checksOfConstructorParameter = checksOfConstructorByParameter.get(parameterIndex)) == null) {
            checksOfConstructorParameter = CollectionFactory.INSTANCE.createSet(8);
            checksOfConstructorByParameter.put(parameterIndex, checksOfConstructorParameter);
        }
        Check[] checkArray = checks;
        int n = 0;
        int n2 = checkArray.length;
        while (n < n2) {
            Check check = checkArray[n];
            checksOfConstructorParameter.add(check);
            ++n;
        }
    }

    public synchronized void addChecks(Field field, Check ... checks) {
        if (checks == null || checks.length == 0) {
            return;
        }
        if (field.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given field does not belong to class " + this.clazz.getName());
        }
        Set<Check> checksOfField = this.checksByField.get(field);
        if (checksOfField == null) {
            checksOfField = CollectionFactory.INSTANCE.createSet(8);
            this.checksByField.put(field, checksOfField);
            this.constrainedFields.add(field);
        }
        Check[] checkArray = checks;
        int n = 0;
        int n2 = checkArray.length;
        while (n < n2) {
            Check check = checkArray[n];
            checksOfField.add(check);
            ++n;
        }
    }

    public synchronized void addChecks(Method method, Check ... checks) throws InvalidConfigurationException {
        Set<Check> methodChecks;
        if (checks == null || checks.length == 0) {
            return;
        }
        if (method.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given method does not belong to class " + this.clazz.getName());
        }
        if (method.getReturnType() == Void.TYPE) {
            throw new InvalidConfigurationException("Adding return value constraints for method " + method + " is not possible. The method is declared as void and does not return any values.");
        }
        boolean isGetter = ReflectionUtils.isGetter(method);
        if (!isGetter && !this.isGuarded) {
            throw new InvalidConfigurationException("Cannot apply method return value constraints for method " + method + " not following the JavaBean Getter method convention. Constraints guarding is not activated for this class.");
        }
        this.constrainedMethods.add(method);
        if (isGetter) {
            this.constrainedGetters.add(method);
        }
        if ((methodChecks = this.checksByMethod.get(method)) == null) {
            methodChecks = CollectionFactory.INSTANCE.createSet(checks.length);
            this.checksByMethod.put(method, methodChecks);
        }
        Check[] checkArray = checks;
        int n = 0;
        int n2 = checkArray.length;
        while (n < n2) {
            Check check = checkArray[n];
            methodChecks.add(check);
            ++n;
        }
    }

    public synchronized void addChecks(Method method, int parameterIndex, Check ... checks) throws InvalidConfigurationException {
        Collection checksOfMethodParameter;
        if (checks == null || checks.length == 0) {
            return;
        }
        if (method.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given method does not belong to class " + this.clazz.getName());
        }
        if (!this.isGuarded) {
            throw new InvalidConfigurationException("Cannot apply method parameter constraints to class " + this.clazz.getName() + ". Constraints guarding is not activated for this class.");
        }
        Map<Integer, Collection<Check>> checksOfMethodByParameter = this.checksByMethodParameter.get(method);
        if (checksOfMethodByParameter == null) {
            checksOfMethodByParameter = CollectionFactory.INSTANCE.createMap(8);
            this.checksByMethodParameter.put(method, checksOfMethodByParameter);
            this.constrainedParameterizedMethods.add(method);
        }
        if ((checksOfMethodParameter = checksOfMethodByParameter.get(parameterIndex)) == null) {
            checksOfMethodParameter = CollectionFactory.INSTANCE.createSet(8);
            checksOfMethodByParameter.put(parameterIndex, checksOfMethodParameter);
        }
        Check[] checkArray = checks;
        int n = 0;
        int n2 = checkArray.length;
        while (n < n2) {
            Check check = checkArray[n];
            checksOfMethodParameter.add(check);
            ++n;
        }
    }

    ConstraintSet addFieldConstraintSet(Field field, String localId) {
        if (field.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given field does not belong to this class" + this.clazz.getName());
        }
        ConstraintSet cs = new ConstraintSet();
        cs.context = new FieldContext(field);
        cs.localId = localId;
        cs.id = String.valueOf(field.getDeclaringClass().getName()) + "." + localId;
        this.constraintSetsByLocalId.put(localId, cs);
        return cs;
    }

    synchronized void removeAllCheck(Field field) throws InvalidConfigurationException {
        this.checksByField.remove(field);
        this.constrainedFields.remove(field);
    }

    synchronized void removeAllChecks(Constructor constructor) throws InvalidConfigurationException {
        this.checksByConstructorParameter.remove(constructor);
        this.constrainedParameterizedConstructors.remove(constructor);
    }

    synchronized void removeAllChecks(Constructor constructor, int parameterIndex) throws InvalidConfigurationException {
        Map<Integer, Collection<Check>> checksOfConstructorByParameter = this.checksByConstructorParameter.get(constructor);
        if (checksOfConstructorByParameter == null) {
            return;
        }
        Collection<Check> checksOfMethodParameter = checksOfConstructorByParameter.get(parameterIndex);
        if (checksOfMethodParameter == null) {
            return;
        }
        checksOfConstructorByParameter.remove(parameterIndex);
        if (checksOfConstructorByParameter.size() == 0) {
            this.constrainedParameterizedConstructors.remove(constructor);
        }
    }

    synchronized void removeAllChecks(Method method) throws InvalidConfigurationException {
        this.removeAllParameterChecks(method);
        this.removeAllReturnValueChecks(method);
    }

    synchronized void removeAllChecks(Method method, int parameterIndex) throws InvalidConfigurationException {
        Map<Integer, Collection<Check>> checksOfMethodByParameter = this.checksByMethodParameter.get(method);
        if (checksOfMethodByParameter == null) {
            return;
        }
        Collection<Check> checksOfMethodParameter = checksOfMethodByParameter.get(parameterIndex);
        if (checksOfMethodParameter == null) {
            return;
        }
        checksOfMethodByParameter.remove(parameterIndex);
        if (checksOfMethodByParameter.size() == 0) {
            this.constrainedParameterizedMethods.remove(method);
        }
    }

    synchronized void removeAllParameterChecks(Method method) throws InvalidConfigurationException {
        this.checksByMethodParameter.remove(method);
        this.constrainedParameterizedMethods.remove(method);
    }

    synchronized void removeAllReturnValueChecks(Method method) throws InvalidConfigurationException {
        this.checksByMethod.remove(method);
        this.constrainedGetters.remove(method);
        this.constrainedMethods.remove(method);
    }

    public synchronized void removeCheck(Constructor constructor, int parameterIndex, Check check) throws InvalidConfigurationException {
        if (constructor.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given constructor does not belong to this class" + this.clazz.getName());
        }
        Map<Integer, Collection<Check>> checksOfConstructorByParameter = this.checksByConstructorParameter.get(constructor);
        if (checksOfConstructorByParameter == null) {
            return;
        }
        Collection<Check> checksOfConstructorParameter = checksOfConstructorByParameter.get(parameterIndex);
        if (checksOfConstructorParameter == null) {
            return;
        }
        checksOfConstructorParameter.remove(check);
        if (checksOfConstructorParameter.size() == 0) {
            checksOfConstructorByParameter.remove(parameterIndex);
            if (checksOfConstructorByParameter.size() == 0) {
                this.constrainedParameterizedConstructors.remove(constructor);
            }
        }
    }

    public synchronized void removeCheck(Field field, Check check) throws InvalidConfigurationException {
        if (field.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given field does not belong to class " + this.clazz.getName());
        }
        Set<Check> checksOfField = this.checksByField.get(field);
        if (checksOfField == null) {
            return;
        }
        checksOfField.remove(check);
        if (checksOfField.size() == 0) {
            this.checksByField.remove(field);
            this.constrainedFields.remove(field);
        }
    }

    public synchronized void removeCheck(Method method, Check check) throws InvalidConfigurationException {
        if (method.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given method does not belong to class " + this.clazz.getName());
        }
        Set<Check> checks = this.checksByMethod.get(method);
        if (checks == null) {
            return;
        }
        checks.remove(check);
        if (checks.size() == 0) {
            this.checksByMethod.remove(method);
            this.constrainedGetters.remove(method);
            this.constrainedMethods.remove(method);
        }
    }

    public synchronized void removeCheck(Method method, int parameterIndex, Check check) throws InvalidConfigurationException {
        if (method.getDeclaringClass() != this.clazz) {
            throw new InvalidConfigurationException("Given method does not belong to class " + this.clazz.getName());
        }
        Map<Integer, Collection<Check>> checksOfMethodByParameter = this.checksByMethodParameter.get(method);
        if (checksOfMethodByParameter == null) {
            return;
        }
        Collection<Check> checksOfMethodParameter = checksOfMethodByParameter.get(parameterIndex);
        if (checksOfMethodParameter == null) {
            return;
        }
        checksOfMethodParameter.remove(check);
        if (checksOfMethodParameter.size() == 0) {
            checksOfMethodByParameter.remove(parameterIndex);
            if (checksOfMethodByParameter.size() == 0) {
                this.constrainedParameterizedMethods.remove(method);
            }
        }
    }

    synchronized void reset() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Clearing all checks for class " + this.clazz.getName());
        }
        this.checksByConstructorParameter.clear();
        this.checksByField.clear();
        this.checksByMethod.clear();
        this.checksByMethodParameter.clear();
        this.constrainedFields.clear();
        this.constrainedGetters.clear();
        this.constrainedMethods.clear();
        this.constrainedParameterizedConstructors.clear();
        this.constrainedParameterizedMethods.clear();
        this.constraintSetsByLocalId.clear();
    }
}

