/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public class MpxjCreate {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MpxCreate <output file name>");
            } else {
                MpxjCreate.create(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private static void create(String filename) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        ProjectFile file = new ProjectFile();
        ProjectCalendar calendar = file.addDefaultBaseCalendar();
        calendar.addCalendarException(df.parse("13/03/2006"), df.parse("13/03/2006"));
        ProjectProperties properties = file.getProjectProperties();
        properties.setStartDate(df.parse("01/01/2003"));
        properties.setProjectTitle("Created by MPXJ");
        properties.setAuthor("Jon Iles");
        Resource resource1 = file.addResource();
        resource1.setName("Resource1");
        Resource resource2 = file.addResource();
        resource2.setName("Resource2");
        resource2.setMaxUnits(50.0);
        Task task1 = file.addTask();
        task1.setName("Summary Task");
        Task task2 = task1.addTask();
        task2.setName("First Sub Task");
        task2.setDuration(Duration.getInstance(10.5, TimeUnit.DAYS));
        task2.setStart(df.parse("01/01/2003"));
        task2.setPercentageComplete(NumberHelper.getDouble(50.0));
        task2.setActualStart(df.parse("01/01/2003"));
        Task task3 = task1.addTask();
        task3.setName("Second Sub Task");
        task3.setStart(df.parse("11/01/2003"));
        task3.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
        task3.addPredecessor(task2, RelationType.FINISH_START, null);
        Task milestone1 = task1.addTask();
        milestone1.setName("Milestone");
        milestone1.setStart(df.parse("21/01/2003"));
        milestone1.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
        milestone1.addPredecessor(task3, RelationType.FINISH_START, null);
        Task task4 = file.addTask();
        task4.setName("Next Task");
        task4.setDuration(Duration.getInstance(8, TimeUnit.DAYS));
        task4.setStart(df.parse("01/01/2003"));
        task4.setPercentageComplete(NumberHelper.getDouble(70.0));
        task4.setActualStart(df.parse("01/01/2003"));
        ResourceAssignment assignment1 = task2.addResourceAssignment(resource1);
        ResourceAssignment assignment2 = task3.addResourceAssignment(resource2);
        assignment1.setWork(Duration.getInstance(80, TimeUnit.HOURS));
        assignment1.setActualWork(Duration.getInstance(40, TimeUnit.HOURS));
        assignment1.setRemainingWork(Duration.getInstance(40, TimeUnit.HOURS));
        assignment2.setRemainingWork(Duration.getInstance(80, TimeUnit.HOURS));
        assignment1.setStart(df.parse("01/01/2003"));
        assignment2.setStart(df.parse("11/01/2003"));
        Task task5 = file.addTask();
        task5.setName("Last Task");
        task5.setDuration(Duration.getInstance(3, TimeUnit.DAYS));
        task5.setStart(df.parse("01/01/2003"));
        task5.setPercentageComplete(NumberHelper.getDouble(100.0));
        task5.setActualStart(df.parse("01/01/2003"));
        ProjectWriter writer = ProjectWriterUtility.getProjectWriter(filename);
        writer.write(file, filename);
    }
}

