/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaDatabaseReader;
import net.sf.mpxj.asta.AstaFileReader;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.fasttrack.FastTrackReader;
import net.sf.mpxj.ganttproject.GanttProjectReader;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.merlin.MerlinReader;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.phoenix.PhoenixInputStream;
import net.sf.mpxj.phoenix.PhoenixReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.primavera.PrimaveraPMFileReader;
import net.sf.mpxj.primavera.PrimaveraXERFileReader;
import net.sf.mpxj.projectlibre.ProjectLibreReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.reader.ProjectReader;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class UniversalProjectReader
extends AbstractProjectReader {
    private int m_skipBytes;
    private Charset m_charset;
    private List<ProjectListener> m_projectListeners;
    private static final int BUFFER_SIZE = 512;
    private static final byte[] OLE_COMPOUND_DOC_FINGERPRINT = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] PP_FINGERPRINT = new byte[]{0, 0, 48, 48, 48, 48, 48, 48};
    private static final byte[] MPX_FINGERPRINT = new byte[]{77, 80, 88, 44};
    private static final byte[] MDB_FINGERPRINT = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
    private static final byte[] SQLITE_FINGERPRINT = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116};
    private static final byte[] XER_FINGERPRINT = new byte[]{69, 82, 77, 72, 68, 82};
    private static final byte[] ZIP_FINGERPRINT = new byte[]{80, 75};
    private static final byte[] PHOENIX_FINGERPRINT = new byte[]{80, 80, 88, 33, 33, 33, 33};
    private static final byte[] FASTTRACK_FINGERPRINT = new byte[]{28, 0, 0, 0, -117, 0, 0, 0};
    private static final byte[] PROJECTLIBRE_FINGERPRINT = new byte[]{-84, -19, 0, 5};
    private static final byte[] UTF8_BOM_FINGERPRINT = new byte[]{-17, -69, -65};
    private static final byte[] UTF16_BOM_FINGERPRINT = new byte[]{-2, -1};
    private static final byte[] UTF16LE_BOM_FINGERPRINT = new byte[]{-1, -2};
    private static final Pattern PLANNER_FINGERPRINT = Pattern.compile(".*<project.*mrproject-version.*", 32);
    private static final Pattern PMXML_FINGERPRINT = Pattern.compile(".*<APIBusinessObjects.*", 32);
    private static final Pattern MSPDI_FINGERPRINT = Pattern.compile(".*xmlns=\"http://schemas\\.microsoft\\.com/project.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*update_mode=\"(true|false)\".*>.*", 32);
    private static final Pattern GANTTPROJECT_FINGERPRINT = Pattern.compile(".*<project.*webLink.*", 32);

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    void setSkipBytes(int skipBytes) {
        this.m_skipBytes = skipBytes;
    }

    void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            bis.skip(this.m_skipBytes);
            bis.mark(512);
            byte[] buffer = new byte[512];
            int bytesRead = bis.read(buffer);
            bis.reset();
            if (bytesRead != 512) {
                return null;
            }
            if (this.matchesFingerprint(buffer, OLE_COMPOUND_DOC_FINGERPRINT)) {
                return this.handleOleCompoundDocument(bis);
            }
            if (this.matchesFingerprint(buffer, MSPDI_FINGERPRINT)) {
                MSPDIReader reader = new MSPDIReader();
                reader.setCharset(this.m_charset);
                return reader.read(bis);
            }
            if (this.matchesFingerprint(buffer, PP_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new AstaFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, MPX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new MPXReader(), bis);
            }
            if (this.matchesFingerprint(buffer, XER_FINGERPRINT)) {
                PrimaveraXERFileReader reader = new PrimaveraXERFileReader();
                reader.setCharset(this.m_charset);
                return this.readProjectFile((ProjectReader)reader, bis);
            }
            if (this.matchesFingerprint(buffer, PLANNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PlannerReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PMXML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraPMFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, MDB_FINGERPRINT)) {
                return this.handleMDBFile(bis);
            }
            if (this.matchesFingerprint(buffer, SQLITE_FINGERPRINT)) {
                return this.handleSQLiteFile(bis);
            }
            if (this.matchesFingerprint(buffer, ZIP_FINGERPRINT)) {
                return this.handleZipFile(bis);
            }
            if (this.matchesFingerprint(buffer, PHOENIX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), new PhoenixInputStream(bis));
            }
            if (this.matchesFingerprint(buffer, PHOENIX_XML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), bis);
            }
            if (this.matchesFingerprint(buffer, FASTTRACK_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new FastTrackReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PROJECTLIBRE_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new ProjectLibreReader(), bis);
            }
            if (this.matchesFingerprint(buffer, UTF8_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF8_BOM_FINGERPRINT.length, CharsetHelper.UTF8);
            }
            if (this.matchesFingerprint(buffer, UTF16_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16_BOM_FINGERPRINT.length, CharsetHelper.UTF16);
            }
            if (this.matchesFingerprint(buffer, UTF16LE_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16LE_BOM_FINGERPRINT.length, CharsetHelper.UTF16LE);
            }
            if (this.matchesFingerprint(buffer, GANTTPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new GanttProjectReader(), bis);
            }
            return null;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    private boolean matchesFingerprint(byte[] buffer, byte[] fingerprint) {
        return Arrays.equals(fingerprint, Arrays.copyOf(buffer, fingerprint.length));
    }

    private boolean matchesFingerprint(byte[] buffer, Pattern fingerprint) {
        return fingerprint.matcher(this.m_charset == null ? new String(buffer) : new String(buffer, this.m_charset)).matches();
    }

    private ProjectFile readProjectFile(ProjectReader reader, InputStream stream) throws MPXJException {
        this.addListeners(reader);
        return reader.read(stream);
    }

    private ProjectFile readProjectFile(ProjectReader reader, File file) throws MPXJException {
        this.addListeners(reader);
        return reader.read(file);
    }

    private ProjectFile handleOleCompoundDocument(InputStream stream) throws Exception {
        MPPReader reader = new MPPReader();
        POIFSFileSystem fs = new POIFSFileSystem(POIFSFileSystem.createNonClosingInputStream((InputStream)stream));
        String fileFormat = reader.getFileFormat(fs);
        if (fileFormat.startsWith("MSProject")) {
            this.addListeners(reader);
            return reader.read(fs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleMDBFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".mdb");
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + file.getCanonicalPath();
            Set<String> tableNames = this.populateTableNames(url);
            if (tableNames.contains("MSP_PROJECTS")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MPDDatabaseReader(), file);
                return projectFile;
            }
            if (tableNames.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleSQLiteFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".sqlite");
        try {
            Class.forName("org.sqlite.JDBC");
            String url = "jdbc:sqlite:" + file.getCanonicalPath();
            Set<String> tableNames = this.populateTableNames(url);
            if (tableNames.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseFileReader(), file);
                return projectFile;
            }
            if (tableNames.contains("PROJWBS")) {
                Connection connection = null;
                try {
                    Properties props = new Properties();
                    props.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
                    connection = DriverManager.getConnection(url, props);
                    PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
                    reader.setConnection(connection);
                    this.addListeners(reader);
                    ProjectFile projectFile = reader.read();
                    return projectFile;
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            if (tableNames.contains("ZSCHEDULEITEM")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MerlinReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            file.delete();
        }
    }

    private ProjectFile handleZipFile(InputStream stream) throws Exception {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((entry = zip.getNextEntry()) != null) {
            ProjectFile result;
            if (entry.isDirectory() || (result = new UniversalProjectReader().read(zip)) == null) continue;
            return result;
        }
        return null;
    }

    private ProjectFile handleByteOrderMark(InputStream stream, int length, Charset charset) throws Exception {
        UniversalProjectReader reader = new UniversalProjectReader();
        reader.setSkipBytes(length);
        reader.setCharset(charset);
        return reader.read(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> populateTableNames(String url) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = DriverManager.getConnection(url);
            DatabaseMetaData dmd = connection.getMetaData();
            rs = dmd.getTables(null, null, null, null);
            while (rs.next()) {
                tableNames.add(rs.getString("TABLE_NAME").toUpperCase());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return tableNames;
    }

    private void addListeners(ProjectReader reader) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                reader.addProjectListener(listener);
            }
        }
    }
}

