/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectlibre;

import java.io.IOException;
import java.io.InputStream;

public class SearchableInputStream
extends InputStream {
    private final InputStream m_stream;
    private final byte[] m_pattern;
    private boolean m_searching = true;

    public SearchableInputStream(InputStream stream, String pattern) {
        this.m_stream = stream;
        this.m_pattern = pattern.getBytes();
    }

    @Override
    public int read() throws IOException {
        int c;
        if (this.m_searching) {
            int index = 0;
            c = -1;
            while (this.m_searching) {
                c = this.m_stream.read();
                if (c == -1) {
                    throw new IOException("Pattern not found");
                }
                if (c == this.m_pattern[index]) {
                    if (++index != this.m_pattern.length) continue;
                    this.m_searching = false;
                    c = this.m_stream.read();
                    continue;
                }
                index = 0;
            }
        } else {
            c = this.m_stream.read();
        }
        return c;
    }
}

