/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.UserFieldDataType;

class UserFieldCounters {
    private final Map<String, Integer> m_counters = new HashMap<String, Integer>();
    private final String[][] m_names = new String[UserFieldDataType.values().length][];

    public UserFieldCounters() {
        for (UserFieldDataType type : UserFieldDataType.values()) {
            this.m_names[type.ordinal()] = type.getDefaultFieldNames();
        }
    }

    public void setFieldNamesForType(UserFieldDataType type, String[] fieldNames) {
        this.m_names[type.ordinal()] = fieldNames;
    }

    public <E extends Enum<E>> E nextField(Class<E> clazz, UserFieldDataType type) {
        for (String name : this.m_names[type.ordinal()]) {
            int i = NumberHelper.getInt(this.m_counters.get(name)) + 1;
            try {
                E e = Enum.valueOf(clazz, name + i);
                this.m_counters.put(name, i);
                return e;
            }
            catch (IllegalArgumentException ex) {
            }
        }
        throw new IllegalArgumentException("No fields for type " + (Object)((Object)type) + " available");
    }

    public void reset() {
        this.m_counters.clear();
    }
}

