/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ReplaceOnceStream;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PrimaveraPMFileReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private static final int NAMESPACE_SCOPE = 512;
    private static final String NAMESPACE_REGEX = "xmlns=\\\".*BusinessObjects\\\"";
    private static final String NAMESPACE_REPLACEMENT = "xmlns=\"http://xmlns.oracle.com/Primavera/P6/V17.7/API/BusinessObjects\"";
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            ReplaceOnceStream namespaceCorrectedStream = new ReplaceOnceStream(stream, NAMESPACE_REGEX, NAMESPACE_REPLACEMENT, 512, CharsetHelper.UTF8);
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Primavera");
            this.m_projectFile.getProjectProperties().setFileType("PMXML");
            CustomFieldContainer fields = this.m_projectFile.getCustomFields();
            fields.getCustomField(TaskField.TEXT1).setAlias("WBS Code");
            fields.getCustomField(TaskField.TEXT2).setAlias("Task ID");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXSource doc = new SAXSource(xmlReader, new InputSource(namespaceCorrectedStream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            APIBusinessObjects apibo = (APIBusinessObjects)unmarshaller.unmarshal((Source)doc);
            List<ProjectType> projects = apibo.getProject();
            ProjectType project = null;
            for (ProjectType currentProject : projects) {
                if (BooleanHelper.getBoolean(currentProject.isExternal())) continue;
                project = currentProject;
                break;
            }
            if (project == null) {
                throw new MPXJException("Unable to locate any non-external projects in a list of " + projects.size() + " projects");
            }
            this.processProjectUDFs(apibo);
            this.processProjectProperties(apibo, project);
            this.processCalendars(apibo);
            this.processResources(apibo);
            this.processTasks(project);
            this.processPredecessors(project);
            this.processAssignments(project);
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_clashMap.clear();
            this.m_calMap.clear();
        }
    }

    private void processProjectUDFs(APIBusinessObjects apibo) {
        CustomFieldContainer customFields = this.m_projectFile.getCustomFields();
        for (UDFTypeType udf : apibo.getUDFType()) {
            CustomFieldValueItem item = new CustomFieldValueItem(udf.getObjectId());
            item.setValue(udf.getTitle());
            customFields.registerValue(item);
        }
    }

    private void processProjectProperties(APIBusinessObjects apibo, ProjectType project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setCreationDate(project.getCreateDate());
        properties.setFinishDate(project.getFinishDate());
        properties.setName(project.getName());
        properties.setStartDate(project.getPlannedStartDate());
        properties.setStatusDate(project.getDataDate());
        properties.setProjectTitle(project.getId());
        List<GlobalPreferencesType> list = apibo.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType prefs = list.get(0);
            properties.setCreationDate(prefs.getCreateDate());
            properties.setLastSaved(prefs.getLastUpdateDate());
            properties.setMinutesPerDay((int)(NumberHelper.getDouble(prefs.getHoursPerDay()) * 60.0));
            properties.setMinutesPerWeek((int)(NumberHelper.getDouble(prefs.getHoursPerWeek()) * 60.0));
            properties.setWeekStartDay(Day.getInstance(NumberHelper.getInt(prefs.getStartDayOfWeek())));
            List<CurrencyType> currencyList = apibo.getCurrency();
            for (CurrencyType currency : currencyList) {
                if (!currency.getObjectId().equals(prefs.getBaseCurrencyObjectId())) continue;
                properties.setCurrencySymbol(currency.getSymbol());
                break;
            }
        }
    }

    private void processCalendars(APIBusinessObjects apibo) {
        for (CalendarType row : apibo.getCalendar()) {
            CalendarType.HolidayOrExceptions hoe;
            ProjectCalendar calendar = this.m_projectFile.addCalendar();
            Integer id = row.getObjectId();
            this.m_calMap.put(id, calendar);
            calendar.setName(row.getName());
            calendar.setUniqueID(id);
            CalendarType.StandardWorkWeek stdWorkWeek = row.getStandardWorkWeek();
            if (stdWorkWeek != null) {
                for (CalendarType.StandardWorkWeek.StandardWorkHours hours : stdWorkWeek.getStandardWorkHours()) {
                    Day day = DAY_MAP.get(hours.getDayOfWeek());
                    List<WorkTimeType> workTime = hours.getWorkTime();
                    if (workTime.isEmpty() || workTime.get(0) == null) {
                        calendar.setWorkingDay(day, false);
                        continue;
                    }
                    calendar.setWorkingDay(day, true);
                    ProjectCalendarHours calendarHours = calendar.addCalendarHours(day);
                    for (WorkTimeType work : workTime) {
                        if (work == null) continue;
                        calendarHours.addRange(new DateRange(work.getStart(), this.getEndTime(work.getFinish())));
                    }
                }
            }
            if ((hoe = row.getHolidayOrExceptions()) == null) continue;
            for (CalendarType.HolidayOrExceptions.HolidayOrException ex : hoe.getHolidayOrException()) {
                Date startDate = DateHelper.getDayStartDate(ex.getDate());
                Date endDate = DateHelper.getDayEndDate(ex.getDate());
                ProjectCalendarException pce = calendar.addCalendarException(startDate, endDate);
                List<WorkTimeType> workTime = ex.getWorkTime();
                for (WorkTimeType work : workTime) {
                    if (work == null) continue;
                    pce.addRange(new DateRange(work.getStart(), this.getEndTime(work.getFinish())));
                }
            }
        }
    }

    private void processResources(APIBusinessObjects apibo) {
        List<net.sf.mpxj.primavera.schema.ResourceType> resources = apibo.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType xml : resources) {
            ProjectCalendar calendar;
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(xml.getObjectId());
            resource.setName(xml.getName());
            resource.setCode(xml.getEmployeeId());
            resource.setEmailAddress(xml.getEmailAddress());
            resource.setGUID(DatatypeConverter.parseUUID(xml.getGUID()));
            resource.setNotes(xml.getResourceNotes());
            resource.setCreationDate(xml.getCreateDate());
            resource.setType(RESOURCE_TYPE_MAP.get(xml.getResourceType()));
            resource.setMaxUnits(this.reversePercentage(xml.getMaxUnitsPerTime()));
            resource.setParentID(xml.getParentObjectId());
            Integer calendarID = xml.getCalendarObjectId();
            if (calendarID != null && (calendar = this.m_calMap.get(calendarID)) != null) {
                if (!calendar.isDerived()) {
                    ProjectCalendar resourceCalendar = this.m_projectFile.addCalendar();
                    resourceCalendar.setParent(calendar);
                    resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(resourceCalendar);
                } else if (calendar.getResource() == null) {
                    resource.setResourceCalendar(calendar);
                } else {
                    ProjectCalendar copy = this.m_projectFile.addCalendar();
                    copy.copy(calendar);
                    resource.setResourceCalendar(copy);
                }
            }
            this.readUDFTypes(resource, xml.getUDF());
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks(ProjectType project) {
        Integer uniqueID;
        Task task;
        List<WBSType> wbs = project.getWBS();
        List<ActivityType> tasks = project.getActivity();
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        for (WBSType row : wbs) {
            task = this.m_projectFile.addTask();
            uniqueID = row.getObjectId();
            uniqueIDs.add(uniqueID);
            task.setUniqueID(uniqueID);
            task.setName(row.getName());
            task.setBaselineCost(row.getSummaryBaselineTotalCost());
            task.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task.setRemainingCost(row.getSummaryRemainingTotalCost());
            task.setRemainingDuration(this.getDuration(row.getSummaryRemainingDuration()));
            task.setStart(row.getAnticipatedStartDate());
            task.setFinish(row.getAnticipatedFinishDate());
            task.setText(1, row.getCode());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType row : wbs) {
            task = this.m_projectFile.getTaskByUniqueID(row.getObjectId());
            Task parentTask = this.m_projectFile.getTaskByUniqueID(row.getParentObjectId());
            if (parentTask == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
        }
        int nextID = 1;
        this.m_clashMap.clear();
        for (ActivityType row : tasks) {
            uniqueID = row.getObjectId();
            if (uniqueIDs.contains(uniqueID)) {
                while (uniqueIDs.contains(nextID)) {
                    ++nextID;
                }
                Integer newUniqueID = nextID;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
            }
            uniqueIDs.add(uniqueID);
            Integer parentTaskID = row.getWBSObjectId();
            Task parentTask = this.m_projectFile.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_projectFile.addTask() : parentTask.addTask();
            task2.setUniqueID(uniqueID);
            task2.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task2.setPercentageComplete(this.reversePercentage(row.getPercentComplete()));
            task2.setName(row.getName());
            task2.setRemainingDuration(this.getDuration(row.getRemainingDuration()));
            task2.setActualWork(this.getDuration(this.zeroIsNull(row.getActualDuration())));
            task2.setRemainingWork(this.getDuration(row.getRemainingTotalUnits()));
            task2.setBaselineDuration(this.getDuration(row.getPlannedDuration()));
            task2.setActualDuration(this.getDuration(row.getActualDuration()));
            task2.setDuration(this.getDuration(row.getAtCompletionDuration()));
            task2.setActualCost(NumberHelper.DOUBLE_ZERO);
            task2.setRemainingCost(NumberHelper.DOUBLE_ZERO);
            task2.setBaselineCost(NumberHelper.DOUBLE_ZERO);
            task2.setConstraintDate(row.getPrimaryConstraintDate());
            task2.setConstraintType(CONSTRAINT_TYPE_MAP.get(row.getPrimaryConstraintType()));
            task2.setActualStart(row.getActualStartDate());
            task2.setActualFinish(row.getActualFinishDate());
            task2.setLateStart(row.getRemainingLateStartDate());
            task2.setLateFinish(row.getRemainingLateFinishDate());
            task2.setEarlyStart(row.getRemainingEarlyStartDate());
            task2.setEarlyFinish(row.getRemainingEarlyFinishDate());
            task2.setBaselineStart(row.getPlannedStartDate());
            task2.setBaselineFinish(row.getPlannedFinishDate());
            task2.setPriority(PRIORITY_MAP.get(row.getLevelingPriority()));
            task2.setCreateDate(row.getCreateDate());
            task2.setText(1, row.getId());
            task2.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getType())));
            task2.setCritical(task2.getEarlyStart() != null && task2.getLateStart() != null && task2.getLateStart().compareTo(task2.getEarlyStart()) <= 0);
            Integer calId = row.getCalendarObjectId();
            ProjectCalendar cal = this.m_calMap.get(calId);
            task2.setCalendar(cal);
            task2.setStart(row.getStartDate());
            task2.setFinish(row.getFinishDate());
            this.populateField(task2, TaskField.START, TaskField.START, TaskField.ACTUAL_START, TaskField.BASELINE_START);
            this.populateField(task2, TaskField.FINISH, TaskField.FINISH, TaskField.ACTUAL_FINISH);
            this.populateField(task2, TaskField.WORK, TaskField.ACTUAL_WORK, TaskField.BASELINE_WORK);
            if (task2.getFinish() == null) {
                Duration duration = task2.getRemainingDuration();
                if (duration != null && duration.getDuration() == 0.0) {
                    duration = null;
                }
                if (task2.getActualStart() == null || duration == null) {
                    task2.setFinish(task2.getBaselineFinish());
                } else {
                    Date nextWorkStart;
                    ProjectCalendar calendar = task2.getEffectiveCalendar();
                    Date finish = calendar.getDate(task2.getBaselineStart(), duration, false);
                    if (DateHelper.compare(finish, nextWorkStart = calendar.getNextWorkStart(finish)) == 0) {
                        finish = calendar.getPreviousWorkFinish(finish);
                    }
                    task2.setFinish(finish);
                }
            }
            this.readUDFTypes(task2, row.getUDF());
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        this.sortActivities(TaskField.TEXT1, this.m_projectFile);
        this.updateStructure();
        this.updateDates();
    }

    private void sortActivities(final FieldType activityIDField, ChildTaskContainer container) {
        List<Task> tasks = container.getChildTasks();
        if (!tasks.isEmpty()) {
            for (Task task : tasks) {
                this.sortActivities(activityIDField, task);
                Collections.sort(tasks, new Comparator<Task>(){

                    @Override
                    public int compare(Task t1, Task t2) {
                        boolean t2HasChildren;
                        boolean t1HasChildren = !t1.getChildTasks().isEmpty();
                        boolean bl = t2HasChildren = !t2.getChildTasks().isEmpty();
                        if (t1HasChildren && t2HasChildren) {
                            return t1.getID().compareTo(t2.getID());
                        }
                        if (!t1HasChildren && !t2HasChildren) {
                            String activityID1 = (String)t1.getCurrentValue(activityIDField);
                            String activityID2 = (String)t2.getCurrentValue(activityIDField);
                            if (activityID1 == null || activityID2 == null) {
                                return activityID1 == null && activityID2 == null ? 0 : (activityID1 == null ? 1 : -1);
                            }
                            return activityID1.compareTo(activityID2);
                        }
                        return t1HasChildren ? 1 : -1;
                    }
                });
            }
        }
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.getSummary()) {
            int finished = 0;
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            Date baselineStartDate = parentTask.getBaselineStart();
            Date baselineFinishDate = parentTask.getBaselineFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                baselineStartDate = DateHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = DateHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration baselineDuration = null;
            if (baselineStartDate != null && baselineFinishDate != null) {
                baselineDuration = this.m_projectFile.getDefaultCalendar().getWork(baselineStartDate, baselineFinishDate, TimeUnit.HOURS);
                parentTask.setBaselineDuration(baselineDuration);
            }
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                Date finishDate;
                Date startDate = parentTask.getEarlyStart();
                if (startDate == null) {
                    startDate = baselineStartDate;
                }
                if ((finishDate = parentTask.getEarlyFinish()) == null) {
                    finishDate = baselineFinishDate;
                }
                if (startDate != null && finishDate != null) {
                    remainingDuration = this.m_projectFile.getDefaultCalendar().getWork(startDate, finishDate, TimeUnit.HOURS);
                }
            } else {
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            parentTask.setRemainingDuration(remainingDuration);
            if (baselineDuration != null && remainingDuration != null) {
                double durationPercentComplete = (baselineDuration.getDuration() - remainingDuration.getDuration()) / baselineDuration.getDuration() * 100.0;
                parentTask.setPercentageComplete(durationPercentComplete);
            }
        }
    }

    private void populateField(FieldContainer container, FieldType target, FieldType ... types) {
        for (FieldType type : types) {
            Object value = container.getCachedValue(type);
            if (value == null) continue;
            container.set(target, value);
            break;
        }
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        task.setSummary(task.getChildTasks().size() != 0);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void processPredecessors(ProjectType project) {
        for (RelationshipType row : project.getRelationship()) {
            Task currentTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getSuccessorActivityObjectId()));
            Task predecessorTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getPredecessorActivityObjectId()));
            if (currentTask == null || predecessorTask == null) continue;
            RelationType type = RELATION_TYPE_MAP.get(row.getType());
            Duration lag = this.getDuration(row.getLag());
            Relation relation = currentTask.addPredecessor(predecessorTask, type, lag);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void processAssignments(ProjectType project) {
        List<ResourceAssignmentType> assignments = project.getResourceAssignment();
        for (ResourceAssignmentType row : assignments) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(row.getResourceObjectId());
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getObjectId());
            assignment.setRemainingWork(this.getDuration(row.getRemainingUnits()));
            assignment.setBaselineWork(this.getDuration(row.getPlannedUnits()));
            assignment.setActualWork(this.getDuration(row.getActualUnits()));
            assignment.setRemainingCost(row.getRemainingCost());
            assignment.setBaselineCost(row.getPlannedCost());
            assignment.setActualCost(row.getActualCost());
            assignment.setActualStart(row.getActualStartDate());
            assignment.setActualFinish(row.getActualFinishDate());
            assignment.setBaselineStart(row.getPlannedStartDate());
            assignment.setBaselineFinish(row.getPlannedFinishDate());
            assignment.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task.setActualCost(NumberHelper.getDouble(task.getActualCost()) + NumberHelper.getDouble(assignment.getActualCost()));
            task.setRemainingCost(NumberHelper.getDouble(task.getRemainingCost()) + NumberHelper.getDouble(assignment.getRemainingCost()));
            task.setBaselineCost(NumberHelper.getDouble(task.getBaselineCost()) + NumberHelper.getDouble(assignment.getBaselineCost()));
            this.populateField(assignment, AssignmentField.WORK, AssignmentField.ACTUAL_WORK, AssignmentField.BASELINE_WORK);
            this.populateField(assignment, AssignmentField.COST, AssignmentField.ACTUAL_COST, AssignmentField.BASELINE_COST);
            this.populateField(assignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.BASELINE_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.BASELINE_FINISH);
            this.readUDFTypes(assignment, row.getUDF());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private Double zeroIsNull(Double value) {
        if (value != null && value == 0.0) {
            value = null;
        }
        return value;
    }

    private Duration getDuration(Double duration) {
        Duration result = null;
        if (duration != null) {
            result = Duration.getInstance(NumberHelper.getDouble(duration), TimeUnit.HOURS);
        }
        return result;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() + 60000L);
    }

    private Number reversePercentage(Double n) {
        return n == null ? null : NumberHelper.getDouble(n * 100.0);
    }

    private void readUDFTypes(ProjectEntityWithUniqueID mpxj, List<UDFAssignmentType> udfs) {
        CustomFieldContainer customFields = this.m_projectFile.getCustomFields();
        for (UDFAssignmentType udf : udfs) {
            customFields.registerAliasValue((String)customFields.getCustomFieldValueItemByUniqueID(udf.getTypeObjectId()).getValue(), mpxj.getUniqueID(), udf);
        }
    }

    private Integer mapTaskID(Integer id) {
        Integer mappedID = this.m_clashMap.get(id);
        if (mappedID == null) {
            mappedID = id;
        }
        return mappedID;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.MATERIAL);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("Task Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Resource Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Level of Effort", Boolean.FALSE);
        MILESTONE_MAP.put("Start Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("Finish Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("WBS Summary", Boolean.FALSE);
    }
}

