/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.AlphanumComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.phoenix.SkipNulInputStream;
import net.sf.mpxj.phoenix.schema.Project;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PhoenixReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private Map<String, Task> m_activityMap;
    private Map<UUID, String> m_activityCodeValues;
    Map<UUID, Integer> m_activityCodeSequence;
    private Map<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>> m_activityCodeCache;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    List<UUID> m_codeSequence;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_activityMap = new HashMap<String, Task>();
            this.m_activityCodeValues = new HashMap<UUID, String>();
            this.m_activityCodeSequence = new HashMap<UUID, Integer>();
            this.m_activityCodeCache = new HashMap<Project.Storepoints.Storepoint.Activities.Activity, Map<UUID, UUID>>();
            this.m_codeSequence = new ArrayList<UUID>();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(true);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Phoenix");
            this.m_projectFile.getProjectProperties().setFileType("PPX");
            this.m_projectFile.getCustomFields().getCustomField(TaskField.TEXT1).setAlias("Code");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXSource doc = new SAXSource(xmlReader, new InputSource(new SkipNulInputStream(stream)));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            Project phoenixProject = (Project)unmarshaller.unmarshal((Source)doc);
            Project.Storepoints.Storepoint storepoint = this.getCurrentStorepoint(phoenixProject);
            this.readProjectProperties(phoenixProject.getSettings());
            this.readCalendars(storepoint);
            this.readTasks(phoenixProject, storepoint);
            this.readResources(storepoint);
            this.readRelationships(storepoint);
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_activityMap = null;
            this.m_activityCodeValues = null;
            this.m_activityCodeSequence = null;
            this.m_activityCodeCache = null;
            this.m_codeSequence = null;
        }
    }

    private void readProjectProperties(Project.Settings phoenixSettings) {
        ProjectProperties mpxjProperties = this.m_projectFile.getProjectProperties();
        mpxjProperties.setName(phoenixSettings.getTitle());
        mpxjProperties.setDefaultDurationUnits(phoenixSettings.getBaseunit());
    }

    private void readCalendars(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Calendars calendars = phoenixProject.getCalendars();
        if (calendars != null) {
            for (Project.Storepoints.Storepoint.Calendars.Calendar calendar : calendars.getCalendar()) {
                this.readCalendar(calendar);
            }
            ProjectCalendar defaultCalendar = this.m_projectFile.getCalendarByName(phoenixProject.getDefaultCalendar());
            if (defaultCalendar != null) {
                this.m_projectFile.getProjectProperties().setDefaultCalendarName(defaultCalendar.getName());
            }
        }
    }

    private void readCalendar(Project.Storepoints.Storepoint.Calendars.Calendar calendar) {
        ProjectCalendar mpxjCalendar = this.m_projectFile.addCalendar();
        mpxjCalendar.setName(calendar.getName());
        for (Day day : Day.values()) {
            mpxjCalendar.setWorkingDay(day, true);
        }
        List<Project.Storepoints.Storepoint.Calendars.Calendar.NonWork> nonWorkingDays = calendar.getNonWork();
        for (Project.Storepoints.Storepoint.Calendars.Calendar.NonWork nonWorkingDay : nonWorkingDays) {
            if (!nonWorkingDay.getType().equals("internal_weekly")) continue;
            mpxjCalendar.setWorkingDay(nonWorkingDay.getWeekday(), false);
        }
        for (Day day : Day.values()) {
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day);
            hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
            hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private void readResources(Project.Storepoints.Storepoint phoenixProject) {
        Project.Storepoints.Storepoint.Resources resources = phoenixProject.getResources();
        if (resources != null) {
            for (Project.Storepoints.Storepoint.Resources.Resource res : resources.getResource()) {
                Resource resource = this.readResource(res);
                this.readAssignments(resource, res);
            }
        }
    }

    private Resource readResource(Project.Storepoints.Storepoint.Resources.Resource phoenixResource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        TimeUnit rateUnits = phoenixResource.getMonetarybase();
        if (rateUnits == null) {
            rateUnits = TimeUnit.HOURS;
        }
        mpxjResource.setCostPerUse(phoenixResource.getMonetarycostperuse());
        mpxjResource.setStandardRate(new Rate(phoenixResource.getMonetaryrate(), rateUnits));
        mpxjResource.setStandardRateUnits(rateUnits);
        mpxjResource.setName(phoenixResource.getName());
        mpxjResource.setType(phoenixResource.getType());
        mpxjResource.setMaterialLabel(phoenixResource.getUnitslabel());
        mpxjResource.setGUID(phoenixResource.getUuid());
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
        return mpxjResource;
    }

    private void readTasks(Project phoenixProject, Project.Storepoints.Storepoint storepoint) {
        this.processLayouts(phoenixProject);
        this.processActivityCodes(storepoint);
        this.processActivities(storepoint);
        this.updateDates();
    }

    private void processActivityCodes(Project.Storepoints.Storepoint storepoint) {
        for (Project.Storepoints.Storepoint.ActivityCodes.Code code : storepoint.getActivityCodes().getCode()) {
            int sequence = 0;
            for (Project.Storepoints.Storepoint.ActivityCodes.Code.Value value : code.getValue()) {
                UUID uuid = this.getUUID(value.getUuid(), value.getName());
                this.m_activityCodeValues.put(uuid, value.getName());
                this.m_activityCodeSequence.put(uuid, ++sequence);
            }
        }
    }

    private void processLayouts(Project phoenixProject) {
        Project.Layouts.Layout activeLayout = this.getActiveLayout(phoenixProject);
        for (Project.Layouts.Layout.CodeOptions.CodeOption option : activeLayout.getCodeOptions().getCodeOption()) {
            if (!option.isShown().booleanValue()) continue;
            this.m_codeSequence.add(this.getUUID(option.getCodeUuid(), option.getCode()));
        }
    }

    private Project.Layouts.Layout getActiveLayout(Project phoenixProject) {
        Project.Layouts.Layout activeLayout = phoenixProject.getLayouts().getLayout().get(0);
        if (!activeLayout.isActive().booleanValue()) {
            for (Project.Layouts.Layout layout : phoenixProject.getLayouts().getLayout()) {
                if (!layout.isActive().booleanValue()) continue;
                activeLayout = layout;
                break;
            }
        }
        return activeLayout;
    }

    private void processActivities(Project.Storepoints.Storepoint phoenixProject) {
        final AlphanumComparator comparator = new AlphanumComparator();
        List<Project.Storepoints.Storepoint.Activities.Activity> activities = phoenixProject.getActivities().getActivity();
        Collections.sort(activities, new Comparator<Project.Storepoints.Storepoint.Activities.Activity>(){

            @Override
            public int compare(Project.Storepoints.Storepoint.Activities.Activity o1, Project.Storepoints.Storepoint.Activities.Activity o2) {
                Map<UUID, UUID> codes1 = PhoenixReader.this.getActivityCodes(o1);
                Map<UUID, UUID> codes2 = PhoenixReader.this.getActivityCodes(o2);
                for (UUID code : PhoenixReader.this.m_codeSequence) {
                    UUID codeValue1 = codes1.get(code);
                    UUID codeValue2 = codes2.get(code);
                    if (codeValue1 == null || codeValue2 == null) {
                        if (codeValue1 == null && codeValue2 == null) continue;
                        if (codeValue1 == null) {
                            return -1;
                        }
                        if (codeValue2 == null) {
                            return 1;
                        }
                    }
                    if (codeValue1.equals(codeValue2)) continue;
                    Integer sequence1 = PhoenixReader.this.m_activityCodeSequence.get(codeValue1);
                    Integer sequence2 = PhoenixReader.this.m_activityCodeSequence.get(codeValue2);
                    return NumberHelper.compare(sequence1, sequence2);
                }
                return comparator.compare(o1.getId(), o2.getId());
            }
        });
        for (Project.Storepoints.Storepoint.Activities.Activity activity : activities) {
            this.processActivity(activity);
        }
    }

    private void processActivity(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Task task = this.getParentTask(activity).addTask();
        task.setText(1, activity.getId());
        task.setActualDuration(activity.getActualDuration());
        task.setActualFinish(activity.getActualFinish());
        task.setActualStart(activity.getActualStart());
        task.setCreateDate(activity.getCreationTime());
        task.setFinish(activity.getCurrentFinish());
        task.setStart(activity.getCurrentStart());
        task.setName(activity.getDescription());
        task.setDuration(activity.getDurationAtCompletion());
        task.setEarlyFinish(activity.getEarlyFinish());
        task.setEarlyStart(activity.getEarlyStart());
        task.setFreeSlack(activity.getFreeFloat());
        task.setLateFinish(activity.getLateFinish());
        task.setLateStart(activity.getLateStart());
        task.setNotes(activity.getNotes());
        task.setBaselineDuration(activity.getOriginalDuration());
        task.setPhysicalPercentComplete(activity.getPhysicalPercentComplete());
        task.setRemainingDuration(activity.getRemainingDuration());
        task.setCost(activity.getTotalCost());
        task.setTotalSlack(activity.getTotalFloat());
        task.setMilestone(this.activityIsMilestone(activity));
        task.setGUID(activity.getUuid());
        if (task.getMilestone()) {
            if (this.activityIsStartMilestone(activity)) {
                task.setFinish(task.getStart());
            } else {
                task.setStart(task.getFinish());
            }
        }
        if (task.getActualStart() == null) {
            task.setPercentageComplete(0);
        } else if (task.getActualFinish() != null) {
            task.setPercentageComplete(100);
        } else {
            Duration remaining = activity.getRemainingDuration();
            Duration total = activity.getDurationAtCompletion();
            if (remaining != null && total != null && total.getDuration() != 0.0) {
                double percentComplete = (total.getDuration() - remaining.getDuration()) * 100.0 / total.getDuration();
                task.setPercentageComplete(percentComplete);
            }
        }
        this.m_activityMap.put(activity.getId(), task);
    }

    private boolean activityIsMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String type = activity.getType();
        return type != null && type.indexOf("Milestone") != -1;
    }

    private boolean activityIsStartMilestone(Project.Storepoints.Storepoint.Activities.Activity activity) {
        String type = activity.getType();
        return type != null && type.indexOf("StartMilestone") != -1;
    }

    private ChildTaskContainer getParentTask(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Map<UUID, UUID> map = this.getActivityCodes(activity);
        ChildTaskContainer parent = this.m_projectFile;
        StringBuilder uniqueIdentifier = new StringBuilder();
        for (UUID activityCode : this.m_codeSequence) {
            UUID activityCodeValue = map.get(activityCode);
            String activityCodeText = this.m_activityCodeValues.get(activityCodeValue);
            if (activityCodeText == null) continue;
            if (uniqueIdentifier.length() != 0) {
                uniqueIdentifier.append('>');
            }
            uniqueIdentifier.append(activityCodeValue.toString());
            UUID uuid = UUID.nameUUIDFromBytes(uniqueIdentifier.toString().getBytes());
            Task newParent = this.findChildTaskByUUID(parent, uuid);
            if (newParent == null) {
                newParent = parent.addTask();
                newParent.setGUID(uuid);
                newParent.setName(activityCodeText);
            }
            parent = newParent;
        }
        return parent;
    }

    private Task findChildTaskByUUID(ChildTaskContainer parent, UUID uuid) {
        Task result = null;
        for (Task task : parent.getChildTasks()) {
            if (!uuid.equals(task.getGUID())) continue;
            result = task;
            break;
        }
        return result;
    }

    private void readAssignments(Resource mpxjResource, Project.Storepoints.Storepoint.Resources.Resource res) {
        for (Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment : res.getAssignment()) {
            this.readAssignment(mpxjResource, assignment);
        }
    }

    private void readAssignment(Resource resource, Project.Storepoints.Storepoint.Resources.Resource.Assignment assignment) {
        Task task = this.m_activityMap.get(assignment.getActivity());
        if (task != null) {
            task.addResourceAssignment(resource);
        }
    }

    private void readRelationships(Project.Storepoints.Storepoint phoenixProject) {
        for (Project.Storepoints.Storepoint.Relationships.Relationship relation : phoenixProject.getRelationships().getRelationship()) {
            this.readRelation(relation);
        }
    }

    private void readRelation(Project.Storepoints.Storepoint.Relationships.Relationship relation) {
        Task predecessor = this.m_projectFile.getTaskByUniqueID(relation.getPredecessor());
        Task successor = this.m_projectFile.getTaskByUniqueID(relation.getSuccessor());
        if (predecessor != null && successor != null) {
            Duration lag = relation.getLag();
            RelationType type = relation.getType();
            successor.addPredecessor(predecessor, type, lag);
        }
    }

    Map<UUID, UUID> getActivityCodes(Project.Storepoints.Storepoint.Activities.Activity activity) {
        Map<UUID, UUID> map = this.m_activityCodeCache.get(activity);
        if (map == null) {
            map = new HashMap<UUID, UUID>();
            this.m_activityCodeCache.put(activity, map);
            for (Project.Storepoints.Storepoint.Activities.Activity.CodeAssignment ca : activity.getCodeAssignment()) {
                UUID code = this.getUUID(ca.getCodeUuid(), ca.getCode());
                UUID value = this.getUUID(ca.getValueUuid(), ca.getValue());
                map.put(code, value);
            }
        }
        return map;
    }

    private Project.Storepoints.Storepoint getCurrentStorepoint(Project phoenixProject) {
        List<Project.Storepoints.Storepoint> storepoints = phoenixProject.getStorepoints().getStorepoint();
        Collections.sort(storepoints, new Comparator<Project.Storepoints.Storepoint>(){

            @Override
            public int compare(Project.Storepoints.Storepoint o1, Project.Storepoints.Storepoint o2) {
                return DateHelper.compare(o2.getCreationTime(), o1.getCreationTime());
            }
        });
        return storepoints.get(0);
    }

    private UUID getUUID(UUID uuid, String name) {
        return uuid == null ? UUID.nameUUIDFromBytes(name.getBytes()) : uuid;
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.getSummary()) {
            int finished = 0;
            Date plannedStartDate = parentTask.getStart();
            Date plannedFinishDate = parentTask.getFinish();
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = DateHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getFinish());
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration duration = null;
            if (plannedStartDate != null && plannedFinishDate != null) {
                duration = this.m_projectFile.getDefaultCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.DAYS);
                parentTask.setDuration(duration);
            }
        }
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.phoenix.schema", (ClassLoader)PhoenixReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

