/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DefaultTimephasedWorkContainer;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.ReplaceOnceStream;
import net.sf.mpxj.common.SplitTaskFactory;
import net.sf.mpxj.common.TimephasedWorkNormaliser;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDITimephasedWorkNormaliser;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class MSPDIReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private boolean m_compatibleInput = true;
    private String m_encoding;
    private Charset m_charset;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private static final RecurrenceType[] RECURRENCE_TYPES;
    private static final boolean[] RELATIVE_MAP;
    private static final int[] DAY_MASKS;
    private static final int NAMESPACE_SCOPE = 512;
    private static final String NAMESPACE_REGEX = "xmlns=\\\"http://schemas\\.microsoft\\.com/project.*\\\"";
    private static final String NAMESPACE_REPLACEMENT = "xmlns=\"http://schemas.microsoft.com/project\"";

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    private Charset getCharset() {
        Charset result = this.m_charset;
        if (result == null) {
            result = this.m_encoding == null ? CharsetHelper.UTF8 : Charset.forName(this.m_encoding);
        }
        return result;
    }

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            ReplaceOnceStream namespaceCorrectedStream = new ReplaceOnceStream(stream, NAMESPACE_REGEX, NAMESPACE_REPLACEMENT, 512, this.getCharset());
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXSource doc = new SAXSource(xmlReader, new InputSource(new InputStreamReader((InputStream)namespaceCorrectedStream, this.getCharset())));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            if (this.m_compatibleInput) {
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        return true;
                    }
                });
            }
            DatatypeConverter.setParentFile(this.m_projectFile);
            Project project = (Project)unmarshaller.unmarshal((Source)doc);
            HashMap<BigInteger, ProjectCalendar> calendarMap = new HashMap<BigInteger, ProjectCalendar>();
            this.readProjectProperties(project);
            this.readProjectExtendedAttributes(project);
            this.readCalendars(project, calendarMap);
            this.readResources(project, calendarMap);
            this.readTasks(project);
            this.readAssignments(project);
            config.updateUniqueCounters();
            ProjectCalendar defaultCalendar = calendarMap.get(project.getCalendarUID());
            if (defaultCalendar != null) {
                this.m_projectFile.getProjectProperties().setDefaultCalendarName(defaultCalendar.getName());
            }
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void readProjectProperties(Project project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setActualsInSync(BooleanHelper.getBoolean(project.isActualsInSync()));
        properties.setAdminProject(BooleanHelper.getBoolean(project.isAdminProject()));
        properties.setApplicationVersion(NumberHelper.getInteger(project.getSaveVersion()));
        properties.setAuthor(project.getAuthor());
        properties.setAutoAddNewResourcesAndTasks(BooleanHelper.getBoolean(project.isAutoAddNewResourcesAndTasks()));
        properties.setAutolink(BooleanHelper.getBoolean(project.isAutolink()));
        properties.setBaselineForEarnedValue(NumberHelper.getInteger(project.getBaselineForEarnedValue()));
        properties.setDefaultCalendarName(project.getCalendarUID() == null ? null : project.getCalendarUID().toString());
        properties.setCategory(project.getCategory());
        properties.setCompany(project.getCompany());
        properties.setCreationDate(DatatypeConverter.parseDate(project.getCreationDate()));
        properties.setCriticalSlackLimit(NumberHelper.getInteger(project.getCriticalSlackLimit()));
        properties.setCurrencyDigits(NumberHelper.getInteger(project.getCurrencyDigits()));
        properties.setCurrencyCode(project.getCurrencyCode());
        properties.setCurrencySymbol(project.getCurrencySymbol());
        properties.setCurrentDate(DatatypeConverter.parseDate(project.getCurrentDate()));
        properties.setDaysPerMonth(NumberHelper.getInteger(project.getDaysPerMonth()));
        properties.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        properties.setDefaultEndTime(DatatypeConverter.parseTime(project.getDefaultFinishTime()));
        properties.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        properties.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate()));
        properties.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate()));
        properties.setDefaultStartTime(DatatypeConverter.parseTime(project.getDefaultStartTime()));
        properties.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        properties.setDefaultTaskType(project.getDefaultTaskType());
        properties.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        properties.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        properties.setEditableActualCosts(BooleanHelper.getBoolean(project.isEditableActualCosts()));
        properties.setExtendedCreationDate(DatatypeConverter.parseDate(project.getExtendedCreationDate()));
        properties.setFinishDate(DatatypeConverter.parseDate(project.getFinishDate()));
        properties.setFiscalYearStart(BooleanHelper.getBoolean(project.isFiscalYearStart()));
        properties.setFiscalYearStartMonth(NumberHelper.getInteger(project.getFYStartDate()));
        properties.setHonorConstraints(BooleanHelper.getBoolean(project.isHonorConstraints()));
        properties.setInsertedProjectsLikeSummary(BooleanHelper.getBoolean(project.isInsertedProjectsLikeSummary()));
        properties.setLastSaved(DatatypeConverter.parseDate(project.getLastSaved()));
        properties.setManager(project.getManager());
        properties.setMicrosoftProjectServerURL(BooleanHelper.getBoolean(project.isMicrosoftProjectServerURL()));
        properties.setMinutesPerDay(NumberHelper.getInteger(project.getMinutesPerDay()));
        properties.setMinutesPerWeek(NumberHelper.getInteger(project.getMinutesPerWeek()));
        properties.setMoveCompletedEndsBack(BooleanHelper.getBoolean(project.isMoveCompletedEndsBack()));
        properties.setMoveCompletedEndsForward(BooleanHelper.getBoolean(project.isMoveCompletedEndsForward()));
        properties.setMoveRemainingStartsBack(BooleanHelper.getBoolean(project.isMoveRemainingStartsBack()));
        properties.setMoveRemainingStartsForward(BooleanHelper.getBoolean(project.isMoveRemainingStartsForward()));
        properties.setMultipleCriticalPaths(BooleanHelper.getBoolean(project.isMultipleCriticalPaths()));
        properties.setName(project.getName());
        properties.setNewTasksEffortDriven(BooleanHelper.getBoolean(project.isNewTasksEffortDriven()));
        properties.setNewTasksEstimated(BooleanHelper.getBoolean(project.isNewTasksEstimated()));
        properties.setNewTaskStartIsProjectStart(NumberHelper.getInt(project.getNewTaskStartDate()) == 0);
        properties.setProjectExternallyEdited(BooleanHelper.getBoolean(project.isProjectExternallyEdited()));
        properties.setProjectTitle(project.getTitle());
        properties.setRemoveFileProperties(BooleanHelper.getBoolean(project.isRemoveFileProperties()));
        properties.setRevision(NumberHelper.getInteger(project.getRevision()));
        properties.setScheduleFrom(BooleanHelper.getBoolean(project.isScheduleFromStart()) ? ScheduleFrom.START : ScheduleFrom.FINISH);
        properties.setSubject(project.getSubject());
        properties.setSplitInProgressTasks(BooleanHelper.getBoolean(project.isSplitsInProgressTasks()));
        properties.setSpreadActualCost(BooleanHelper.getBoolean(project.isSpreadActualCost()));
        properties.setSpreadPercentComplete(BooleanHelper.getBoolean(project.isSpreadPercentComplete()));
        properties.setStartDate(DatatypeConverter.parseDate(project.getStartDate()));
        properties.setStatusDate(DatatypeConverter.parseDate(project.getStatusDate()));
        properties.setSymbolPosition(project.getCurrencySymbolPosition());
        properties.setUniqueID(project.getUID());
        properties.setUpdatingTaskStatusUpdatesResourceStatus(BooleanHelper.getBoolean(project.isTaskUpdatesResource()));
        properties.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
        this.updateScheduleSource(properties);
    }

    private void updateScheduleSource(ProjectProperties properties) {
        if (properties.getCompany() != null && properties.getCompany().equals("Synchro Software Ltd")) {
            properties.setFileApplication("Synchro");
        } else if (properties.getAuthor() != null && properties.getAuthor().equals("SG Project")) {
            properties.setFileApplication("Simple Genius");
        } else {
            properties.setFileApplication("Microsoft");
        }
        properties.setFileType("MSPDI");
    }

    private void readCalendars(Project project, HashMap<BigInteger, ProjectCalendar> map) {
        Project.Calendars calendars = project.getCalendars();
        if (calendars != null) {
            LinkedList<Pair<ProjectCalendar, BigInteger>> baseCalendars = new LinkedList<Pair<ProjectCalendar, BigInteger>>();
            for (Project.Calendars.Calendar cal : calendars.getCalendar()) {
                this.readCalendar(cal, map, baseCalendars);
            }
            MSPDIReader.updateBaseCalendarNames(baseCalendars, map);
        }
        try {
            ProjectProperties properties = this.m_projectFile.getProjectProperties();
            BigInteger calendarID = new BigInteger(properties.getDefaultCalendarName());
            ProjectCalendar calendar = map.get(calendarID);
            this.m_projectFile.setDefaultCalendar(calendar);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static void updateBaseCalendarNames(List<Pair<ProjectCalendar, BigInteger>> baseCalendars, HashMap<BigInteger, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, BigInteger> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            BigInteger baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal == null) continue;
            cal.setParent(baseCal);
        }
    }

    private void readCalendar(Project.Calendars.Calendar calendar, HashMap<BigInteger, ProjectCalendar> map, List<Pair<ProjectCalendar, BigInteger>> baseCalendars) {
        ProjectCalendar bc = this.m_projectFile.addCalendar();
        bc.setUniqueID(NumberHelper.getInteger(calendar.getUID()));
        bc.setName(calendar.getName());
        BigInteger baseCalendarID = calendar.getBaseCalendarUID();
        if (baseCalendarID != null) {
            baseCalendars.add(new Pair<ProjectCalendar, BigInteger>(bc, baseCalendarID));
        }
        this.readExceptions(calendar, bc);
        boolean readExceptionsFromDays = bc.getCalendarExceptions().isEmpty();
        Project.Calendars.Calendar.WeekDays days = calendar.getWeekDays();
        if (days != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay weekDay : days.getWeekDay()) {
                this.readDay(bc, weekDay, readExceptionsFromDays);
            }
        } else {
            bc.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
            bc.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
            bc.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
            bc.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
            bc.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
            bc.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
            bc.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        }
        this.readWorkWeeks(calendar, bc);
        map.put(calendar.getUID(), bc);
        this.m_eventManager.fireCalendarReadEvent(bc);
    }

    private void readDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day, boolean readExceptionsFromDays) {
        BigInteger dayType = day.getDayType();
        if (dayType != null) {
            if (dayType.intValue() == 0) {
                if (readExceptionsFromDays) {
                    this.readExceptionDay(calendar, day);
                }
            } else {
                this.readNormalDay(calendar, day);
            }
        }
    }

    private void readNormalDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        int dayNumber = weekDay.getDayType().intValue();
        Day day = Day.getInstance(dayNumber);
        calendar.setWorkingDay(day, BooleanHelper.getBoolean(weekDay.isDayWorking()));
        ProjectCalendarHours hours = calendar.addCalendarHours(day);
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = weekDay.getWorkingTimes();
        if (times != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                Date endTime = DatatypeConverter.parseTime(period.getToTime());
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                hours.addRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar calendar, Project.Calendars.Calendar.WeekDays.WeekDay day) {
        Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = day.getTimePeriod();
        Date fromDate = DatatypeConverter.parseDate(timePeriod.getFromDate());
        Date toDate = DatatypeConverter.parseDate(timePeriod.getToDate());
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = day.getWorkingTimes();
        ProjectCalendarException exception = calendar.addCalendarException(fromDate, toDate);
        if (times != null) {
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> time = times.getWorkingTime();
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime period : time) {
                Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                Date endTime = DatatypeConverter.parseTime(period.getToTime());
                if (startTime == null || endTime == null) continue;
                if (startTime.getTime() >= endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                exception.addRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void readExceptions(Project.Calendars.Calendar calendar, ProjectCalendar bc) {
        Project.Calendars.Calendar.Exceptions exceptions = calendar.getExceptions();
        if (exceptions != null) {
            for (Project.Calendars.Calendar.Exceptions.Exception exception : exceptions.getException()) {
                this.readException(bc, exception);
            }
        }
    }

    private void readException(ProjectCalendar bc, Project.Calendars.Calendar.Exceptions.Exception exception) {
        Date fromDate = DatatypeConverter.parseDate(exception.getTimePeriod().getFromDate());
        Date toDate = DatatypeConverter.parseDate(exception.getTimePeriod().getToDate());
        if (fromDate != null && toDate != null) {
            ProjectCalendarException bce = bc.addCalendarException(fromDate, toDate);
            bce.setName(exception.getName());
            this.readRecurringData(bce, exception);
            Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes times = exception.getWorkingTimes();
            if (times != null) {
                List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> time = times.getWorkingTime();
                for (Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime period : time) {
                    Date startTime = DatatypeConverter.parseTime(period.getFromTime());
                    Date endTime = DatatypeConverter.parseTime(period.getToTime());
                    if (startTime == null || endTime == null) continue;
                    if (startTime.getTime() >= endTime.getTime()) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(endTime);
                        cal.add(6, 1);
                        endTime = cal.getTime();
                    }
                    bce.addRange(new DateRange(startTime, endTime));
                }
            }
        }
    }

    private void readRecurringData(ProjectCalendarException bce, Project.Calendars.Calendar.Exceptions.Exception exception) {
        RecurringData rd = new RecurringData();
        rd.setStartDate(bce.getFromDate());
        rd.setFinishDate(bce.getToDate());
        rd.setRecurrenceType(this.getRecurrenceType(NumberHelper.getInt(exception.getType())));
        rd.setRelative(this.getRelative(NumberHelper.getInt(exception.getType())));
        rd.setOccurrences(NumberHelper.getInteger(exception.getOccurrences()));
        switch (rd.getRecurrenceType()) {
            case DAILY: {
                rd.setFrequency(this.getFrequency(exception));
                break;
            }
            case WEEKLY: {
                rd.setWeeklyDaysFromBitmap(NumberHelper.getInteger(exception.getDaysOfWeek()), DAY_MASKS);
                rd.setFrequency(this.getFrequency(exception));
                break;
            }
            case MONTHLY: {
                if (rd.getRelative()) {
                    rd.setDayOfWeek(Day.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                    rd.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                } else {
                    rd.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                }
                rd.setFrequency(this.getFrequency(exception));
                break;
            }
            case YEARLY: {
                if (rd.getRelative()) {
                    rd.setDayOfWeek(Day.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                    rd.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                } else {
                    rd.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                }
                rd.setMonthNumber(NumberHelper.getInt(exception.getMonth()) + 1);
            }
        }
        if (rd.getRecurrenceType() != RecurrenceType.DAILY || rd.getDates().length > 1) {
            bce.setRecurring(rd);
        }
    }

    private RecurrenceType getRecurrenceType(int value) {
        RecurrenceType result = value < 0 || value >= RECURRENCE_TYPES.length ? null : RECURRENCE_TYPES[value];
        return result;
    }

    private boolean getRelative(int value) {
        boolean result = value < 0 || value >= RELATIVE_MAP.length ? false : RELATIVE_MAP[value];
        return result;
    }

    private Integer getFrequency(Project.Calendars.Calendar.Exceptions.Exception exception) {
        Integer period = NumberHelper.getInteger(exception.getPeriod());
        if (period == null) {
            period = 1;
        }
        return period;
    }

    private void readWorkWeeks(Project.Calendars.Calendar xmlCalendar, ProjectCalendar mpxjCalendar) {
        Project.Calendars.Calendar.WorkWeeks ww = xmlCalendar.getWorkWeeks();
        if (ww != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek : ww.getWorkWeek()) {
                ProjectCalendarWeek week = mpxjCalendar.addWorkWeek();
                week.setName(xmlWeek.getName());
                Date startTime = DatatypeConverter.parseDate(xmlWeek.getTimePeriod().getFromDate());
                Date endTime = DatatypeConverter.parseDate(xmlWeek.getTimePeriod().getToDate());
                week.setDateRange(new DateRange(startTime, endTime));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays xmlWeekDays = xmlWeek.getWeekDays();
                if (xmlWeekDays == null) continue;
                for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay xmlWeekDay : xmlWeekDays.getWeekDay()) {
                    int dayNumber = xmlWeekDay.getDayType().intValue();
                    Day day = Day.getInstance(dayNumber);
                    week.setWorkingDay(day, BooleanHelper.getBoolean(xmlWeekDay.isDayWorking()));
                    ProjectCalendarHours hours = week.addCalendarHours(day);
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes times = xmlWeekDay.getWorkingTimes();
                    if (times == null) continue;
                    for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime period : times.getWorkingTime()) {
                        startTime = DatatypeConverter.parseTime(period.getFromTime());
                        endTime = DatatypeConverter.parseTime(period.getToTime());
                        if (startTime == null || endTime == null) continue;
                        if (startTime.getTime() >= endTime.getTime()) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(endTime);
                            cal.add(6, 1);
                            endTime = cal.getTime();
                        }
                        hours.addRange(new DateRange(startTime, endTime));
                    }
                }
            }
        }
    }

    private void readProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes attributes = project.getExtendedAttributes();
        if (attributes != null) {
            for (Project.ExtendedAttributes.ExtendedAttribute ea : attributes.getExtendedAttribute()) {
                this.readFieldAlias(ea);
            }
        }
    }

    private void readFieldAlias(Project.ExtendedAttributes.ExtendedAttribute attribute) {
        String alias = attribute.getAlias();
        if (alias != null && alias.length() != 0) {
            FieldType field = FieldTypeHelper.getInstance(Integer.parseInt(attribute.getFieldID()));
            this.m_projectFile.getCustomFields().getCustomField(field).setAlias(attribute.getAlias());
        }
    }

    private void readResources(Project project, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Project.Resources resources = project.getResources();
        if (resources != null) {
            for (Project.Resources.Resource resource : resources.getResource()) {
                this.readResource(resource, calendarMap);
            }
        }
    }

    private void readResource(Project.Resources.Resource xml, HashMap<BigInteger, ProjectCalendar> calendarMap) {
        Resource mpx = this.m_projectFile.addResource();
        mpx.setAccrueAt(xml.getAccrueAt());
        mpx.setActveDirectoryGUID(xml.getActiveDirectoryGUID());
        mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
        mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
        mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWork()));
        mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualOvertimeWorkProtected()));
        mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWork()));
        mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getActualWorkProtected()));
        mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
        mpx.setAvailableFrom(DatatypeConverter.parseDate(xml.getAvailableFrom()));
        mpx.setAvailableTo(DatatypeConverter.parseDate(xml.getAvailableTo()));
        mpx.setBCWS(DatatypeConverter.parseCurrency(xml.getBCWS()));
        mpx.setBCWP(DatatypeConverter.parseCurrency(xml.getBCWP()));
        mpx.setBookingType(xml.getBookingType());
        mpx.setBudget(BooleanHelper.getBoolean(xml.isIsBudget()));
        mpx.setCanLevel(BooleanHelper.getBoolean(xml.isCanLevel()));
        mpx.setCode(xml.getCode());
        mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
        mpx.setCostPerUse(DatatypeConverter.parseCurrency(xml.getCostPerUse()));
        mpx.setCostVariance(DatatypeConverter.parseCurrency(xml.getCostVariance()));
        mpx.setCreationDate(DatatypeConverter.parseDate(xml.getCreationDate()));
        mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
        mpx.setEmailAddress(xml.getEmailAddress());
        mpx.setGroup(xml.getGroup());
        mpx.setHyperlink(xml.getHyperlink());
        mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
        mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
        mpx.setID(NumberHelper.getInteger(xml.getID()));
        mpx.setInitials(xml.getInitials());
        mpx.setIsEnterprise(BooleanHelper.getBoolean(xml.isIsEnterprise()));
        mpx.setIsGeneric(BooleanHelper.getBoolean(xml.isIsGeneric()));
        mpx.setIsInactive(BooleanHelper.getBoolean(xml.isIsInactive()));
        mpx.setIsNull(BooleanHelper.getBoolean(xml.isIsNull()));
        mpx.setMaterialLabel(xml.getMaterialLabel());
        mpx.setMaxUnits(DatatypeConverter.parseUnits(xml.getMaxUnits()));
        mpx.setName(xml.getName());
        if (xml.getNotes() != null && xml.getNotes().length() != 0) {
            mpx.setNotes(xml.getNotes());
        }
        mpx.setNtAccount(xml.getNTAccount());
        mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
        mpx.setOvertimeRate(DatatypeConverter.parseRate(xml.getOvertimeRate()));
        mpx.setOvertimeRateUnits(DatatypeConverter.parseTimeUnit(xml.getOvertimeRateFormat()));
        mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getOvertimeWork()));
        mpx.setPeakUnits(DatatypeConverter.parseUnits(xml.getPeakUnits()));
        mpx.setPercentWorkComplete(xml.getPercentWorkComplete());
        mpx.setPhonetics(xml.getPhonetics());
        mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRegularWork()));
        mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
        mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
        mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingWork()));
        mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getRemainingOvertimeWork()));
        mpx.setStandardRate(DatatypeConverter.parseRate(xml.getStandardRate()));
        mpx.setStandardRateUnits(DatatypeConverter.parseTimeUnit(xml.getStandardRateFormat()));
        mpx.setSV(DatatypeConverter.parseCurrency(xml.getSV()));
        mpx.setType(xml.getType());
        mpx.setUniqueID(NumberHelper.getInteger(xml.getUID()));
        mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, xml.getWork()));
        mpx.setWorkGroup(xml.getWorkGroup());
        mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getWorkVariance()));
        if (mpx.getType() == ResourceType.MATERIAL && BooleanHelper.getBoolean(xml.isIsCostResource())) {
            mpx.setType(ResourceType.COST);
        }
        this.readResourceExtendedAttributes(xml, mpx);
        this.readResourceBaselines(xml, mpx);
        mpx.setResourceCalendar(calendarMap.get(xml.getCalendarUID()));
        mpx.setOverAllocated(BooleanHelper.getBoolean(xml.isOverAllocated()));
        this.readCostRateTables(mpx, xml.getRates());
        this.readAvailabilityTable(mpx, xml.getAvailabilityPeriods());
        this.m_eventManager.fireResourceReadEvent(mpx);
    }

    private void readResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        for (Project.Resources.Resource.Baseline baseline : xmlResource.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjResource.setBaselineCost(cost);
                mpxjResource.setBaselineWork(work);
                continue;
            }
            mpxjResource.setBaselineCost(number, cost);
            mpxjResource.setBaselineWork(number, work);
        }
    }

    private void readResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        for (Project.Resources.Resource.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            ResourceField mpxFieldID = MPPResourceField.getInstance(xmlFieldID);
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private void readCostRateTables(Resource resource, Project.Resources.Resource.Rates rates) {
        if (rates == null) {
            CostRateTable table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(0, table);
            table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(1, table);
            table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(2, table);
            table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(3, table);
            table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(4, table);
        } else {
            HashSet<CostRateTable> tables = new HashSet<CostRateTable>();
            for (Project.Resources.Resource.Rates.Rate rate : rates.getRate()) {
                Rate standardRate = DatatypeConverter.parseRate(rate.getStandardRate());
                TimeUnit standardRateFormat = DatatypeConverter.parseTimeUnit(rate.getStandardRateFormat());
                Rate overtimeRate = DatatypeConverter.parseRate(rate.getOvertimeRate());
                TimeUnit overtimeRateFormat = DatatypeConverter.parseTimeUnit(rate.getOvertimeRateFormat());
                Double costPerUse = DatatypeConverter.parseCurrency(rate.getCostPerUse());
                Date endDate = DatatypeConverter.parseDate(rate.getRatesTo());
                CostRateTableEntry entry = new CostRateTableEntry(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, costPerUse, endDate);
                int tableIndex = rate.getRateTable().intValue();
                CostRateTable table = resource.getCostRateTable(tableIndex);
                if (table == null) {
                    table = new CostRateTable();
                    resource.setCostRateTable(tableIndex, table);
                }
                table.add(entry);
                tables.add(table);
            }
            for (CostRateTable table : tables) {
                Collections.sort(table);
            }
        }
    }

    private void readAvailabilityTable(Resource resource, Project.Resources.Resource.AvailabilityPeriods periods) {
        if (periods != null) {
            AvailabilityTable table = resource.getAvailability();
            List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = periods.getAvailabilityPeriod();
            for (Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod period : list) {
                Date start = DatatypeConverter.parseDate(period.getAvailableFrom());
                Date end = DatatypeConverter.parseDate(period.getAvailableTo());
                Number units = DatatypeConverter.parseUnits(period.getAvailableUnits());
                Availability availability = new Availability(start, end, units);
                table.add(availability);
            }
            Collections.sort(table);
        }
    }

    private void readTasks(Project project) {
        Project.Tasks tasks = project.getTasks();
        if (tasks != null) {
            int tasksWithoutIDCount = 0;
            for (Project.Tasks.Task task : tasks.getTask()) {
                Task mpxjTask = this.readTask(task);
                if (mpxjTask.getID() != null) continue;
                ++tasksWithoutIDCount;
            }
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
            if (tasksWithoutIDCount == tasks.getTask().size()) {
                this.m_projectFile.renumberTaskIDs();
            }
        }
        this.m_projectFile.updateStructure();
    }

    private Task readTask(Project.Tasks.Task xml) {
        Task mpx = this.m_projectFile.addTask();
        mpx.setNull(BooleanHelper.getBoolean(xml.isIsNull()));
        mpx.setID(NumberHelper.getInteger(xml.getID()));
        mpx.setUniqueID(NumberHelper.getInteger(xml.getUID()));
        if (!mpx.getNull()) {
            double duration;
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(xml.getDurationFormat());
            mpx.setActive(xml.isActive() == null ? true : BooleanHelper.getBoolean(xml.isActive()));
            mpx.setActualCost(DatatypeConverter.parseCurrency(xml.getActualCost()));
            mpx.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualDuration()));
            mpx.setActualFinish(DatatypeConverter.parseDate(xml.getActualFinish()));
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(xml.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualOvertimeWork()));
            mpx.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualOvertimeWorkProtected()));
            mpx.setActualStart(DatatypeConverter.parseDate(xml.getActualStart()));
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualWork()));
            mpx.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getActualWorkProtected()));
            mpx.setACWP(DatatypeConverter.parseCurrency(xml.getACWP()));
            mpx.setCalendar(this.getTaskCalendar(xml));
            mpx.setConstraintDate(DatatypeConverter.parseDate(xml.getConstraintDate()));
            mpx.setConstraintType(DatatypeConverter.parseConstraintType(xml.getConstraintType()));
            mpx.setContact(xml.getContact());
            mpx.setCost(DatatypeConverter.parseCurrency(xml.getCost()));
            mpx.setCreateDate(DatatypeConverter.parseDate(xml.getCreateDate()));
            mpx.setCV(DatatypeConverter.parseCurrency(xml.getCV()));
            mpx.setDeadline(DatatypeConverter.parseDate(xml.getDeadline()));
            mpx.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getDuration()));
            mpx.setDurationText(xml.getDurationText());
            mpx.setEarlyFinish(DatatypeConverter.parseDate(xml.getEarlyFinish()));
            mpx.setEarlyStart(DatatypeConverter.parseDate(xml.getEarlyStart()));
            mpx.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(xml.getEarnedValueMethod()));
            mpx.setEffortDriven(BooleanHelper.getBoolean(xml.isEffortDriven()));
            mpx.setEstimated(BooleanHelper.getBoolean(xml.isEstimated()));
            mpx.setExternalTask(BooleanHelper.getBoolean(xml.isExternalTask()));
            mpx.setProject(xml.getExternalTaskProject());
            mpx.setFinish(DatatypeConverter.parseDate(xml.getFinish()));
            mpx.setFinishText(xml.getFinishText());
            mpx.setFinishVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getFinishVariance()));
            mpx.setFixedCost(DatatypeConverter.parseCurrency(xml.getFixedCost()));
            mpx.setFixedCostAccrual(xml.getFixedCostAccrual());
            mpx.setHideBar(BooleanHelper.getBoolean(xml.isHideBar()));
            mpx.setHyperlink(xml.getHyperlink());
            mpx.setHyperlinkAddress(xml.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(xml.getHyperlinkSubAddress());
            mpx.setIgnoreResourceCalendar(BooleanHelper.getBoolean(xml.isIgnoreResourceCalendar()));
            mpx.setLateFinish(DatatypeConverter.parseDate(xml.getLateFinish()));
            mpx.setLateStart(DatatypeConverter.parseDate(xml.getLateStart()));
            mpx.setLevelAssignments(BooleanHelper.getBoolean(xml.isLevelAssignments()));
            mpx.setLevelingCanSplit(BooleanHelper.getBoolean(xml.isLevelingCanSplit()));
            mpx.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(xml.getLevelingDelayFormat()));
            if (xml.getLevelingDelay() != null && mpx.getLevelingDelayFormat() != null && (duration = xml.getLevelingDelay().doubleValue()) != 0.0) {
                mpx.setLevelingDelay(Duration.convertUnits(duration / 10.0, TimeUnit.MINUTES, mpx.getLevelingDelayFormat(), this.m_projectFile.getProjectProperties()));
            }
            mpx.setMilestone(BooleanHelper.getBoolean(xml.isMilestone()));
            mpx.setName(xml.getName());
            if (xml.getNotes() != null && xml.getNotes().length() != 0) {
                mpx.setNotes(xml.getNotes());
            }
            mpx.setOutlineLevel(NumberHelper.getInteger(xml.getOutlineLevel()));
            mpx.setOutlineNumber(xml.getOutlineNumber());
            mpx.setOverAllocated(BooleanHelper.getBoolean(xml.isOverAllocated()));
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(xml.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getOvertimeWork()));
            mpx.setPercentageComplete(xml.getPercentComplete());
            mpx.setPercentageWorkComplete(xml.getPercentWorkComplete());
            mpx.setPhysicalPercentComplete(NumberHelper.getInteger(xml.getPhysicalPercentComplete()));
            mpx.setPreleveledFinish(DatatypeConverter.parseDate(xml.getPreLeveledFinish()));
            mpx.setPreleveledStart(DatatypeConverter.parseDate(xml.getPreLeveledStart()));
            mpx.setPriority(DatatypeConverter.parsePriority(xml.getPriority()));
            mpx.setRecurring(BooleanHelper.getBoolean(xml.isRecurring()));
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(xml.getRemainingCost()));
            mpx.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingDuration()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(xml.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingOvertimeWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getRemainingWork()));
            mpx.setResume(DatatypeConverter.parseDate(xml.getResume()));
            mpx.setResumeValid(BooleanHelper.getBoolean(xml.isResumeValid()));
            mpx.setRollup(BooleanHelper.getBoolean(xml.isRollup()));
            mpx.setStart(DatatypeConverter.parseDate(xml.getStart()));
            mpx.setStartText(xml.getStartText());
            mpx.setStartVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(xml.getStartVariance()));
            mpx.setStop(DatatypeConverter.parseDate(xml.getStop()));
            mpx.setSubProject(BooleanHelper.getBoolean(xml.isIsSubproject()) ? new SubProject() : null);
            mpx.setSubprojectName(xml.getSubprojectName());
            mpx.setSubprojectReadOnly(BooleanHelper.getBoolean(xml.isIsSubprojectReadOnly()));
            mpx.setSummary(BooleanHelper.getBoolean(xml.isSummary()));
            mpx.setTaskMode(BooleanHelper.getBoolean(xml.isManual()) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
            mpx.setType(xml.getType());
            mpx.setWBS(xml.getWBS());
            mpx.setWBSLevel(xml.getWBSLevel());
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getWork()));
            mpx.setWorkVariance(Duration.getInstance(NumberHelper.getDouble(xml.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
            this.validateFinishDate(mpx);
            mpx.setStartSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getStartSlack()));
            mpx.setFinishSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFinishSlack()));
            mpx.setFreeSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getFreeSlack()));
            mpx.setTotalSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(xml.getTotalSlack()));
            mpx.setCritical(BooleanHelper.getBoolean(xml.isCritical()));
            this.readTaskExtendedAttributes(xml, mpx);
            this.readTaskBaselines(xml, mpx, durationFormat);
            if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                mpx.setManualDuration(DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, xml.getManualDuration()));
            }
            if (NumberHelper.getInt(mpx.getUniqueID()) == 0) {
                this.updateProjectProperties(mpx);
            }
        }
        this.m_eventManager.fireTaskReadEvent(mpx);
        return mpx;
    }

    private void updateProjectProperties(Task task) {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        props.setComments(task.getNotes());
    }

    private void validateFinishDate(Task task) {
        Date startDate;
        if (task.getFinish() == null && (startDate = task.getStart()) != null) {
            if (task.getMilestone()) {
                task.setFinish(startDate);
            } else {
                Duration duration = task.getDuration();
                if (duration != null) {
                    ProjectCalendar calendar = task.getEffectiveCalendar();
                    task.setFinish(calendar.getDate(startDate, duration, false));
                }
            }
        }
    }

    private void readTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask, TimeUnit durationFormat) {
        for (Project.Tasks.Task.Baseline baseline : xmlTask.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Double cost = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, durationFormat, baseline.getDuration());
            Date finish = DatatypeConverter.parseDate(baseline.getFinish());
            Date start = DatatypeConverter.parseDate(baseline.getStart());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpxjTask.setBaselineCost(cost);
                mpxjTask.setBaselineDuration(duration);
                mpxjTask.setBaselineFinish(finish);
                mpxjTask.setBaselineStart(start);
                mpxjTask.setBaselineWork(work);
                continue;
            }
            mpxjTask.setBaselineCost(number, cost);
            mpxjTask.setBaselineDuration(number, duration);
            mpxjTask.setBaselineFinish(number, finish);
            mpxjTask.setBaselineStart(number, start);
            mpxjTask.setBaselineWork(number, work);
        }
    }

    private void readTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        for (Project.Tasks.Task.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            TaskField mpxFieldID = MPPTaskField.getInstance(xmlFieldID);
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private ProjectCalendar getTaskCalendar(Project.Tasks.Task task) {
        ProjectCalendar calendar = null;
        BigInteger calendarID = task.getCalendarUID();
        if (calendarID != null) {
            calendar = this.m_projectFile.getCalendarByUniqueID(calendarID.intValue());
        }
        return calendar;
    }

    private void readPredecessors(Project.Tasks.Task task) {
        Task currTask;
        Integer uid = task.getUID();
        if (uid != null && (currTask = this.m_projectFile.getTaskByUniqueID(uid)) != null) {
            for (Project.Tasks.Task.PredecessorLink link : task.getPredecessorLink()) {
                this.readPredecessor(currTask, link);
            }
        }
    }

    private void readPredecessor(Task currTask, Project.Tasks.Task.PredecessorLink link) {
        Task prevTask;
        BigInteger uid = link.getPredecessorUID();
        if (uid != null && (prevTask = this.m_projectFile.getTaskByUniqueID(uid.intValue())) != null) {
            RelationType type = link.getType() != null ? RelationType.getInstance(link.getType().intValue()) : RelationType.FINISH_START;
            int lag = link.getLinkLag() != null ? link.getLinkLag().intValue() / 10 : 0;
            TimeUnit lagUnits = DatatypeConverter.parseDurationTimeUnits(link.getLagFormat());
            Duration lagDuration = Duration.convertUnits(lag, TimeUnit.MINUTES, lagUnits, this.m_projectFile.getProjectProperties());
            Relation relation = currTask.addPredecessor(prevTask, type, lagDuration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readAssignments(Project project) {
        Project.Assignments assignments = project.getAssignments();
        if (assignments != null) {
            SplitTaskFactory splitFactory = new SplitTaskFactory();
            MSPDITimephasedWorkNormaliser normaliser = new MSPDITimephasedWorkNormaliser();
            for (Project.Assignments.Assignment assignment : assignments.getAssignment()) {
                this.readAssignment(assignment, splitFactory, normaliser);
            }
        }
    }

    private void readAssignment(Project.Assignments.Assignment assignment, SplitTaskFactory splitFactory, TimephasedWorkNormaliser normaliser) {
        Task task;
        BigInteger taskUID = assignment.getTaskUID();
        BigInteger resourceUID = assignment.getResourceUID();
        if (taskUID != null && resourceUID != null && (task = this.m_projectFile.getTaskByUniqueID(taskUID.intValue())) != null) {
            Resource resource = this.m_projectFile.getResourceByUniqueID(resourceUID.intValue());
            ProjectCalendar calendar = null;
            if (resource != null) {
                calendar = resource.getResourceCalendar();
            }
            if (calendar == null || task.getIgnoreResourceCalendar()) {
                calendar = task.getEffectiveCalendar();
            }
            LinkedList<TimephasedWork> timephasedComplete = this.readTimephasedAssignment(calendar, assignment, 2);
            LinkedList<TimephasedWork> timephasedPlanned = this.readTimephasedAssignment(calendar, assignment, 1);
            boolean raw = true;
            if (this.isSplit(calendar, timephasedComplete) || this.isSplit(calendar, timephasedPlanned)) {
                task.setSplits(new LinkedList<DateRange>());
                normaliser.normalise(calendar, timephasedComplete);
                normaliser.normalise(calendar, timephasedPlanned);
                splitFactory.processSplitData(task, timephasedComplete, timephasedPlanned);
                raw = false;
            }
            DefaultTimephasedWorkContainer timephasedCompleteData = new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedComplete, raw);
            DefaultTimephasedWorkContainer timephasedPlannedData = new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedPlanned, raw);
            ResourceAssignment mpx = task.addResourceAssignment(resource);
            mpx.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
            mpx.setActualFinish(DatatypeConverter.parseDate(assignment.getActualFinish()));
            mpx.setActualOvertimeCost(DatatypeConverter.parseCurrency(assignment.getActualOvertimeCost()));
            mpx.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualOvertimeWork()));
            mpx.setActualStart(DatatypeConverter.parseDate(assignment.getActualStart()));
            mpx.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
            mpx.setACWP(DatatypeConverter.parseCurrency(assignment.getACWP()));
            mpx.setBCWP(DatatypeConverter.parseCurrency(assignment.getBCWP()));
            mpx.setBCWS(DatatypeConverter.parseCurrency(assignment.getBCWS()));
            mpx.setBudgetCost(DatatypeConverter.parseCurrency(assignment.getBudgetCost()));
            mpx.setBudgetWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getBudgetWork()));
            mpx.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
            mpx.setCostRateTableIndex(NumberHelper.getInt(assignment.getCostRateTable()));
            mpx.setCreateDate(DatatypeConverter.parseDate(assignment.getCreationDate()));
            mpx.setCV(DatatypeConverter.parseCurrency(assignment.getCV()));
            mpx.setDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(assignment.getDelay()));
            mpx.setFinish(DatatypeConverter.parseDate(assignment.getFinish()));
            mpx.setVariableRateUnits(BooleanHelper.getBoolean(assignment.isHasFixedRateUnits()) ? null : DatatypeConverter.parseTimeUnit(assignment.getRateScale()));
            mpx.setHyperlink(assignment.getHyperlink());
            mpx.setHyperlinkAddress(assignment.getHyperlinkAddress());
            mpx.setHyperlinkSubAddress(assignment.getHyperlinkSubAddress());
            mpx.setLevelingDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getLevelingDelay(), DatatypeConverter.parseDurationTimeUnits(assignment.getLevelingDelayFormat())));
            mpx.setNotes(assignment.getNotes());
            mpx.setOvertimeCost(DatatypeConverter.parseCurrency(assignment.getOvertimeCost()));
            mpx.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
            mpx.setPercentageWorkComplete(assignment.getPercentWorkComplete());
            mpx.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRegularWork()));
            mpx.setRemainingCost(DatatypeConverter.parseCurrency(assignment.getRemainingCost()));
            mpx.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(assignment.getRemainingOvertimeCost()));
            mpx.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingOvertimeWork()));
            mpx.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
            mpx.setResume(DatatypeConverter.parseDate(assignment.getResume()));
            mpx.setStart(DatatypeConverter.parseDate(assignment.getStart()));
            mpx.setStop(DatatypeConverter.parseDate(assignment.getStop()));
            mpx.setSV(DatatypeConverter.parseCurrency(assignment.getSV()));
            mpx.setUniqueID(NumberHelper.getInteger(assignment.getUID()));
            mpx.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
            mpx.setVAC(DatatypeConverter.parseCurrency(assignment.getVAC()));
            mpx.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
            mpx.setWorkContour(assignment.getWorkContour());
            mpx.setTimephasedActualWork(timephasedCompleteData);
            mpx.setTimephasedWork(timephasedPlannedData);
            this.readAssignmentExtendedAttributes(assignment, mpx);
            this.readAssignmentBaselines(assignment, mpx);
            mpx.setCostVariance(DatatypeConverter.parseCurrency(assignment.getCostVariance()));
            mpx.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getWorkVariance(), TimeUnit.HOURS));
            mpx.setStartVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getStartVariance(), TimeUnit.DAYS));
            mpx.setFinishVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getFinishVariance(), TimeUnit.DAYS));
            this.m_eventManager.fireAssignmentReadEvent(mpx);
        }
    }

    private void readAssignmentBaselines(Project.Assignments.Assignment assignment, ResourceAssignment mpx) {
        for (Project.Assignments.Assignment.Baseline baseline : assignment.getBaseline()) {
            int number = NumberHelper.getInt(baseline.getNumber());
            Number cost = DatatypeConverter.parseExtendedAttributeCurrency(baseline.getCost());
            Date finish = DatatypeConverter.parseExtendedAttributeDate(baseline.getFinish());
            Date start = DatatypeConverter.parseExtendedAttributeDate(baseline.getStart());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (number == 0) {
                mpx.setBaselineCost(cost);
                mpx.setBaselineFinish(finish);
                mpx.setBaselineStart(start);
                mpx.setBaselineWork(work);
                continue;
            }
            mpx.setBaselineCost(number, cost);
            mpx.setBaselineWork(number, work);
            mpx.setBaselineStart(number, start);
            mpx.setBaselineFinish(number, finish);
        }
    }

    private void readAssignmentExtendedAttributes(Project.Assignments.Assignment xml, ResourceAssignment mpx) {
        for (Project.Assignments.Assignment.ExtendedAttribute attrib : xml.getExtendedAttribute()) {
            int xmlFieldID = Integer.parseInt(attrib.getFieldID()) & 0xFFFF;
            AssignmentField mpxFieldID = MPPAssignmentField.getInstance(xmlFieldID);
            TimeUnit durationFormat = DatatypeConverter.parseDurationTimeUnits(attrib.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, mpx, attrib.getValue(), mpxFieldID, durationFormat);
        }
    }

    private boolean isSplit(ProjectCalendar calendar, List<TimephasedWork> list) {
        boolean result = false;
        for (TimephasedWork assignment : list) {
            Duration calendarWork;
            if (calendar == null || ((Duration)assignment.getTotalAmount()).getDuration() != 0.0 || (calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES)).getDuration() == 0.0) continue;
            result = true;
            break;
        }
        return result;
    }

    private LinkedList<TimephasedWork> readTimephasedAssignment(ProjectCalendar calendar, Project.Assignments.Assignment assignment, int type) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        for (TimephasedDataType item : assignment.getTimephasedData()) {
            if (NumberHelper.getInt(item.getType()) != type) continue;
            Date startDate = DatatypeConverter.parseDate(item.getStart());
            Date finishDate = DatatypeConverter.parseDate(item.getFinish());
            Duration work = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.MINUTES, item.getValue());
            work = work == null ? Duration.getInstance(0, TimeUnit.MINUTES) : Duration.getInstance(NumberHelper.round(work.getDuration(), 2.0), TimeUnit.MINUTES);
            TimephasedWork tra = new TimephasedWork();
            tra.setStart(startDate);
            tra.setFinish(finishDate);
            tra.setTotalAmount(work);
            result.add(tra);
        }
        return result;
    }

    public void setMicrosoftProjectCompatibleInput(boolean flag) {
        this.m_compatibleInput = flag;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema", (ClassLoader)MSPDIReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        RECURRENCE_TYPES = new RecurrenceType[]{null, RecurrenceType.DAILY, RecurrenceType.YEARLY, RecurrenceType.YEARLY, RecurrenceType.MONTHLY, RecurrenceType.MONTHLY, RecurrenceType.WEEKLY, RecurrenceType.DAILY};
        RELATIVE_MAP = new boolean[]{false, false, false, true, false, true};
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
    }
}

