/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.TimeUnit;

final class RecurrenceUtility {
    private static final TimeUnit[] DURATION_UNITS = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.WEEKS, TimeUnit.HOURS, TimeUnit.MINUTES};
    private static final Map<TimeUnit, Integer> UNITS_MAP = new HashMap<TimeUnit, Integer>();
    private static final Map<Integer, RecurrenceType> RECURRENCE_TYPE_MAP;
    private static final Map<RecurrenceType, Integer> RECURRENCE_VALUE_MAP;
    private static final Day[] DAY_ARRAY;
    private static final Map<Day, Integer> DAY_MAP;
    public static final int[] RECURRING_TASK_DAY_MASKS;

    private RecurrenceUtility() {
    }

    public static Duration getDuration(ProjectProperties properties, Integer durationValue, Integer unitsValue) {
        Duration result;
        if (durationValue == null) {
            result = null;
        } else {
            result = Duration.getInstance(durationValue, TimeUnit.MINUTES);
            TimeUnit units = RecurrenceUtility.getDurationUnits(unitsValue);
            if (result.getUnits() != units) {
                result = result.convertUnits(units, properties);
            }
        }
        return result;
    }

    public static Integer getDurationValue(ProjectProperties properties, Duration duration) {
        Integer result;
        if (duration == null) {
            result = null;
        } else {
            if (duration.getUnits() != TimeUnit.MINUTES) {
                duration = duration.convertUnits(TimeUnit.MINUTES, properties);
            }
            result = (int)duration.getDuration();
        }
        return result;
    }

    public static Integer getDurationUnits(RecurringTask recurrence) {
        Duration duration = recurrence.getDuration();
        Integer result = null;
        if (duration != null) {
            result = UNITS_MAP.get(duration.getUnits());
        }
        return result;
    }

    private static TimeUnit getDurationUnits(Integer value) {
        int index;
        TimeUnit result = null;
        if (value != null && (index = value.intValue()) >= 0 && index < DURATION_UNITS.length) {
            result = DURATION_UNITS[index];
        }
        if (result == null) {
            result = TimeUnit.DAYS;
        }
        return result;
    }

    public static RecurrenceType getRecurrenceType(Integer value) {
        return RECURRENCE_TYPE_MAP.get(value);
    }

    public static Integer getRecurrenceValue(RecurrenceType value) {
        return RECURRENCE_VALUE_MAP.get(value);
    }

    public static Integer getDays(String days) {
        Integer result = null;
        if (days != null) {
            result = Integer.parseInt(days, 2);
        }
        return result;
    }

    public static String getDays(RecurringTask task) {
        StringBuilder sb = new StringBuilder();
        for (Day day : Day.values()) {
            sb.append(task.getWeeklyDay(day) ? "1" : "0");
        }
        return sb.toString();
    }

    public static Day getDay(Integer day) {
        Day result = null;
        if (day != null) {
            result = DAY_ARRAY[day];
        }
        return result;
    }

    public static Integer getDay(Day day) {
        Integer result = null;
        if (day != null) {
            result = DAY_MAP.get(day);
        }
        return result;
    }

    public static Date getYearlyAbsoluteAsDate(RecurringData data) {
        Date result;
        Integer yearlyAbsoluteDay = data.getDayNumber();
        Integer yearlyAbsoluteMonth = data.getMonthNumber();
        Date startDate = data.getStartDate();
        if (yearlyAbsoluteDay == null || yearlyAbsoluteMonth == null || startDate == null) {
            result = null;
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            cal.set(2, yearlyAbsoluteMonth - 1);
            cal.set(5, yearlyAbsoluteDay);
            result = cal.getTime();
        }
        return result;
    }

    static {
        for (int loop = 0; loop < DURATION_UNITS.length; ++loop) {
            UNITS_MAP.put(DURATION_UNITS[loop], loop);
        }
        RECURRENCE_TYPE_MAP = new HashMap<Integer, RecurrenceType>();
        RECURRENCE_TYPE_MAP.put(1, RecurrenceType.DAILY);
        RECURRENCE_TYPE_MAP.put(4, RecurrenceType.WEEKLY);
        RECURRENCE_TYPE_MAP.put(8, RecurrenceType.MONTHLY);
        RECURRENCE_TYPE_MAP.put(16, RecurrenceType.YEARLY);
        RECURRENCE_VALUE_MAP = new HashMap<RecurrenceType, Integer>();
        RECURRENCE_VALUE_MAP.put(RecurrenceType.DAILY, 1);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.WEEKLY, 4);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.MONTHLY, 8);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.YEARLY, 16);
        DAY_ARRAY = new Day[]{null, Day.MONDAY, Day.TUESDAY, Day.WEDNESDAY, Day.THURSDAY, Day.FRIDAY, Day.SATURDAY, Day.SUNDAY};
        DAY_MAP = new HashMap<Day, Integer>();
        DAY_MAP.put(Day.MONDAY, 1);
        DAY_MAP.put(Day.TUESDAY, 2);
        DAY_MAP.put(Day.WEDNESDAY, 3);
        DAY_MAP.put(Day.THURSDAY, 4);
        DAY_MAP.put(Day.FRIDAY, 5);
        DAY_MAP.put(Day.SATURDAY, 6);
        DAY_MAP.put(Day.SUNDAY, 7);
        RECURRING_TASK_DAY_MASKS = new int[]{0, 64, 32, 16, 8, 4, 2, 1};
    }
}

