/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.VarMeta;

final class Var2Data
extends MPPComponent {
    private TreeMap<Integer, byte[]> m_map = new TreeMap();
    private VarMeta m_meta;

    Var2Data(VarMeta meta, InputStream is) throws IOException {
        this.m_meta = meta;
        int currentOffset = 0;
        int available = is.available();
        for (int itemOffset : meta.getOffsets()) {
            byte[] data;
            if (itemOffset >= available) continue;
            if (currentOffset > itemOffset) {
                is.reset();
                is.skip(itemOffset);
            } else if (currentOffset < itemOffset) {
                is.skip(itemOffset - currentOffset);
            }
            int size = this.readInt(is);
            if (size < 0 || size > is.available()) continue;
            try {
                data = this.readByteArray(is, size);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                break;
            }
            this.m_map.put(itemOffset, data);
            currentOffset = itemOffset + 4 + size;
        }
    }

    public byte[] getByteArray(Integer offset) {
        byte[] result = null;
        if (offset != null) {
            result = this.m_map.get(offset);
        }
        return result;
    }

    public byte[] getByteArray(Integer id, Integer type) {
        return this.getByteArray(this.m_meta.getOffset(id, type));
    }

    public String getUnicodeString(Integer offset) {
        byte[] value;
        String result = null;
        if (offset != null && (value = this.m_map.get(offset)) != null) {
            result = MPPUtility.getUnicodeString(value, 0);
        }
        return result;
    }

    public String getUnicodeString(Integer id, Integer type) {
        return this.getUnicodeString(this.m_meta.getOffset(id, type));
    }

    public Date getTimestamp(Integer id, Integer type) {
        byte[] value;
        Date result = null;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 4) {
            result = MPPUtility.getTimestamp(value, 0);
        }
        return result;
    }

    public String getString(Integer offset) {
        byte[] value;
        String result = null;
        if (offset != null && (value = this.m_map.get(offset)) != null) {
            result = MPPUtility.getString(value, 0);
        }
        return result;
    }

    public String getString(Integer id, Integer type) {
        return this.getString(this.m_meta.getOffset(id, type));
    }

    public int getShort(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 2) {
            result = MPPUtility.getShort(value, 0);
        }
        return result;
    }

    public int getByte(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null) {
            result = MPPUtility.getByte(value, 0);
        }
        return result;
    }

    public int getInt(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 4) {
            result = MPPUtility.getInt(value, 0);
        }
        return result;
    }

    public int getInt(Integer id, int offset, Integer type) {
        byte[] value;
        int result = 0;
        Integer metaOffset = this.m_meta.getOffset(id, type);
        if (metaOffset != null && (value = this.m_map.get(metaOffset)) != null && value.length >= offset + 4) {
            result = MPPUtility.getInt(value, offset);
        }
        return result;
    }

    public long getLong(Integer id, Integer type) {
        byte[] value;
        long result = 0L;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 8) {
            result = MPPUtility.getLong(value, 0);
        }
        return result;
    }

    public double getDouble(Integer id, Integer type) {
        double result = Double.longBitsToDouble(this.getLong(id, type));
        if (Double.isNaN(result)) {
            result = 0.0;
        }
        return result;
    }

    public VarMeta getVarMeta() {
        return this.m_meta;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN Var2Data");
        for (Map.Entry<Integer, byte[]> entry : this.m_map.entrySet()) {
            pw.println("   Data at offset: " + entry.getKey() + " size: " + entry.getValue().length);
            pw.println(MPPUtility.hexdump(entry.getValue(), true, 16, "   "));
        }
        pw.println("END Var2Data");
        pw.println();
        pw.close();
        return sw.toString();
    }

    public String toString(Integer id) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN Var2Data for " + id);
        for (Integer type : this.m_meta.getTypes(id)) {
            Integer offset = this.m_meta.getOffset(id, type);
            byte[] data = this.m_map.get(offset);
            pw.println("   Data at offset: " + offset + " size: " + data.length);
            pw.println(MPPUtility.hexdump(data, true, 16, "   "));
        }
        pw.println("END Var2Data for " + id);
        pw.println();
        pw.close();
        return sw.toString();
    }
}

