/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum TimescaleAlignment implements MpxjEnum
{
    LEFT(0, "Left"),
    CENTER(1, "Center"),
    RIGHT(2, "Right");

    private static final TimescaleAlignment[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private TimescaleAlignment(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static TimescaleAlignment getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = CENTER.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TimescaleAlignment getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return TimescaleAlignment.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (TimescaleAlignment[])EnumHelper.createTypeArray(TimescaleAlignment.class);
    }
}

