/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.List;
import java.util.Set;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.DefaultTimephasedWorkContainer;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.RtfHelper;
import net.sf.mpxj.common.SplitTaskFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPTimephasedBaselineCostNormaliser;
import net.sf.mpxj.mpp.MPPTimephasedBaselineWorkNormaliser;
import net.sf.mpxj.mpp.MPPTimephasedWorkNormaliser;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MppBitFlag;
import net.sf.mpxj.mpp.TimephasedDataFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class ResourceAssignmentFactory {
    private static final Integer MPP9_CREATION_DATA = 138;
    private static final MppBitFlag[] ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG1, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG10, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 28, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 28, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 28, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 28, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 28, 0x1000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 28, 0x2000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 28, 0x4000000, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] MPP14_ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG10, 28, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG1, 28, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 28, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 28, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 28, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 28, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 28, 0x100000, Boolean.FALSE, Boolean.TRUE)};
    private static final Duration DEFAULT_NORMALIZER_WORK_PER_DAY = Duration.getInstance(480, TimeUnit.MINUTES);

    public void process(ProjectFile file, FieldMap fieldMap, FieldMap enterpriseCustomFieldMap, boolean useRawTimephasedData, boolean preserveNoteFormatting, VarMeta assnVarMeta, Var2Data assnVarData, FixedMeta assnFixedMeta, FixedData assnFixedData, FixedData assnFixedData2, int count) {
        Set<Integer> set = assnVarMeta.getUniqueIdentifierSet();
        TimephasedDataFactory timephasedFactory = new TimephasedDataFactory();
        SplitTaskFactory splitFactory = new SplitTaskFactory();
        MPPTimephasedWorkNormaliser normaliser = new MPPTimephasedWorkNormaliser();
        MPPTimephasedBaselineWorkNormaliser baselineWorkNormaliser = new MPPTimephasedBaselineWorkNormaliser();
        MPPTimephasedBaselineCostNormaliser baselineCostNormaliser = new MPPTimephasedBaselineCostNormaliser();
        ProjectCalendar baselineCalendar = file.getBaselineCalendar();
        MppBitFlag[] metaDataBitFlags = NumberHelper.getInt(file.getProjectProperties().getMppFileType()) == 14 ? MPP14_ASSIGNMENT_META_DATA_BIT_FLAGS : ASSIGNMENT_META_DATA_BIT_FLAGS;
        for (int loop = 0; loop < count; ++loop) {
            byte[] creationData;
            int id;
            Integer varDataId;
            int offset;
            byte[] data;
            byte[] meta = assnFixedMeta.getByteArrayValue(loop);
            if (meta[0] != 0 || (data = assnFixedData.getByteArrayValue(assnFixedData.getIndexFromOffset(offset = MPPUtility.getInt(meta, 4)))) == null) continue;
            if (data.length < fieldMap.getMaxFixedDataSize(0)) {
                byte[] newData = new byte[fieldMap.getMaxFixedDataSize(0)];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            if (!set.contains(varDataId = Integer.valueOf(id = MPPUtility.getInt(data, fieldMap.getFixedDataOffset(AssignmentField.UNIQUE_ID))))) continue;
            byte[] data2 = null;
            if (assnFixedData2 != null) {
                data2 = assnFixedData2.getByteArrayValue(loop);
            }
            ResourceAssignment assignment = new ResourceAssignment(file, null);
            assignment.disableEvents();
            fieldMap.populateContainer(AssignmentField.class, assignment, varDataId, new byte[][]{data, data2}, assnVarData);
            if (enterpriseCustomFieldMap != null) {
                enterpriseCustomFieldMap.populateContainer(AssignmentField.class, assignment, varDataId, null, assnVarData);
            }
            assignment.enableEvents();
            for (MppBitFlag flag : metaDataBitFlags) {
                flag.setValue(assignment, meta);
            }
            assignment.setConfirmed((meta[8] & 0x80) != 0);
            assignment.setResponsePending((meta[9] & 1) != 0);
            assignment.setTeamStatusPending((meta[10] & 2) != 0);
            this.processHyperlinkData(assignment, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.HYPERLINK_DATA)));
            if (NumberHelper.getInt(file.getProjectProperties().getMppFileType()) == 9 && assignment.getCreateDate() == null && (creationData = assnVarData.getByteArray(varDataId, MPP9_CREATION_DATA)) != null && creationData.length >= 28) {
                assignment.setCreateDate(MPPUtility.getTimestamp(creationData, 24));
            }
            String notes = assignment.getNotes();
            if (!preserveNoteFormatting) {
                notes = RtfHelper.strip(notes);
            }
            assignment.setNotes(notes);
            Task task = file.getTaskByUniqueID(assignment.getTaskUniqueID());
            if (task == null) continue;
            task.addResourceAssignment(assignment);
            Resource resource = file.getResourceByUniqueID(assignment.getResourceUniqueID());
            ProjectCalendar calendar = null;
            if (resource != null) {
                calendar = resource.getResourceCalendar();
            }
            if (calendar == null || task.getIgnoreResourceCalendar()) {
                calendar = task.getEffectiveCalendar();
            }
            assignment.setTimephasedBaselineWork(0, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(1, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE1_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(2, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE2_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(3, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE3_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(4, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE4_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(5, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE5_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(6, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE6_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(7, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE7_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(8, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE8_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(9, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE9_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineWork(10, timephasedFactory.getBaselineWork(assignment, baselineCalendar, baselineWorkNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE10_WORK)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(0, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(1, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE1_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(2, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE2_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(3, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE3_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(4, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE4_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(5, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE5_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(6, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE6_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(7, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE7_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(8, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE8_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(9, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE9_COST)), !useRawTimephasedData));
            assignment.setTimephasedBaselineCost(10, timephasedFactory.getBaselineCost(baselineCalendar, baselineCostNormaliser, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_BASELINE10_COST)), !useRawTimephasedData));
            byte[] timephasedActualWorkData = assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_WORK));
            byte[] timephasedWorkData = assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_WORK));
            byte[] timephasedActualOvertimeWorkData = assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_OVERTIME_WORK));
            List<TimephasedWork> timephasedActualWork = timephasedFactory.getCompleteWork(calendar, assignment, timephasedActualWorkData);
            List<TimephasedWork> timephasedWork = timephasedFactory.getPlannedWork(calendar, assignment.getStart(), assignment.getUnits().doubleValue(), timephasedWorkData, timephasedActualWork);
            List<TimephasedWork> timephasedActualOvertimeWork = timephasedFactory.getCompleteWork(calendar, assignment, timephasedActualOvertimeWorkData);
            assignment.setActualStart(timephasedActualWork.isEmpty() ? null : assignment.getStart());
            assignment.setActualFinish(assignment.getRemainingWork().getDuration() == 0.0 && resource != null ? assignment.getFinish() : null);
            if (task.getSplits() != null && task.getSplits().isEmpty()) {
                splitFactory.processSplitData(task, timephasedActualWork, timephasedWork);
            }
            this.createTimephasedData(file, assignment, timephasedWork, timephasedActualWork);
            assignment.setTimephasedWork(new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedWork, !useRawTimephasedData));
            assignment.setTimephasedActualWork(new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedActualWork, !useRawTimephasedData));
            assignment.setTimephasedActualOvertimeWork(new DefaultTimephasedWorkContainer(calendar, normaliser, timephasedActualOvertimeWork, !useRawTimephasedData));
            if (timephasedWorkData != null) {
                if (timephasedFactory.getWorkModified(timephasedWork)) {
                    assignment.setWorkContour(WorkContour.CONTOURED);
                } else if (timephasedWorkData.length >= 30) {
                    assignment.setWorkContour(WorkContour.getInstance(MPPUtility.getShort(timephasedWorkData, 28)));
                } else {
                    assignment.setWorkContour(WorkContour.FLAT);
                }
            }
            file.getEventManager().fireAssignmentReadEvent(assignment);
        }
    }

    private void processHyperlinkData(ResourceAssignment assignment, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (subaddress.length() + 1) * 2;
            String screentip = MPPUtility.getUnicodeString(data, offset += 12);
            assignment.setHyperlink(hyperlink);
            assignment.setHyperlinkAddress(address);
            assignment.setHyperlinkSubAddress(subaddress);
            assignment.setHyperlinkScreenTip(screentip);
        }
    }

    private void createTimephasedData(ProjectFile file, ResourceAssignment assignment, List<TimephasedWork> timephasedPlanned, List<TimephasedWork> timephasedComplete) {
        if (timephasedPlanned.isEmpty() && timephasedComplete.isEmpty()) {
            Duration workPerDay;
            Duration totalMinutes = assignment.getWork().convertUnits(TimeUnit.MINUTES, file.getProjectProperties());
            if (assignment.getResource() == null || assignment.getResource().getType() == ResourceType.WORK) {
                workPerDay = totalMinutes.getDuration() == 0.0 ? totalMinutes : DEFAULT_NORMALIZER_WORK_PER_DAY;
                int units = NumberHelper.getInt(assignment.getUnits());
                if (units != 100) {
                    workPerDay = Duration.getInstance(workPerDay.getDuration() * (double)units / 100.0, workPerDay.getUnits());
                }
            } else if (assignment.getVariableRateUnits() == null) {
                Duration workingDays = assignment.getCalendar().getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.DAYS);
                double units = NumberHelper.getDouble(assignment.getUnits());
                double unitsPerDayAsMinutes = units * 60.0 / (workingDays.getDuration() * 100.0);
                workPerDay = Duration.getInstance(unitsPerDayAsMinutes, TimeUnit.MINUTES);
            } else {
                double unitsPerHour = NumberHelper.getDouble(assignment.getUnits());
                workPerDay = DEFAULT_NORMALIZER_WORK_PER_DAY;
                Duration hoursPerDay = workPerDay.convertUnits(TimeUnit.HOURS, file.getProjectProperties());
                double unitsPerDayAsHours = unitsPerHour * hoursPerDay.getDuration() / 100.0;
                double unitsPerDayAsMinutes = unitsPerDayAsHours * 60.0;
                workPerDay = Duration.getInstance(unitsPerDayAsMinutes, TimeUnit.MINUTES);
            }
            Duration overtimeWork = assignment.getOvertimeWork();
            if (overtimeWork != null && overtimeWork.getDuration() != 0.0) {
                Duration totalOvertimeMinutes = overtimeWork.convertUnits(TimeUnit.MINUTES, file.getProjectProperties());
                totalMinutes = Duration.getInstance(totalMinutes.getDuration() - totalOvertimeMinutes.getDuration(), TimeUnit.MINUTES);
            }
            TimephasedWork tra = new TimephasedWork();
            tra.setStart(assignment.getStart());
            tra.setAmountPerDay(workPerDay);
            tra.setModified(false);
            tra.setFinish(assignment.getFinish());
            tra.setTotalAmount(totalMinutes);
            timephasedPlanned.add(tra);
        }
    }
}

