/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GenericCriteria;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FilterCriteriaReader12;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GanttBarDateFormat;
import net.sf.mpxj.mpp.GanttBarStyleFactoryCommon;
import net.sf.mpxj.mpp.GanttChartView;
import net.sf.mpxj.mpp.GridLines;
import net.sf.mpxj.mpp.Interval;
import net.sf.mpxj.mpp.LineStyle;
import net.sf.mpxj.mpp.LinkStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.NonWorkingTimeStyle;
import net.sf.mpxj.mpp.ProgressLineDay;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.TableFontStyle;
import net.sf.mpxj.mpp.TimescaleAlignment;
import net.sf.mpxj.mpp.TimescaleFormat;
import net.sf.mpxj.mpp.TimescaleTier;
import net.sf.mpxj.mpp.TimescaleUnits;
import net.sf.mpxj.mpp.Var2Data;

public final class GanttChartView12
extends GanttChartView {
    private static final Integer PROPERTIES = 6;

    @Override
    protected Integer getPropertiesID() {
        return PROPERTIES;
    }

    @Override
    protected void processDefaultBarStyles(Props props) {
        GanttBarStyleFactoryCommon f = new GanttBarStyleFactoryCommon();
        this.m_barStyles = f.processDefaultStyles(props);
    }

    @Override
    protected void processExceptionBarStyles(Props props) {
        GanttBarStyleFactoryCommon f = new GanttBarStyleFactoryCommon();
        this.m_barStyleExceptions = f.processExceptionStyles(props);
    }

    @Override
    protected void processAutoFilters(byte[] data) {
        int blockSize;
        int filterCount = MPPUtility.getShort(data, 8);
        int offset = 16;
        FilterCriteriaReader12 criteria = new FilterCriteriaReader12();
        LinkedList<FieldType> fields = new LinkedList<FieldType>();
        for (int loop = 0; loop < filterCount && (blockSize = MPPUtility.getShort(data, offset)) != 0; ++loop) {
            int entryOffset = MPPUtility.getShort(data, offset + 12);
            fields.clear();
            GenericCriteria c = criteria.process(this.m_properties, data, offset + 4, entryOffset, null, fields, null);
            if (!fields.isEmpty()) {
                Filter filter = new Filter();
                filter.setCriteria(c);
                this.m_autoFilters.add(filter);
                this.m_autoFiltersByType.put(fields.get(0), filter);
            }
            offset += blockSize;
        }
    }

    @Override
    protected void processViewProperties(Map<Integer, FontBase> fontBases, Props props) {
        byte[] timescaleData;
        byte[] viewPropertyData = props.getByteArray(VIEW_PROPERTIES);
        if (viewPropertyData != null) {
            this.m_highlightedTasksFontStyle = this.getFontStyle(viewPropertyData, 26, fontBases);
            this.m_rowAndColumnFontStyle = this.getFontStyle(viewPropertyData, 30, fontBases);
            this.m_nonCriticalTasksFontStyle = this.getFontStyle(viewPropertyData, 34, fontBases);
            this.m_criticalTasksFontStyle = this.getFontStyle(viewPropertyData, 38, fontBases);
            this.m_summaryTasksFontStyle = this.getFontStyle(viewPropertyData, 42, fontBases);
            this.m_milestoneTasksFontStyle = this.getFontStyle(viewPropertyData, 46, fontBases);
            this.m_middleTimescaleFontStyle = this.getFontStyle(viewPropertyData, 50, fontBases);
            this.m_bottomTimescaleFontStyle = this.getFontStyle(viewPropertyData, 54, fontBases);
            this.m_barTextLeftFontStyle = this.getFontStyle(viewPropertyData, 58, fontBases);
            this.m_barTextRightFontStyle = this.getFontStyle(viewPropertyData, 62, fontBases);
            this.m_barTextTopFontStyle = this.getFontStyle(viewPropertyData, 66, fontBases);
            this.m_barTextBottomFontStyle = this.getFontStyle(viewPropertyData, 70, fontBases);
            this.m_barTextInsideFontStyle = this.getFontStyle(viewPropertyData, 74, fontBases);
            this.m_markedTasksFontStyle = this.getFontStyle(viewPropertyData, 78, fontBases);
            this.m_projectSummaryTasksFontStyle = this.getFontStyle(viewPropertyData, 82, fontBases);
            this.m_externalTasksFontStyle = this.getFontStyle(viewPropertyData, 86, fontBases);
            this.m_topTimescaleFontStyle = this.getFontStyle(viewPropertyData, 90, fontBases);
            this.m_sheetRowsGridLines = this.getGridLines(viewPropertyData, 99);
            this.m_sheetColumnsGridLines = this.getGridLines(viewPropertyData, 109);
            this.m_titleVerticalGridLines = this.getGridLines(viewPropertyData, 119);
            this.m_titleHorizontalGridLines = this.getGridLines(viewPropertyData, 129);
            this.m_middleTierColumnGridLines = this.getGridLines(viewPropertyData, 139);
            this.m_bottomTierColumnGridLines = this.getGridLines(viewPropertyData, 149);
            this.m_ganttRowsGridLines = this.getGridLines(viewPropertyData, 159);
            this.m_barRowsGridLines = this.getGridLines(viewPropertyData, 169);
            this.m_currentDateGridLines = this.getGridLines(viewPropertyData, 179);
            this.m_pageBreakGridLines = this.getGridLines(viewPropertyData, 189);
            this.m_projectStartGridLines = this.getGridLines(viewPropertyData, 199);
            this.m_projectFinishGridLines = this.getGridLines(viewPropertyData, 209);
            this.m_statusDateGridLines = this.getGridLines(viewPropertyData, 219);
            this.m_nonWorkingDaysCalendarName = MPPUtility.getUnicodeString(viewPropertyData, 352);
            this.m_nonWorkingColor = ColorType.getInstance(viewPropertyData[1153]).getColor();
            this.m_nonWorkingPattern = ChartPattern.getInstance(viewPropertyData[1154]);
            this.m_nonWorkingStyle = NonWorkingTimeStyle.getInstance(viewPropertyData[1152]);
            this.m_ganttBarHeight = this.mapGanttBarHeight(MPPUtility.getByte(viewPropertyData, 1163));
            byte flags = viewPropertyData[228];
            this.m_timescaleMiddleTier = new TimescaleTier();
            this.m_timescaleMiddleTier.setTickLines((flags & 1) != 0);
            this.m_timescaleMiddleTier.setUsesFiscalYear((flags & 8) != 0);
            this.m_timescaleMiddleTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[242]));
            this.m_timescaleMiddleTier.setCount(viewPropertyData[246]);
            this.m_timescaleMiddleTier.setFormat(TimescaleFormat.getInstance(MPPUtility.getShort(viewPropertyData, 250)));
            this.m_timescaleMiddleTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[256] - 32));
            this.m_timescaleBottomTier = new TimescaleTier();
            this.m_timescaleBottomTier.setTickLines((flags & 2) != 0);
            this.m_timescaleBottomTier.setUsesFiscalYear((flags & 0x10) != 0);
            this.m_timescaleBottomTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[244]));
            this.m_timescaleBottomTier.setCount(viewPropertyData[248]);
            this.m_timescaleBottomTier.setFormat(TimescaleFormat.getInstance(MPPUtility.getShort(viewPropertyData, 252)));
            this.m_timescaleBottomTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[254] - 32));
            this.m_timescaleScaleSeparator = (flags & 4) != 0;
            this.m_timescaleSize = viewPropertyData[268];
            this.m_showDrawings = viewPropertyData[1156] != 0;
            this.m_roundBarsToWholeDays = viewPropertyData[1158] != 0;
            this.m_showBarSplits = viewPropertyData[1160] != 0;
            this.m_alwaysRollupGanttBars = viewPropertyData[1186] != 0;
            this.m_hideRollupBarsWhenSummaryExpanded = viewPropertyData[1188] != 0;
            this.m_barDateFormat = GanttBarDateFormat.getInstance(viewPropertyData[1182] + 1);
            this.m_linkStyle = LinkStyle.getInstance(viewPropertyData[1155]);
        }
        if ((timescaleData = props.getByteArray(TIMESCALE_PROPERTIES)) != null) {
            this.m_timescaleTopTier = new TimescaleTier();
            this.m_timescaleTopTier.setTickLines(timescaleData[48] != 0);
            this.m_timescaleTopTier.setUsesFiscalYear(timescaleData[60] != 0);
            this.m_timescaleTopTier.setUnits(TimescaleUnits.getInstance(timescaleData[30]));
            this.m_timescaleTopTier.setCount(timescaleData[32]);
            this.m_timescaleTopTier.setFormat(TimescaleFormat.getInstance(MPPUtility.getShort(timescaleData, 34)));
            this.m_timescaleTopTier.setAlignment(TimescaleAlignment.getInstance(timescaleData[36] - 20));
            this.m_topTierColumnGridLines = this.getGridLines(timescaleData, 39);
            this.m_timescaleShowTiers = timescaleData[0];
        }
    }

    private GridLines getGridLines(byte[] data, int offset) {
        Color normalLineColor = ColorType.getInstance(data[offset]).getColor();
        LineStyle normalLineStyle = LineStyle.getInstance(data[offset + 3]);
        byte intervalNumber = data[offset + 4];
        LineStyle intervalLineStyle = LineStyle.getInstance(data[offset + 5]);
        Color intervalLineColor = ColorType.getInstance(data[offset + 6]).getColor();
        return new GridLines(normalLineColor, normalLineStyle, intervalNumber, intervalLineStyle, intervalLineColor);
    }

    @Override
    protected void processTableFontStyles(Map<Integer, FontBase> fontBases, byte[] columnData) {
        this.m_tableFontStyles = new TableFontStyle[columnData.length / 16];
        int offset = 0;
        for (int loop = 0; loop < this.m_tableFontStyles.length; ++loop) {
            this.m_tableFontStyles[loop] = this.getColumnFontStyle(columnData, offset, fontBases);
            offset += 16;
        }
    }

    @Override
    protected void processProgressLines(Map<Integer, FontBase> fontBases, byte[] progressLineData) {
        this.m_progressLinesEnabled = progressLineData[0] != 0;
        this.m_progressLinesAtCurrentDate = progressLineData[2] != 0;
        this.m_progressLinesAtRecurringIntervals = progressLineData[4] != 0;
        this.m_progressLinesInterval = Interval.getInstance(progressLineData[6]);
        this.m_progressLinesIntervalDailyDayNumber = progressLineData[8];
        this.m_progressLinesIntervalDailyWorkday = progressLineData[10] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.SUNDAY.getValue()] = progressLineData[14] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.MONDAY.getValue()] = progressLineData[16] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.TUESDAY.getValue()] = progressLineData[18] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.WEDNESDAY.getValue()] = progressLineData[20] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.THURSDAY.getValue()] = progressLineData[22] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.FRIDAY.getValue()] = progressLineData[24] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.SATURDAY.getValue()] = progressLineData[26] != 0;
        this.m_progressLinesIntervalWeekleyWeekNumber = progressLineData[30];
        this.m_progressLinesIntervalMonthlyDay = progressLineData[32] != 0;
        this.m_progressLinesIntervalMonthlyDayDayNumber = progressLineData[34];
        this.m_progressLinesIntervalMonthlyDayMonthNumber = progressLineData[28];
        this.m_progressLinesIntervalMonthlyFirstLastDay = ProgressLineDay.getInstance(progressLineData[36]);
        this.m_progressLinesIntervalMonthlyFirstLast = progressLineData[40] == 1;
        this.m_progressLinesIntervalMonthlyFirstLastMonthNumber = progressLineData[30];
        this.m_progressLinesBeginAtProjectStart = progressLineData[44] != 0;
        this.m_progressLinesBeginAtDate = MPPUtility.getDate(progressLineData, 46);
        this.m_progressLinesDisplaySelected = progressLineData[48] != 0;
        this.m_progressLinesActualPlan = progressLineData[52] != 0;
        this.m_progressLinesDisplayType = MPPUtility.getShort(progressLineData, 54);
        this.m_progressLinesShowDate = progressLineData[56] != 0;
        this.m_progressLinesDateFormat = MPPUtility.getShort(progressLineData, 58);
        this.m_progressLinesFontStyle = this.getFontStyle(progressLineData, 60, fontBases);
        this.m_progressLinesCurrentLineColor = ColorType.getInstance(progressLineData[64]).getColor();
        this.m_progressLinesCurrentLineStyle = LineStyle.getInstance(progressLineData[65]);
        this.m_progressLinesCurrentProgressPointColor = ColorType.getInstance(progressLineData[66]).getColor();
        this.m_progressLinesCurrentProgressPointShape = progressLineData[67];
        this.m_progressLinesOtherLineColor = ColorType.getInstance(progressLineData[68]).getColor();
        this.m_progressLinesOtherLineStyle = LineStyle.getInstance(progressLineData[69]);
        this.m_progressLinesOtherProgressPointColor = ColorType.getInstance(progressLineData[70]).getColor();
        this.m_progressLinesOtherProgressPointShape = progressLineData[71];
        int dateCount = MPPUtility.getShort(progressLineData, 50);
        if (dateCount != 0) {
            this.m_progressLinesDisplaySelectedDates = new Date[dateCount];
            int offset = 72;
            for (int count = 0; count < dateCount && offset < progressLineData.length; offset += 2, ++count) {
                this.m_progressLinesDisplaySelectedDates[count] = MPPUtility.getDate(progressLineData, offset);
            }
        }
    }

    GanttChartView12(ProjectFile parent, byte[] fixedMeta, byte[] fixedData, Var2Data varData, Map<Integer, FontBase> fontBases) throws IOException {
        super(parent, fixedMeta, fixedData, varData, fontBases);
    }
}

