/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

final class FixedData
extends MPPComponent {
    private Object[] m_array;
    private int[] m_offset;

    FixedData(FixedMeta meta, InputStream is) throws IOException {
        this(meta, is, 0);
    }

    FixedData(FixedMeta meta, InputStream is, int maxExpectedSize) throws IOException {
        this(meta, is, maxExpectedSize, 0);
    }

    FixedData(FixedMeta meta, InputStream is, int maxExpectedSize, int minSize) throws IOException {
        byte[] buffer = new byte[is.available()];
        is.read(buffer);
        int itemCount = meta.getAdjustedItemCount();
        this.m_array = new Object[itemCount];
        this.m_offset = new int[itemCount];
        for (int loop = 0; loop < itemCount; ++loop) {
            int itemSize;
            byte[] metaData = meta.getByteArrayValue(loop);
            int itemOffset = MPPUtility.getInt(metaData, 4);
            if (itemOffset < 0 || itemOffset > buffer.length) continue;
            if (loop + 1 == itemCount) {
                itemSize = buffer.length - itemOffset;
            } else {
                byte[] nextMetaData = meta.getByteArrayValue(loop + 1);
                int nextItemOffset = MPPUtility.getInt(nextMetaData, 4);
                itemSize = nextItemOffset - itemOffset;
            }
            if (itemSize == 0) {
                itemSize = minSize;
            }
            int available = buffer.length - itemOffset;
            if (itemSize < 0 || itemSize > available) {
                itemSize = maxExpectedSize == 0 ? available : (maxExpectedSize < available ? maxExpectedSize : available);
            }
            if (maxExpectedSize != 0 && itemSize > maxExpectedSize) {
                itemSize = maxExpectedSize;
            }
            if (itemSize <= 0) continue;
            this.m_array[loop] = MPPUtility.cloneSubArray(buffer, itemOffset, itemSize);
            this.m_offset[loop] = itemOffset;
        }
    }

    FixedData(FixedMeta meta, int itemSize, InputStream is) throws IOException {
        byte[] buffer = new byte[is.available()];
        is.read(buffer);
        int itemCount = meta.getAdjustedItemCount();
        this.m_array = new Object[itemCount];
        this.m_offset = new int[itemCount];
        for (int loop = 0; loop < itemCount; ++loop) {
            byte[] metaData = meta.getByteArrayValue(loop);
            int itemOffset = MPPUtility.getInt(metaData, 4);
            if (itemOffset > buffer.length) continue;
            int available = buffer.length - itemOffset;
            if (itemSize < 0) {
                itemSize = available;
            } else if (itemSize > available) {
                itemSize = available;
            }
            this.m_array[loop] = MPPUtility.cloneSubArray(buffer, itemOffset, itemSize);
            this.m_offset[loop] = itemOffset;
        }
    }

    FixedData(int itemSize, InputStream is) throws IOException {
        this(itemSize, is, false);
    }

    FixedData(int itemSize, InputStream is, boolean readRemainderBlock) throws IOException {
        int offset = 0;
        int itemCount = is.available() / itemSize;
        if (readRemainderBlock && is.available() % itemSize != 0) {
            ++itemCount;
        }
        this.m_array = new Object[itemCount];
        this.m_offset = new int[itemCount];
        for (int loop = 0; loop < itemCount; ++loop) {
            this.m_offset[loop] = offset;
            int currentItemSize = itemSize;
            if (readRemainderBlock && is.available() < itemSize) {
                currentItemSize = is.available();
            }
            this.m_array[loop] = this.readByteArray(is, currentItemSize);
            offset += itemSize;
        }
    }

    public byte[] getByteArrayValue(int index) {
        byte[] result = null;
        if (index >= 0 && index < this.m_array.length && this.m_array[index] != null) {
            result = (byte[])this.m_array[index];
        }
        return result;
    }

    public int getItemCount() {
        return this.m_array.length;
    }

    public boolean isValidOffset(Integer offset) {
        return offset == null ? false : this.isValidOffset((int)offset);
    }

    public boolean isValidOffset(int offset) {
        return offset >= 0 && offset < this.m_array.length;
    }

    public int getIndexFromOffset(int offset) {
        int result = -1;
        for (int loop = 0; loop < this.m_offset.length; ++loop) {
            if (this.m_offset[loop] != offset) continue;
            result = loop;
            break;
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN FixedData");
        for (int loop = 0; loop < this.m_array.length; ++loop) {
            pw.println("   Data at index: " + loop + " offset: " + this.m_offset[loop]);
            pw.println("  " + MPPUtility.hexdump((byte[])this.m_array[loop], true));
        }
        pw.println("END FixedData");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

