/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public class CustomFieldValueReader9 {
    private final ProjectProperties m_properties;
    private final Props m_projectProps;
    private final CustomFieldContainer m_container;

    public CustomFieldValueReader9(ProjectProperties properties, Props projectProps, CustomFieldContainer container) {
        this.m_properties = properties;
        this.m_projectProps = projectProps;
        this.m_container = container;
    }

    public void process() {
        byte[] data = this.m_projectProps.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(data, offset);
            int numberOfValueLists = MPPUtility.getInt(data, offset += 4);
            offset += 4;
            int valueListOffset = 0;
            for (int index = 0; index < numberOfValueLists && offset < length; ++index) {
                FieldType field = FieldTypeHelper.getInstance(MPPUtility.getInt(data, offset));
                valueListOffset = MPPUtility.getInt(data, offset += 4);
                offset += 4;
                if (valueListOffset >= data.length) continue;
                int tempOffset = valueListOffset;
                int dataOffset = MPPUtility.getInt(data, tempOffset += 8) + valueListOffset;
                int endDataOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int endDescriptionOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int valuesLength = endDataOffset - dataOffset;
                byte[] values = new byte[valuesLength];
                MPPUtility.getByteArray(data, dataOffset, valuesLength, values, 0);
                int descriptionsLength = endDescriptionOffset - endDataOffset;
                byte[] descriptions = new byte[descriptionsLength];
                MPPUtility.getByteArray(data, endDataOffset, descriptionsLength, descriptions, 0);
                this.populateContainer(field, values, descriptions);
            }
        }
    }

    private void populateContainer(FieldType field, byte[] values, byte[] descriptions) {
        CustomField config = this.m_container.getCustomField(field);
        CustomFieldLookupTable table = config.getLookupTable();
        List<Object> descriptionList = this.convertType(DataType.STRING, descriptions);
        List<Object> valueList = this.convertType(field.getDataType(), values);
        for (int index = 0; index < descriptionList.size(); ++index) {
            CustomFieldValueItem item = new CustomFieldValueItem(0);
            item.setDescription((String)descriptionList.get(index));
            if (index < valueList.size()) {
                item.setValue(valueList.get(index));
            }
            table.add(item);
        }
    }

    private List<Object> convertType(DataType type, byte[] data) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        block8: while (index < data.length) {
            switch (type) {
                case STRING: {
                    Object value = MPPUtility.getUnicodeString(data, index);
                    result.add(value);
                    index += (((String)value).length() + 1) * 2;
                    continue block8;
                }
                case CURRENCY: {
                    Object value = MPPUtility.getDouble(data, index) / 100.0;
                    result.add(value);
                    index += 8;
                    continue block8;
                }
                case NUMERIC: {
                    Object value = MPPUtility.getDouble(data, index);
                    result.add(value);
                    index += 8;
                    continue block8;
                }
                case DATE: {
                    Object value = MPPUtility.getTimestamp(data, index);
                    result.add(value);
                    index += 4;
                    continue block8;
                }
                case DURATION: {
                    TimeUnit units = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, index + 4), this.m_properties.getDefaultDurationUnits());
                    Duration value = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(data, index), units);
                    result.add(value);
                    index += 6;
                    continue block8;
                }
                case BOOLEAN: {
                    Object value = MPPUtility.getShort(data, index) == 1;
                    result.add(value);
                    index += 2;
                    continue block8;
                }
            }
            index = data.length;
        }
        return result;
    }
}

