/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class CustomFieldValueReader14
extends CustomFieldValueReader {
    public CustomFieldValueReader14(ProjectProperties properties, CustomFieldContainer container, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2, Props taskProps) {
        super(properties, container, outlineCodeVarMeta, outlineCodeVarData, outlineCodeFixedData, outlineCodeFixedData2, taskProps);
    }

    @Override
    public void process() {
        int parentOffset;
        int fieldOffset;
        int typeOffset;
        Integer[] uniqueid = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        if (NumberHelper.getInt(this.m_properties.getApplicationVersion()) > 14) {
            typeOffset = 16;
            fieldOffset = 18;
            parentOffset = 10;
        } else {
            fieldOffset = 16;
            typeOffset = 32;
            parentOffset = 8;
        }
        Map<UUID, FieldType> map = this.populateCustomFieldMap();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            byte[] b2;
            Integer id = uniqueid[loop];
            CustomFieldValueItem item = new CustomFieldValueItem(id);
            byte[] value = this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_VALUE);
            item.setDescription(this.m_outlineCodeVarData.getUnicodeString(id, VALUE_LIST_DESCRIPTION));
            item.setUnknown(this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_UNKNOWN));
            byte[] b = this.m_outlineCodeFixedData.getByteArrayValue(loop + 3);
            if (b != null) {
                item.setParent(MPPUtility.getShort(b, parentOffset));
            }
            if ((b2 = this.m_outlineCodeFixedData2.getByteArrayValue(loop + 3)) == null) continue;
            item.setGuid(MPPUtility.getGUID(b2, 0));
            UUID parentField = MPPUtility.getGUID(b2, fieldOffset);
            int type = MPPUtility.getShort(b2, typeOffset);
            item.setValue(this.getTypedValue(type, value));
            FieldType field = map.get(parentField);
            if (field == null) continue;
            this.m_container.getCustomField(field).getLookupTable().add(item);
        }
    }

    private Map<UUID, FieldType> populateCustomFieldMap() {
        byte[] data = this.m_taskProps.getByteArray(Props.CUSTOM_FIELDS);
        HashMap<UUID, FieldType> map = new HashMap<UUID, FieldType>();
        int index = 44;
        while (index + 88 <= data.length) {
            FieldType field = FieldTypeHelper.getInstance(MPPUtility.getInt(data, index + 0));
            UUID guid = MPPUtility.getGUID(data, index + 36);
            map.put(guid, field);
            index += 88;
        }
        return map;
    }
}

