/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class CustomFieldValueReader12
extends CustomFieldValueReader {
    public CustomFieldValueReader12(ProjectProperties properties, CustomFieldContainer container, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2, Props taskProps) {
        super(properties, container, outlineCodeVarMeta, outlineCodeVarData, outlineCodeFixedData, outlineCodeFixedData2, taskProps);
    }

    @Override
    public void process() {
        Integer[] uniqueid = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        Map<UUID, FieldType> map = this.populateCustomFieldMap();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id = uniqueid[loop];
            CustomFieldValueItem item = new CustomFieldValueItem(id);
            byte[] value = this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_VALUE);
            item.setDescription(this.m_outlineCodeVarData.getUnicodeString(id, VALUE_LIST_DESCRIPTION));
            item.setUnknown(this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_UNKNOWN));
            byte[] b = this.m_outlineCodeFixedData.getByteArrayValue(loop + 3);
            if (b != null) {
                item.setParent(MPPUtility.getShort(b, 8));
            }
            byte[] b2 = this.m_outlineCodeFixedData2.getByteArrayValue(loop + 3);
            item.setGuid(MPPUtility.getGUID(b2, 0));
            UUID parentField = MPPUtility.getGUID(b2, 32);
            int type = MPPUtility.getShort(b2, 48);
            item.setValue(this.getTypedValue(type, value));
            FieldType field = map.get(parentField);
            this.m_container.getCustomField(field).getLookupTable().add(item);
        }
    }

    private Map<UUID, FieldType> populateCustomFieldMap() {
        byte[] data = this.m_taskProps.getByteArray(Props.CUSTOM_FIELDS);
        HashMap<UUID, FieldType> map = new HashMap<UUID, FieldType>();
        int index = 44;
        int recordCount = MPPUtility.getInt(data, index);
        index += 4;
        index += 8 * recordCount;
        while (index + 200 <= data.length) {
            FieldType field = FieldTypeHelper.getInstance(MPPUtility.getInt(data, index + 4));
            UUID guid = MPPUtility.getGUID(data, index + 160);
            map.put(guid, field);
            index += 200;
        }
        return map;
    }
}

