/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public abstract class CustomFieldValueReader {
    protected ProjectProperties m_properties;
    protected CustomFieldContainer m_container;
    protected VarMeta m_outlineCodeVarMeta;
    protected Var2Data m_outlineCodeVarData;
    protected FixedData m_outlineCodeFixedData;
    protected FixedData m_outlineCodeFixedData2;
    protected Props m_taskProps;
    public static final Integer VALUE_LIST_VALUE = 22;
    public static final Integer VALUE_LIST_DESCRIPTION = 8;
    public static final Integer VALUE_LIST_UNKNOWN = 23;

    public CustomFieldValueReader(ProjectProperties properties, CustomFieldContainer container, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2, Props taskProps) {
        this.m_properties = properties;
        this.m_container = container;
        this.m_outlineCodeVarMeta = outlineCodeVarMeta;
        this.m_outlineCodeVarData = outlineCodeVarData;
        this.m_outlineCodeFixedData = outlineCodeFixedData;
        this.m_outlineCodeFixedData2 = outlineCodeFixedData2;
        this.m_taskProps = taskProps;
    }

    public abstract void process() throws IOException;

    protected Object getTypedValue(int type, byte[] value) {
        Object result;
        switch (type) {
            case 4: {
                result = MPPUtility.getTimestamp(value, 0);
                break;
            }
            case 6: {
                TimeUnit units = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(value, 4), this.m_properties.getDefaultDurationUnits());
                result = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(value, 0), units);
                break;
            }
            case 9: {
                result = MPPUtility.getDouble(value, 0) / 100.0;
                break;
            }
            case 15: {
                result = MPPUtility.getDouble(value, 0);
                break;
            }
            case 21: 
            case 36058: {
                result = MPPUtility.getUnicodeString(value, 0);
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }
}

