/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Collections;
import java.util.Date;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.MPPUtility;

final class CostRateTableFactory {
    CostRateTableFactory() {
    }

    public void process(Resource resource, int index, byte[] data) {
        CostRateTable result = new CostRateTable();
        if (data != null) {
            int i = 16;
            while (i + 44 <= data.length) {
                Rate standardRate = new Rate(MPPUtility.getDouble(data, i), TimeUnit.HOURS);
                TimeUnit standardRateFormat = this.getFormat(MPPUtility.getShort(data, i + 8));
                Rate overtimeRate = new Rate(MPPUtility.getDouble(data, i + 16), TimeUnit.HOURS);
                TimeUnit overtimeRateFormat = this.getFormat(MPPUtility.getShort(data, i + 24));
                Double costPerUse = NumberHelper.getDouble(MPPUtility.getDouble(data, i + 32) / 100.0);
                Date endDate = MPPUtility.getTimestampFromTenths(data, i + 40);
                CostRateTableEntry entry = new CostRateTableEntry(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, costPerUse, endDate);
                result.add(entry);
                i += 44;
            }
            Collections.sort(result);
        } else if (index == 0) {
            Rate standardRate = resource.getStandardRate();
            Rate overtimeRate = resource.getOvertimeRate();
            Number costPerUse = resource.getCostPerUse();
            CostRateTableEntry entry = new CostRateTableEntry(standardRate, standardRate.getUnits(), overtimeRate, overtimeRate.getUnits(), costPerUse, CostRateTableEntry.DEFAULT_ENTRY.getEndDate());
            result.add(entry);
        } else {
            result.add(CostRateTableEntry.DEFAULT_ENTRY);
        }
        resource.setCostRateTable(index, result);
    }

    private TimeUnit getFormat(int format) {
        TimeUnit result = format == 65535 ? TimeUnit.HOURS : MPPUtility.getWorkTimeUnits(format);
        return result;
    }
}

