/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.MPPUtility;

final class AvailabilityFactory {
    AvailabilityFactory() {
    }

    public void process(AvailabilityTable table, byte[] data) {
        if (data != null) {
            Calendar cal = Calendar.getInstance();
            int items = MPPUtility.getShort(data, 0);
            int offset = 12;
            for (int loop = 0; loop < items; ++loop) {
                double unitsValue = MPPUtility.getDouble(data, offset + 4);
                if (unitsValue != 0.0) {
                    Date startDate = MPPUtility.getTimestampFromTenths(data, offset);
                    Date endDate = MPPUtility.getTimestampFromTenths(data, offset + 20);
                    cal.setTime(endDate);
                    cal.add(12, -1);
                    endDate = cal.getTime();
                    Double units = NumberHelper.getDouble(unitsValue / 100.0);
                    Availability item = new Availability(startDate, endDate, units);
                    table.add(item);
                }
                offset += 20;
            }
            Collections.sort(table);
        }
    }
}

