/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.merlin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.merlin.Row;
import net.sf.mpxj.merlin.SqliteResultSetRow;
import net.sf.mpxj.reader.ProjectReader;
import org.sqlite.JDBC;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MerlinReader
implements ProjectReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Integer m_projectID = 1;
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;
    private DocumentBuilder m_documentBuilder;
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private XPathExpression m_dayTimeIntervals;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        File file = null;
        try {
            file = InputStreamHelper.writeStreamToTempFile(stream, ".sqlite");
            ProjectFile projectFile = this.read(file);
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("", ex);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        return this.read(new File(fileName));
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        File databaseFile = file.isDirectory() ? new File(file, "state.sql") : file;
        return this.readFile(databaseFile);
    }

    private ProjectFile readFile(File file) throws MPXJException {
        try {
            String url = "jdbc:sqlite:" + file.getAbsolutePath();
            Properties props = new Properties();
            this.m_connection = JDBC.createConnection((String)url, (Properties)props);
            this.m_documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            this.m_dayTimeIntervals = xpath.compile("/array/dayTimeInterval");
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid format", ex);
        }
        finally {
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException ex) {}
            }
            this.m_documentBuilder = null;
            this.m_dayTimeIntervals = null;
        }
    }

    private ProjectFile read() throws Exception {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoCalendarUniqueID(false);
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        this.m_project.getProjectProperties().setFileApplication("Merlin");
        this.m_project.getProjectProperties().setFileType("SQLITE");
        this.m_eventManager.addProjectListeners(this.m_projectListeners);
        this.processProject();
        this.processCalendars();
        this.processResources();
        this.processTasks();
        this.processAssignments();
        this.processDependencies();
        return this.m_project;
    }

    private void processProject() throws SQLException {
        ProjectProperties props = this.m_project.getProjectProperties();
        Row row = this.getRows("select * from zproject where z_pk=?", this.m_projectID).get(0);
        props.setWeekStartDay(Day.getInstance(row.getInt("ZFIRSTDAYOFWEEK") + 1));
        props.setScheduleFrom(row.getInt("ZSCHEDULINGDIRECTION") == 1 ? ScheduleFrom.START : ScheduleFrom.FINISH);
        props.setMinutesPerDay(row.getInt("ZHOURSPERDAY") * 60);
        props.setDaysPerMonth(row.getInteger("ZDAYSPERMONTH"));
        props.setMinutesPerWeek(row.getInt("ZHOURSPERWEEK") * 60);
        props.setStatusDate(row.getTimestamp("ZGIVENSTATUSDATE"));
        props.setCurrencySymbol(row.getString("ZCURRENCYSYMBOL"));
        props.setName(row.getString("ZTITLE"));
        props.setUniqueID(row.getUUID("ZUNIQUEID").toString());
    }

    private void processCalendars() throws Exception {
        List<Row> rows = this.getRows("select * from zcalendar where zproject=?", this.m_projectID);
        for (Row row : rows) {
            ProjectCalendar calendar = this.m_project.addCalendar();
            calendar.setUniqueID(row.getInteger("Z_PK"));
            calendar.setName(row.getString("ZTITLE"));
            this.processDays(calendar);
            this.processExceptions(calendar);
            this.m_eventManager.fireCalendarReadEvent(calendar);
        }
    }

    private void processDays(ProjectCalendar calendar) throws Exception {
        for (Day day : Day.values()) {
            calendar.setWorkingDay(day, false);
        }
        List<Row> rows = this.getRows("select * from zcalendarrule where zcalendar1=? and z_ent=13", calendar.getUniqueID());
        for (Row row : rows) {
            Day day;
            day = row.getDay("ZWEEKDAY");
            String timeIntervals = row.getString("ZTIMEINTERVALS");
            if (timeIntervals == null) {
                calendar.setWorkingDay(day, false);
                continue;
            }
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            NodeList nodes = this.getNodeList(timeIntervals, this.m_dayTimeIntervals);
            calendar.setWorkingDay(day, nodes.getLength() > 0);
            for (int loop = 0; loop < nodes.getLength(); ++loop) {
                NamedNodeMap attributes = nodes.item(loop).getAttributes();
                Date startTime = this.m_calendarTimeFormat.parse(attributes.getNamedItem("startTime").getTextContent());
                Date endTime = this.m_calendarTimeFormat.parse(attributes.getNamedItem("endTime").getTextContent());
                if (startTime.getTime() >= endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                hours.addRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void processExceptions(ProjectCalendar calendar) throws Exception {
        List<Row> rows = this.getRows("select * from zcalendarrule where zcalendar=? and z_ent=12", calendar.getUniqueID());
        for (Row row : rows) {
            Date startDay = row.getDate("ZSTARTDAY");
            Date endDay = row.getDate("ZENDDAY");
            ProjectCalendarException exception = calendar.addCalendarException(startDay, endDay);
            String timeIntervals = row.getString("ZTIMEINTERVALS");
            if (timeIntervals == null) continue;
            NodeList nodes = this.getNodeList(timeIntervals, this.m_dayTimeIntervals);
            for (int loop = 0; loop < nodes.getLength(); ++loop) {
                NamedNodeMap attributes = nodes.item(loop).getAttributes();
                Date startTime = this.m_calendarTimeFormat.parse(attributes.getNamedItem("startTime").getTextContent());
                Date endTime = this.m_calendarTimeFormat.parse(attributes.getNamedItem("endTime").getTextContent());
                if (startTime.getTime() >= endTime.getTime()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endTime);
                    cal.add(6, 1);
                    endTime = cal.getTime();
                }
                exception.addRange(new DateRange(startTime, endTime));
            }
        }
    }

    private void processResources() throws SQLException {
        List<Row> rows = this.getRows("select * from zresource where zproject=? order by zorderinproject", this.m_projectID);
        for (Row row : rows) {
            ProjectCalendar calendar;
            Integer calendarID;
            Resource resource = this.m_project.addResource();
            resource.setUniqueID(row.getInteger("Z_PK"));
            resource.setEmailAddress(row.getString("ZEMAIL"));
            resource.setInitials(row.getString("ZINITIALS"));
            resource.setName(row.getString("ZTITLE_"));
            resource.setGUID(row.getUUID("ZUNIQUEID"));
            resource.setType(row.getResourceType("ZTYPE"));
            resource.setMaterialLabel(row.getString("ZMATERIALUNIT"));
            if (resource.getType() == ResourceType.WORK) {
                resource.setMaxUnits(NumberHelper.getDouble(row.getDouble("ZAVAILABLEUNITS_")) * 100.0);
            }
            if ((calendarID = row.getInteger("ZRESOURCECALENDAR")) != null && (calendar = this.m_project.getCalendarByUniqueID(calendarID)) != null) {
                calendar.setName(resource.getName());
                resource.setResourceCalendar(calendar);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks() throws SQLException {
        List<Row> rows = this.getRows("select * from zscheduleitem where zproject=? and zparentactivity_ is null and z_ent=45 order by zorderinparentactivity", this.m_projectID);
        for (Row row : rows) {
            Task task = this.m_project.addTask();
            this.populateTask(row, task);
            this.processChildTasks(task);
        }
    }

    private void processChildTasks(Task parentTask) throws SQLException {
        List<Row> rows = this.getRows("select * from zscheduleitem where zparentactivity_=? and z_ent=45 order by zorderinparentactivity", parentTask.getUniqueID());
        for (Row row : rows) {
            Task task = parentTask.addTask();
            this.populateTask(row, task);
            this.processChildTasks(task);
        }
    }

    private void populateTask(Row row, Task task) {
        ProjectCalendar calendar;
        task.setUniqueID(row.getInteger("Z_PK"));
        task.setName(row.getString("ZTITLE"));
        task.setPriority(Priority.getInstance(row.getInt("ZPRIORITY")));
        task.setMilestone(row.getBoolean("ZISMILESTONE"));
        task.setActualFinish(row.getTimestamp("ZGIVENACTUALENDDATE_"));
        task.setActualStart(row.getTimestamp("ZGIVENACTUALSTARTDATE_"));
        task.setNotes(row.getString("ZOBJECTDESCRIPTION"));
        task.setDuration(row.getDuration("ZGIVENDURATION_"));
        task.setOvertimeWork(row.getWork("ZGIVENWORKOVERTIME_"));
        task.setWork(row.getWork("ZGIVENWORK_"));
        task.setLevelingDelay(row.getDuration("ZLEVELINGDELAY_"));
        task.setActualOvertimeWork(row.getWork("ZGIVENACTUALWORKOVERTIME_"));
        task.setActualWork(row.getWork("ZGIVENACTUALWORK_"));
        task.setRemainingWork(row.getWork("ZGIVENACTUALWORK_"));
        task.setGUID(row.getUUID("ZUNIQUEID"));
        Integer calendarID = row.getInteger("ZGIVENCALENDAR");
        if (calendarID != null && (calendar = this.m_project.getCalendarByUniqueID(calendarID)) != null) {
            task.setCalendar(calendar);
        }
        this.populateConstraints(row, task);
        this.m_eventManager.fireTaskReadEvent(task);
    }

    private void populateConstraints(Row row, Task task) {
        Date endDateMax = row.getTimestamp("ZGIVENENDDATEMAX_");
        Date endDateMin = row.getTimestamp("ZGIVENENDDATEMIN_");
        Date startDateMax = row.getTimestamp("ZGIVENSTARTDATEMAX_");
        Date startDateMin = row.getTimestamp("ZGIVENSTARTDATEMIN_");
        ConstraintType constraintType = null;
        Date constraintDate = null;
        if (endDateMax != null) {
            constraintType = ConstraintType.FINISH_NO_LATER_THAN;
            constraintDate = endDateMax;
        }
        if (endDateMin != null) {
            constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
            constraintDate = endDateMin;
        }
        if (endDateMin != null && endDateMin == endDateMax) {
            constraintType = ConstraintType.MUST_FINISH_ON;
            constraintDate = endDateMin;
        }
        if (startDateMax != null) {
            constraintType = ConstraintType.START_NO_LATER_THAN;
            constraintDate = startDateMax;
        }
        if (startDateMin != null) {
            constraintType = ConstraintType.START_NO_EARLIER_THAN;
            constraintDate = startDateMin;
        }
        if (startDateMin != null && startDateMin == endDateMax) {
            constraintType = ConstraintType.MUST_START_ON;
            constraintDate = endDateMin;
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    private void processAssignments() throws SQLException {
        List<Row> rows = this.getRows("select * from zscheduleitem where zproject=? and z_ent=47 order by zorderinactivity", this.m_projectID);
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ZACTIVITY_"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("ZRESOURCE"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setGUID(row.getUUID("ZUNIQUEID"));
            assignment.setActualFinish(row.getTimestamp("ZGIVENACTUALENDDATE_"));
            assignment.setActualStart(row.getTimestamp("ZGIVENACTUALSTARTDATE_"));
            assignment.setWork(this.assignmentDuration(task, row.getWork("ZGIVENWORK_")));
            assignment.setOvertimeWork(this.assignmentDuration(task, row.getWork("ZGIVENWORKOVERTIME_")));
            assignment.setActualWork(this.assignmentDuration(task, row.getWork("ZGIVENACTUALWORK_")));
            assignment.setActualOvertimeWork(this.assignmentDuration(task, row.getWork("ZGIVENACTUALWORKOVERTIME_")));
            assignment.setRemainingWork(this.assignmentDuration(task, row.getWork("ZGIVENREMAININGWORK_")));
            assignment.setLevelingDelay(row.getDuration("ZLEVELINGDELAY_"));
            if (assignment.getRemainingWork() == null) {
                assignment.setRemainingWork(assignment.getWork());
            }
            if (resource.getType() != ResourceType.WORK) continue;
            assignment.setUnits(NumberHelper.getDouble(row.getDouble("ZRESOURCEUNITS_")) * 100.0);
        }
    }

    private Duration assignmentDuration(Task task, Duration work) {
        Duration taskWork;
        Duration result = work;
        if (result != null && result.getUnits() == TimeUnit.PERCENT && (taskWork = task.getWork()) != null) {
            result = Duration.getInstance(taskWork.getDuration() * result.getDuration(), taskWork.getUnits());
        }
        return result;
    }

    private void processDependencies() throws SQLException {
        List<Row> rows = this.getRows("select * from zdependency where zproject=?", this.m_projectID);
        for (Row row : rows) {
            Task nextTask = this.m_project.getTaskByUniqueID(row.getInteger("ZNEXTACTIVITY_"));
            Task prevTask = this.m_project.getTaskByUniqueID(row.getInteger("ZPREVIOUSACTIVITY_"));
            Duration lag = row.getDuration("ZLAG_");
            RelationType type = row.getRelationType("ZTYPE");
            nextTask.addPredecessor(prevTask, type, lag);
        }
    }

    private List<Row> getRows(String sql, Integer var) throws SQLException {
        LinkedList<Row> result = new LinkedList<Row>();
        this.m_ps = this.m_connection.prepareStatement(sql);
        this.m_ps.setInt(1, NumberHelper.getInt(var));
        this.m_rs = this.m_ps.executeQuery();
        this.populateMetaData();
        while (this.m_rs.next()) {
            result.add(new SqliteResultSetRow(this.m_rs, this.m_meta));
        }
        return result;
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop);
            Integer type = meta.getColumnType(loop);
            this.m_meta.put(name, type);
        }
    }

    private NodeList getNodeList(String document, XPathExpression expression) throws Exception {
        Document doc = this.m_documentBuilder.parse(new InputSource(new StringReader(document)));
        return (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
    }
}

