/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.json;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.json.JsonStreamWriter;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class JsonWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private JsonStreamWriter m_writer;
    private boolean m_pretty;
    private Charset m_encoding = DEFAULT_ENCODING;
    private static final Charset DEFAULT_ENCODING = CharsetHelper.UTF8;
    private static Map<String, DataType> TYPE_MAP = new HashMap<String, DataType>();

    public boolean getPretty() {
        return this.m_pretty;
    }

    public void setPretty(boolean pretty) {
        this.m_pretty = pretty;
    }

    public Charset getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(Charset encoding) {
        this.m_encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            this.m_writer = new JsonStreamWriter(stream, this.m_encoding);
            this.m_writer.setPretty(this.m_pretty);
            this.m_writer.writeStartObject(null);
            this.writeCustomFields();
            this.writeProperties();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            this.m_writer.writeEndObject();
            this.m_writer.flush();
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void writeCustomFields() throws IOException {
        this.m_writer.writeStartList("custom_fields");
        for (CustomField field : this.m_projectFile.getCustomFields()) {
            this.writeCustomField(field);
        }
        this.m_writer.writeEndList();
    }

    private void writeCustomField(CustomField field) throws IOException {
        if (field.getAlias() != null) {
            this.m_writer.writeStartObject(null);
            this.m_writer.writeNameValuePair("field_type_class", field.getFieldType().getFieldTypeClass().name().toLowerCase());
            this.m_writer.writeNameValuePair("field_type", field.getFieldType().name().toLowerCase());
            this.m_writer.writeNameValuePair("field_alias", field.getAlias());
            this.m_writer.writeEndObject();
        }
    }

    private void writeProperties() throws IOException {
        this.writeAttributeTypes("property_types", ProjectField.values());
        this.writeFields("property_values", this.m_projectFile.getProjectProperties(), ProjectField.values());
    }

    private void writeResources() throws IOException {
        this.writeAttributeTypes("resource_types", ResourceField.values());
        this.m_writer.writeStartList("resources");
        for (Resource resource : this.m_projectFile.getResources()) {
            this.writeFields(null, resource, ResourceField.values());
        }
        this.m_writer.writeEndList();
    }

    private void writeTasks() throws IOException {
        this.writeAttributeTypes("task_types", TaskField.values());
        this.m_writer.writeStartList("tasks");
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
        this.m_writer.writeEndList();
    }

    private void writeTask(Task task) throws IOException {
        this.writeFields(null, task, TaskField.values());
        for (Task child : task.getChildTasks()) {
            this.writeTask(child);
        }
    }

    private void writeAssignments() throws IOException {
        this.writeAttributeTypes("assignment_types", AssignmentField.values());
        this.m_writer.writeStartList("assignments");
        for (ResourceAssignment assignment : this.m_projectFile.getResourceAssignments()) {
            this.writeFields(null, assignment, AssignmentField.values());
        }
        this.m_writer.writeEndList();
    }

    private void writeAttributeTypes(String name, FieldType[] types) throws IOException {
        this.m_writer.writeStartObject(name);
        for (FieldType field : types) {
            this.m_writer.writeNameValuePair(field.name().toLowerCase(), field.getDataType().getValue());
        }
        this.m_writer.writeEndObject();
    }

    private void writeFields(String objectName, FieldContainer container, FieldType[] fields) throws IOException {
        this.m_writer.writeStartObject(objectName);
        for (FieldType field : fields) {
            Object value = container.getCurrentValue(field);
            if (value == null) continue;
            this.writeField(field, value);
        }
        this.m_writer.writeEndObject();
    }

    private void writeField(FieldType field, Object value) throws IOException {
        String fieldName = field.name().toLowerCase();
        this.writeField(fieldName, field.getDataType(), value);
    }

    private void writeField(String fieldName, DataType fieldType, Object value) throws IOException {
        switch (fieldType) {
            case INTEGER: {
                this.writeIntegerField(fieldName, value);
                break;
            }
            case PERCENTAGE: 
            case CURRENCY: 
            case NUMERIC: 
            case UNITS: {
                this.writeDoubleField(fieldName, value);
                break;
            }
            case BOOLEAN: {
                this.writeBooleanField(fieldName, value);
                break;
            }
            case WORK: 
            case DURATION: {
                this.writeDurationField(fieldName, value);
                break;
            }
            case DATE: {
                this.writeDateField(fieldName, value);
                break;
            }
            case TIME_UNITS: {
                this.writeTimeUnitsField(fieldName, value);
                break;
            }
            case PRIORITY: {
                this.writePriorityField(fieldName, value);
                break;
            }
            case RELATION_LIST: {
                this.writeRelationList(fieldName, value);
                break;
            }
            case MAP: {
                this.writeMap(fieldName, value);
                break;
            }
            case BINARY: {
                break;
            }
            default: {
                this.writeStringField(fieldName, value);
            }
        }
    }

    private void writeIntegerField(String fieldName, Object value) throws IOException {
        int val = ((Number)value).intValue();
        if (val != 0) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeDoubleField(String fieldName, Object value) throws IOException {
        double val = ((Number)value).doubleValue();
        if (val != 0.0) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeBooleanField(String fieldName, Object value) throws IOException {
        boolean val = (Boolean)value;
        if (val) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeDurationField(String fieldName, Object value) throws IOException {
        if (value instanceof String) {
            this.m_writer.writeNameValuePair(fieldName + "_text", (String)value);
        } else {
            Duration val = (Duration)value;
            if (val.getDuration() != 0.0) {
                Duration minutes = val.convertUnits(TimeUnit.MINUTES, this.m_projectFile.getProjectProperties());
                long seconds = (long)(minutes.getDuration() * 60.0);
                this.m_writer.writeNameValuePair(fieldName, seconds);
            }
        }
    }

    private void writeDateField(String fieldName, Object value) throws IOException {
        if (value instanceof String) {
            this.m_writer.writeNameValuePair(fieldName + "_text", (String)value);
        } else {
            Date val = (Date)value;
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeTimeUnitsField(String fieldName, Object value) throws IOException {
        TimeUnit val = (TimeUnit)value;
        if (val != this.m_projectFile.getProjectProperties().getDefaultDurationUnits()) {
            this.m_writer.writeNameValuePair(fieldName, val.toString());
        }
    }

    private void writePriorityField(String fieldName, Object value) throws IOException {
        this.m_writer.writeNameValuePair(fieldName, ((Priority)value).getValue());
    }

    private void writeMap(String fieldName, Object value) throws IOException {
        Map map = (Map)value;
        this.m_writer.writeStartObject(fieldName);
        for (Map.Entry entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue == null) continue;
            DataType type = TYPE_MAP.get(entryValue.getClass().getName());
            if (type == null) {
                type = DataType.STRING;
                entryValue = entryValue.toString();
            }
            this.writeField((String)entry.getKey(), type, entryValue);
        }
        this.m_writer.writeEndObject();
    }

    private void writeStringField(String fieldName, Object value) throws IOException {
        String val = value.toString();
        if (!val.isEmpty()) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeRelationList(String fieldName, Object value) throws IOException {
        List list = (List)value;
        if (!list.isEmpty()) {
            this.m_writer.writeStartList(fieldName);
            for (Relation relation : list) {
                this.m_writer.writeStartObject(null);
                this.writeIntegerField("task_unique_id", relation.getTargetTask().getUniqueID());
                this.writeDurationField("lag", relation.getLag());
                this.writeStringField("type", relation.getType());
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndList();
        }
    }

    static {
        TYPE_MAP.put(Boolean.class.getName(), DataType.BOOLEAN);
        TYPE_MAP.put(Date.class.getName(), DataType.DATE);
        TYPE_MAP.put(Double.class.getName(), DataType.NUMERIC);
        TYPE_MAP.put(Duration.class.getName(), DataType.DURATION);
        TYPE_MAP.put(Integer.class.getName(), DataType.INTEGER);
    }
}

