/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class NumberColumn
extends AbstractColumn {
    NumberColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 18;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset);
        offset = data.getOffset();
        byte[][] rawData = data.getData();
        this.m_data = new Double[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            this.m_data[index] = FastTrackUtility.getDouble(rawData[index], 0);
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        pw.println("  [Data");
        for (Object item : this.m_data) {
            pw.println("    " + item);
        }
        pw.println("  ]");
    }
}

